package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataQuery;

/**
 *
 * @author PII
 */
public class JoinDataAdapter implements DataAdapter<Map<?, ?>>
{
    @Override
    public List<Map<?, ?>> getData(DataQuery dataQuery)
    {
        List<Map<?, ?>> ret = new ArrayList<>();
        String leftQueryName = dataQuery.getProperty("leftQueryName");
        String rightQueryName = dataQuery.getProperty("rightQueryName");
        String leftJoinColumn = dataQuery.getProperty("leftJoinColumn");
        String rightJoinColumn = dataQuery.getProperty("rightJoinColumn");
        DataManager dataManager = dataQuery.getDataManager();

        DataQuery leftQuery = dataManager.getQuery(leftQueryName, dataQuery, "left.");

        // FIXME: leftQuery doesn't return a checked List, so we don't know it's full of Maps.
        List<Map> leftResults = leftQuery.getResults();

        for (Map leftResult : leftResults) {
            Object leftJoinValue = getValue(leftResult, leftJoinColumn);
            DataQuery rightQuery = dataManager.getQuery(rightQueryName, dataQuery, "right.");
            if (leftJoinValue != null && rightQuery.isParameter(rightJoinColumn)) {
                rightQuery.setParameter(rightJoinColumn, leftJoinValue);
                List<Map> rightResults = rightQuery.getResults();
                for (Map rightResult : rightResults) {
                    Map retResult = new HashMap();
                    retResult.putAll(leftResult);
                    retResult.putAll(rightResult);
                    ret.add(retResult);
                }
            }
        }

        return ret;
    }

    private Object getValue(Object bean, String property)
    {
        Object ret;

        try {
            ret = PropertyUtils.getProperty(bean, property);
        }
        // CCR 179231
        catch (Exception e) {
            return new DataAdapterException("Exception occurred during the data retrieval", e);
        }

        return ret;
    }
}
