package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.config.FieldType;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;

/**
 *
 * @author David Vazquez
 *
 */
public class CompositeDataAdapter implements DataAdapter<Map<String, Object>>
{
    private static final Logger logger = LoggerFactory.getLogger(CompositeDataAdapter.class);

    @Override
    public List<Map<String, Object>> getData(DataQuery dataQuery)
    {
        List<Map<String, Object>> ret = new ArrayList<>();
        DataManager dataManager = dataQuery.getDataManager();
        String queryNames = dataQuery.getProperty("queryNames");

        if (NullChecker.isNullOrEmpty(queryNames)) {
            throw new DataManagerException("queryNames must be specified");
        }

        HashMap<String, Object> result = new HashMap<>();

        for (String queryName : queryNames.split(",")) {
            DataQuery subQuery = dataManager.getQuery(queryName, dataQuery);
            for (String paramName : dataQuery.getParameterNames()) {
                if(subQuery.isParameter(paramName) && NullChecker.isNullOrEmpty(subQuery.getParameter(paramName))) {
                    subQuery.setParameter(paramName, dataQuery.getParameter(paramName));
                }
            }

            PropertiesType setProperties = dataQuery.getProperties(queryName + ".setProperties");
            if (setProperties != null) {
                for (PropertyType setProperty : setProperties.getProperty()) {
                    subQuery.setProperty(setProperty.getName(), dataQuery.getParameter(setProperty.getValue()).toString());
                }
            }

            // removed try/catch that was masking errors.
            List subResults = subQuery.getResults();
            if (!NullChecker.isNullOrEmpty(subResults)) {
                result.put(queryName, subResults);
                FieldType type = dataQuery.getQueryParameterBySource(queryName);
                if (NullChecker.isNotNullOrEmpty(type)) {
                    dataQuery.setParameter(type.getName(), subResults);
                }
            }
        }

        if (!result.isEmpty()) {
            ret.add(result);
        }

        return ret;
    }
}
