package gov.va.med.nhin.adapter.datamanager;

import gov.va.med.nhin.adapter.datamanager.config.FieldType;
import java.util.List;

import gov.va.med.nhin.adapter.utils.config.PropertiesType;

/**
 *
 * @author David Vazquez
 */
public interface DataQuery
{
	// RTC CCR 179231 - added exceptions
	public String getName() throws DataManagerException;

	public List getResults() throws DataManagerException;

	public <T> List<T> getResults(Class<T> cls) throws DataManagerException;

	public void setParameter(String name, Object value) throws InvalidArguementException;

	public Object getParameter(String name) throws DataManagerException;

	public String[] getParameterNames() throws DataManagerException;

	public Object getParameterBySource(String name) throws DataManagerException;

	public String[] getParameterBySourceNames() throws DataManagerException;
        
        public FieldType getQueryParameterBySource(String name) throws DataManagerException;
        
        public List<FieldType> getQueryParameters() throws DataManagerException;

	public String[] getResultNames() throws DataManagerException;

	public String[] getResultBySourceNames() throws DataManagerException;

	public boolean isParameter(String name) throws DataManagerException;

	public boolean isResult(String name) throws DataManagerException;

	public void setProperty(String name, String value) throws DataManagerException;

	public String getProperty(String name) throws DataManagerException;

	public PropertiesType getProperties(String name) throws DataManagerException;

	public String[] getPropertyNames() throws DataManagerException;

	public DataManager getDataManager() throws DataManagerException;
}
