package gov.va.med.nhin.adapter.utils.socketlistener;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v24.message.ACK;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import gov.va.med.nhin.adapter.utils.NullChecker;

import static gov.va.med.nhin.adapter.utils.encoders.MLLPEncoder.*;

/**
 *
 * @author David Vazquez
 */
public class MLLPSocketHandler implements SocketHandler
{
	public static final Logger logger = LoggerFactory.getLogger(MLLPSocketHandler.class.getName());

	static public final int BUFFER_SIZE = 512;

	public void handleSocket(Socket s)
	{
		try
		{
			BufferedReader reader = new BufferedReader(new InputStreamReader(s.getInputStream()));
			BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));

			String message = receive(reader, FSCR);
			while(!NullChecker.isNullOrEmpty(message))
			{
				String decodedMessage = decode(message);
				logger.debug("handleSocket - Received message: ", decodedMessage);
				String response = processMessage(decodedMessage);
				logger.debug("handleSocket- Sending response: ", response);
				send(writer, encode(response));
				message = receive(reader, FSCR);
			}
		}
		catch(IOException ioe)
		{
			throw new IllegalArgumentException("Error while processing input", ioe);
		}
		catch(Throwable t)
		{
			throw new RuntimeException("Error", t);
		}
	}

	protected String receive(Reader reader, String endMarker)
	{
		StringBuffer ret = new StringBuffer();

		try
		{
			char[] buffer = new char[BUFFER_SIZE];
			int count = 0;
			while(count != -1 && ret.indexOf(endMarker) == -1)
			{
				count = reader.read(buffer);
				if(count != -1)
				{
					ret.append(buffer, 0, count);
				}
				else
				{
					ret.delete(0, ret.length());
				}
			}
		}
		catch(Throwable t)
		{
			t.printStackTrace();
			ret.delete(0, ret.length());
		}

		return ret.toString();
	}

	protected void send(Writer writer, String data)
	{
		try
		{
			writer.write(data);
			writer.flush();
		}
		catch(Throwable t)
		{
			t.printStackTrace();
		}
	}

	private String processMessage(String msg) throws Exception
	{
		String ret = "";
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmssZ");
		Date currentTime = new Date();
		PipeParser parser = new PipeParser();
		Message message = parser.parse(msg);
		Terser terser = new Terser(message);

		ACK responseMessage = new ACK();
		Terser responseTerser = new Terser(responseMessage);

		responseTerser.set("/MSH-1", terser.get("/MSH-1"));
		responseTerser.set("/MSH-2", terser.get("/MSH-2"));
		responseTerser.set("/MSH-3", terser.get("/MSH-5"));
		responseTerser.set("/MSH-4", terser.get("/MSH-6"));
		responseTerser.set("/MSH-5", terser.get("/MSH-3"));
		responseTerser.set("/MSH-6", terser.get("/MSH-4"));
		responseTerser.set("/MSH-7", formatter.format(currentTime));
		responseTerser.set("/MSH-9", "ACK");
		responseTerser.set("/MSH-10", Long.toString(currentTime.getTime()));
		responseTerser.set("/MSH-11", terser.get("/MSH-11"));
		responseTerser.set("/MSH-12", terser.get("/MSH-12"));
		responseTerser.set("/MSA-1", "CA");
		responseTerser.set("/MSA-2", terser.get("/MSH-10"));

		ret = parser.encode(responseMessage);

		return ret;
	}
}
