package gov.va.med.nhin.adapter.datamanager.translators;

import java.io.FileOutputStream;
import java.io.IOException;

import javax.xml.XMLConstants;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author PII
 */
public class DOMToFileDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) throws IOException {
		String path = translation.getProperty("path");

		if(input != null)
		{
			if(!(input instanceof Document))
			{
				throw new DataManagerException("input must be of type org.w3c.dom.Document.");
			}

			FileOutputStream fos = null;

			try
			{
				Source source = new DOMSource((Document) input);

				fos = new FileOutputStream(path);
				Result rslt = new StreamResult(fos);

				TransformerFactory transFact = TransformerFactory.newInstance();
				transFact.setAttribute(XMLConstants.ACCESS_EXTERNAL_DTD, "");
				Transformer trans = transFact.newTransformer();
				trans.transform(source, rslt);
			}
			catch(Throwable t)
			{
				throw new DataManagerException("An error occurred.", t);
			}
			finally {
				if(fos != null)
				{
					fos.close();
				}
			}
		}

		return input;
	}
}
