package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.Properties;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.PropertiesCollectionFactory;
import gov.va.med.nhin.adapter.utils.transceiver.HL7DCLLPSocketTransceiver;

/**
 *
 * @author David Vazquez
 */
public class HL7DCLLPDataAdapter extends HL7DataAdapter
{
	@Override
	String sendMessage(DataQuery dataQuery, String message) throws Exception
	{
		String ret;
		String connectionFilename = dataQuery.getProperty("connectionFilename");
		String connection = dataQuery.getProperty("connection");
		Properties propertiesCollection = PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
		Properties connectionProperties = (Properties) propertiesCollection.get(connection);

		if(!NullChecker.isNullOrEmpty(connectionProperties))
		{
			String host = connectionProperties.getProperty("host");
			int port = Integer.parseInt(connectionProperties.getProperty("port"));
			int timeout = Integer.parseInt(connectionProperties.getProperty("timeout"));

			HL7DCLLPSocketTransceiver transceiver = new HL7DCLLPSocketTransceiver(host, port, timeout);
			ret = transceiver.transceive(message);
		}
		else
		{
			throw new RuntimeException("Error getting connection properties for " + connection + " in file " + connectionFilename + ".");
		}

		return ret;
	}
}
