/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.patientdiscovery;
import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQueryPortType;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType;
import gov.hhs.fha.nhinc.patientdb.model.Patient;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingAdapterPolicyEngine;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.mvi.AdapterMviPortTypeLocal;
import gov.va.med.nhin.adapter.patientcorrelation.PatientCorrelationPortTypeLocal;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.utils.das.DasDAO;
import gov.va.med.nhin.adapter.utils.das.DasOperationSendACPDocumentRequest;
import gov.va.med.nhin.adapter.utils.das.DasOperationSendACPDocumentResponse;
import gov.va.nvap.privacy.ConsentDirectiveQueryRequestType;
import gov.va.nvap.privacy.ConsentDirectiveQueryResponseType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.DocumentResponse;
import java.io.File;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.v3.AddPatientCorrelationRequestType;
import org.hl7.v3.II;
import org.hl7.v3.PRPAIN201305UV02;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.RespondingGatewayPRPAIN201305UV02RequestType;
import org.jmock.Expectations;
import static org.jmock.Expectations.any;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import privacy.service.nvap.va.gov.ConsentManagementPortType;

/**
 *
 * @author alok.subedi
 */
public class AdapterPatientDiscoveryTest {

    private static final String TEST_DIR = "src/test/resources";
    private static final File REQUEST_FILE = new File(TEST_DIR, "patient_discovery_request.xml");
    private static final File DOCUMENT = new File(TEST_DIR, "document.txt");
    //private static final File CORRELATION_RESPONSE = new File(TEST_DIR, "correlations-response.xml");
    private static final File RESPONSE_FILE_MPI = new File(TEST_DIR, "test-prpa_in201306uv02-match-response-mpi.xml");
    private static final File RESPONSE_FILE = new File(TEST_DIR, "patient_discovery_response.xml");

    private Mockery context;
    private AdapterPatientDiscovery instance;

    public AdapterPatientDiscoveryTest() {
    }

    @Before
    public void setUp() {
        this.context = new JUnit4Mockery();
        this.instance = new AdapterPatientDiscovery();
    }

    @BeforeClass
    public static void setUpClass() {
        System.setProperty("javax.xml.parsers.SAXParserFactory",
                "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of respondingGatewayPRPAIN201305UV02 method, of class
     * AdapterPatientDiscovery.
     */
    @Test
    public void ok(){}
		// @Test
		public void testRespondingGatewayPRPAIN201305UV02() throws Exception {
        JAXBContext jaxb = JAXBContext.newInstance(RespondingGatewayPRPAIN201305UV02RequestType.class, PRPAIN201305UV02.class);
        Unmarshaller unm = jaxb.createUnmarshaller();

        final RespondingGatewayPRPAIN201305UV02RequestType request = TestUtils.fileToPojo(REQUEST_FILE, RespondingGatewayPRPAIN201305UV02RequestType.class, unm);
        final PRPAIN201306UV02 mviResults = TestUtils.fileToPojo(RESPONSE_FILE_MPI, PRPAIN201306UV02.class, unm);

        final AdapterMviPortTypeLocal adapterMvi = context.mock(AdapterMviPortTypeLocal.class);
        final PatientCorrelationPortTypeLocal patientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
        final AdapterPolicyEnginePortType policyEngine = new FakeTestingAdapterPolicyEngine(DecisionType.PERMIT);
        final ConsentManagementPortType consentManagement = context.mock(ConsentManagementPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final DocumentRepository documentRepository = context.mock(DocumentRepository.class);
        final EntityDocQueryPortType entityDocQuery = context.mock(EntityDocQueryPortType.class);
        final EntityDocRetrievePortType entityDocRetrieve = context.mock(EntityDocRetrievePortType.class);
        final DasDAO dasDAO = context.mock(DasDAO.class);

        final String partnerHcid = "urn:oid:2.16.840.1.113883.3.184.6.1";

        Patient patient = new Patient();
        patient.setPatientId(1L);
        patient.setGender("male");
        patient.setDateOfBirth(new Timestamp(System.currentTimeMillis()));
        
        II patientId = new II();
        patientId.setRoot("2.2");
        patientId.setExtension("1234567890V123456");
        mviResults.setId(patientId);

        final Map<Object, Object> searchResultMap = new HashMap<>();
        searchResultMap.put("PRPAIN201306UV02", mviResults);
        searchResultMap.put("SEARCH_RESULT_PATIENT", patient);

        final String sendingHCID = "2.16.840.1.113883.3.184.6.1";
        final String fullHCID = "urn:oid:2.16.840.1.113883.3.184.6.1";
        final String sendingFacilityNumber = "200NSS";
        final String vaHCID = "2.16.840.1.113883.4.349.1";
        final String soid = "2.16.840.1.113883.4.349";

        final Properties props = new Properties();
        props.setProperty("HomeCommunityId", vaHCID);
        props.setProperty("excludePatientDiscoverySections", "0");
        props.setProperty("vler.das.eauthsubmit.url", "http://MOCK-HOST:8088/ecrud/v1/core/eHealthExchange.cda/transform");

        PropertyLookup pl = new PropertyLookup() {
            @Override
            public String getProperty(String key) {
                return props.getProperty(key);
            }
        };

        instance.setAdapterMvi(adapterMvi);
        instance.setAdapterPatientCorrelation(patientCorrelation);
        instance.setAdapterPolicyEngine(policyEngine);
        instance.setVapConsentManagement(consentManagement);
        instance.setFacilityManager(facilityManager);
        instance.setPropertyLookup(pl);
        instance.setAuditManager(auditManager);
        instance.setDocumentRepository(documentRepository);
        instance.setEntityDocQuery(entityDocQuery);
        instance.setEntityDocRetrieve(entityDocRetrieve);
        instance.setDasDAO(dasDAO);

        context.checking(new Expectations() {
            {
                Facility facility = new Facility();
                facility.setFacilityNumber("VA");
                facility.setHomeCommunityId(soid);

                Facility other = new Facility();
                other.setFacilityNumber(sendingFacilityNumber);
                other.setHomeCommunityId(sendingHCID);
                other.setFullHomeCommunityId(fullHCID);

                RetrieveDocumentSetResponseType accessConsentRetrieveResponse = new RetrieveDocumentSetResponseType();
                DocumentResponse docResponse = new DocumentResponse();
                String s = FileUtils.readFileToString(DOCUMENT);
                final byte [] acpDocument = Base64.getDecoder().decode(s);
                DataHandler dataHandler = new DataHandler(acpDocument, "application/octet-stream");
                docResponse.setDocument(dataHandler);
                accessConsentRetrieveResponse.getDocumentResponse().add(docResponse);
                
                AdhocQueryResponse adhocResponse = new AdhocQueryResponse();
                adhocResponse.setRequestId("1234");
                
                allowing(entityDocQuery).respondingGatewayCrossGatewayQuery(with(any(gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType.class)));
		will(returnValue(adhocResponse));
                
                allowing(entityDocRetrieve).respondingGatewayCrossGatewayRetrieve(with(any(gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType.class)));
                will(returnValue(accessConsentRetrieveResponse));
                
                DasOperationSendACPDocumentResponse res = new DasOperationSendACPDocumentResponse();
                res.setDocId("0000000000");

                allowing(facilityManager).getFacilityByHomeCommunityId(with(any(String.class)));
                will(returnValue(other));
                allowing(facilityManager).getFacilityByFacilityNumber(with(any(String.class)));
                will(returnValue(other));

                allowing(facilityManager).isPartnerAllowed(partnerHcid, OperationOnOff.ONBOARD);
                will(returnValue(true));
                allowing(facilityManager).isPartnerAllowed(partnerHcid, OperationOnOff.IN_PD);
                will(returnValue(true));

                allowing(propertyLookup).getProperty(with("HomeCommunityId"));
                will(returnValue(vaHCID));
                allowing(propertyLookup).getProperty(with("excludePatientDiscoverySections"));
                will(returnValue("0"));
                allowing(propertyLookup).getProperty(with("vler.das.eauthsubmit.url"));
                will(returnValue("http://MOCK-HOST:8088/ecrud/v1/core/eHealthExchange.cda/transform"));

                DasOperationSendACPDocumentResponse dasRes = new DasOperationSendACPDocumentResponse();
                dasRes.setDocId("1234");

                allowing(dasDAO).doOperationSendACPDocument(with(any(DasOperationSendACPDocumentRequest.class)));
                will(returnValue(dasRes));
                
                ConsentDirectiveQueryResponseType consentDirectiveResponse = new ConsentDirectiveQueryResponseType();
                
                allowing(consentManagement).getConsentDirectives(with(any(ConsentDirectiveQueryRequestType.class)));
                will(returnValue(consentDirectiveResponse));

                allowing(adapterMvi).findCandidatesMap(
										with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)),
										with( any( AuditEvent.class ) ) );
                will(returnValue(searchResultMap));

                allowing(adapterMvi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
                will(returnValue(mviResults));
                
                allowing(documentRepository).storeDocument(with(any(Document.class)));
                allowing(auditManager).storeAudit(with(any(Audit.class)));

                allowing(patientCorrelation).addPatientCorrelation(
									with(any(AddPatientCorrelationRequestType.class)),
                  with(any(Patient.class)),
									with( any( Boolean.class ) ),
									with( any( AuditEvent.class )));
            }
        });

        PRPAIN201306UV02 result = instance.respondingGatewayPRPAIN201305UV02(request);
        TestUtils.assertResultsOk(PRPAIN201306UV02.class, result, RESPONSE_FILE);
        context.assertIsSatisfied();
    }

    /**
     * Test of extractPatientIdFrom201305 method, of class
     * AdapterPatientDiscovery.
     */
    @Test
    public void testExtractPatientIdFrom201305() throws Exception {
        PRPAIN201305UV02 request = null;
        II expResult = null;
        II result = instance.extractPatientIdFrom201305(request);
        assertEquals(expResult, result);
    }

}