/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.docretrieve;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingAdapterPolicyEngine;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.errors.CreateResponseError;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.jmock.Expectations;
import static org.jmock.Expectations.any;
import static org.jmock.Expectations.returnValue;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author ryan
 */
public class AdapterDocRetrieveTest {

	private static final String TESTDIR = "src/test/resources";
	private static final File REQUEST_FILE = new File( TESTDIR, "test-dr-in-request.xml" );

	@BeforeClass
	public static void setUpClass() {
		System.setProperty( "javax.xml.parsers.SAXParserFactory",
				"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl" );
	}

	@AfterClass
	public static void tearDownClass() {
	}

	@Before
	public void setUp() {
	}

	@After
	public void tearDown() {
	}

	@Test
	public void testRespondingGatewayCrossGatewayRetrieve() throws Exception {
		AdapterDocRetrieve instance = new AdapterDocRetrieve();
		Mockery context = new JUnit4Mockery();
		DataManager dm = TestUtils.makeDM();

		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayCrossGatewayRetrieveRequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayCrossGatewayRetrieveRequestType request
				= TestUtils.fileToPojo( REQUEST_FILE,
						RespondingGatewayCrossGatewayRetrieveRequestType.class, unm );

		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );
		final DocumentRepository docrepo
				= context.mock( DocumentRepository.class );

		DocRetrieve docret = new DocRetrieve();

		final AdapterPolicyEnginePortTypeLocal policyEngine
				= new FakeTestingAdapterPolicyEngine( true );

		final Document doc = new Document();
		doc.setDocumentUniqueId( "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45" );
		doc.setDocGenQueryParams( "homeCommunityId=urn:oid:2.16.840.1.113883.17.8.1,documentRepositoryId=2.16.840.1.113883.17.8.1,documentUniqueId=2.16.840.1.113883.17.8.1^JUf1Z0KDquAxANlg" );
		doc.setRawData( new byte[]{} );

		docret.setFacilityManager( facilityManager );
		docret.setAuditManager( auditManager );
		docret.setDataManager( dm );
		docret.setDocumentRepository( docrepo );

		instance.setFacilityManager( facilityManager );
		instance.setDocRetrieve( docret );
		instance.setPolicyEngine( policyEngine );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "2.16.840.1.113883.4.349.1" );
				facility.setFullHomeCommunityId( "urn:oid:2.16.840.1.113883.4.349.1" );

				oneOf( auditManager ).storeAudit( with( any( Audit.class ) ) );

				oneOf( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				oneOf( facilityManager ).isPartnerAllowed( "urn:oid:1.3.6.1.4.1.26580.10", OperationOnOff.ONBOARD );
				will( returnValue( true ) );

				oneOf( facilityManager ).isPartnerAllowed( "urn:oid:1.3.6.1.4.1.26580.10", OperationOnOff.IN_DR );
				will( returnValue( true ) );

				oneOf( docrepo ).getDocumentByDocumentUniqueId( "2.25.265279217945535622494802256445359248487" );
				will( returnValue( doc ) );

				oneOf( docrepo ).storeDocument( with( any( Document.class ) ) );
			}
		} );

		RetrieveDocumentSetResponseType response
				= instance.respondingGatewayCrossGatewayRetrieve( request );

		TestUtils.assertResultsOk( RetrieveDocumentSetResponseType.class, response,
				"/RetrieveDocumentSetResponseType/RegistryResponse/@status", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success",
				"/RetrieveDocumentSetResponseType/DocumentResponse/HomeCommunityId", "urn:oid:2.16.840.1.113883.4.349.1",
				"/RetrieveDocumentSetResponseType/DocumentResponse/RepositoryUniqueId", "2.16.840.1.113883.4.349.1.1",
				"/RetrieveDocumentSetResponseType/DocumentResponse/DocumentUniqueId", "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45",
				"/RetrieveDocumentSetResponseType/DocumentResponse/Document", ""
		);
		context.assertIsSatisfied();
	}

	@Test
	public void testRespondingGatewayCrossGatewayRetrieve_NoHCID() throws Exception {
		AdapterDocRetrieve instance = new AdapterDocRetrieve();
		Mockery context = new JUnit4Mockery();
		DataManager dm = TestUtils.makeDM();

		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayCrossGatewayRetrieveRequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayCrossGatewayRetrieveRequestType request
				= TestUtils.fileToPojo( REQUEST_FILE,
						RespondingGatewayCrossGatewayRetrieveRequestType.class, unm );
		request.getRetrieveDocumentSetRequest().getDocumentRequest().get( 0 ).setHomeCommunityId( null );

		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );
		final DocumentRepository docrepo
				= context.mock( DocumentRepository.class );

		DocRetrieve docret = new DocRetrieve();

		final AdapterPolicyEnginePortTypeLocal policyEngine
				= new FakeTestingAdapterPolicyEngine( true );

		final Document doc = new Document();
		doc.setDocumentUniqueId( "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45" );
		doc.setDocGenQueryParams( "homeCommunityId=urn:oid:2.16.840.1.113883.17.8.1,documentRepositoryId=2.16.840.1.113883.17.8.1,documentUniqueId=2.16.840.1.113883.17.8.1^JUf1Z0KDquAxANlg" );
		doc.setRawData( new byte[]{} );

		docret.setFacilityManager( facilityManager );
		docret.setAuditManager( auditManager );
		docret.setDataManager( dm );
		docret.setDocumentRepository( docrepo );

		instance.setFacilityManager( facilityManager );
		instance.setDocRetrieve( docret );
		instance.setPolicyEngine( policyEngine );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "2.16.840.1.113883.4.349.1" );
				facility.setFullHomeCommunityId( "urn:oid:2.16.840.1.113883.4.349.1" );

				exactly(2).of( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				oneOf( facilityManager ).isPartnerAllowed( "urn:oid:1.3.6.1.4.1.26580.10", OperationOnOff.ONBOARD );
				will( returnValue( true ) );

				oneOf( facilityManager ).isPartnerAllowed( "urn:oid:1.3.6.1.4.1.26580.10", OperationOnOff.IN_DR );
				will( returnValue( true ) );
			}
		} );

		RetrieveDocumentSetResponseType response
				= instance.respondingGatewayCrossGatewayRetrieve( request );

		TestUtils.assertResultsOk( RetrieveDocumentSetResponseType.class, response,
				"/RetrieveDocumentSetResponseType/RegistryResponse/@status", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/@highestSeverity", "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/RegistryError/@errorCode", "XDSMissingHomeCommunityId",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/RegistryError/@severity", "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error"
		);
		context.assertIsSatisfied();
	}

	@Test
	public void testRespondingGatewayCrossGatewayRetrieve_NoRepoID() throws Exception {
		AdapterDocRetrieve instance = new AdapterDocRetrieve();
		Mockery context = new JUnit4Mockery();
		DataManager dm = TestUtils.makeDM();

		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayCrossGatewayRetrieveRequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayCrossGatewayRetrieveRequestType request
				= TestUtils.fileToPojo( REQUEST_FILE,
						RespondingGatewayCrossGatewayRetrieveRequestType.class, unm );
		request.getRetrieveDocumentSetRequest().getDocumentRequest().get( 0 ).setRepositoryUniqueId( null );

		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );
		final DocumentRepository docrepo
				= context.mock( DocumentRepository.class );

		DocRetrieve docret = new DocRetrieve();

		final AdapterPolicyEnginePortTypeLocal policyEngine
				= new FakeTestingAdapterPolicyEngine( true );

		final Document doc = new Document();
		doc.setDocumentUniqueId( "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45" );
		doc.setDocGenQueryParams( "homeCommunityId=urn:oid:2.16.840.1.113883.17.8.1,documentRepositoryId=2.16.840.1.113883.17.8.1,documentUniqueId=2.16.840.1.113883.17.8.1^JUf1Z0KDquAxANlg" );
		doc.setRawData( new byte[]{} );

		docret.setFacilityManager( facilityManager );
		docret.setAuditManager( auditManager );
		docret.setDataManager( dm );
		docret.setDocumentRepository( docrepo );

		instance.setFacilityManager( facilityManager );
		instance.setDocRetrieve( docret );
		instance.setPolicyEngine( policyEngine );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "2.16.840.1.113883.4.349.1" );
				facility.setFullHomeCommunityId( "urn:oid:2.16.840.1.113883.4.349.1" );

				exactly(2).of( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				oneOf( facilityManager ).isPartnerAllowed( "urn:oid:1.3.6.1.4.1.26580.10", OperationOnOff.ONBOARD );
				will( returnValue( true ) );

				oneOf( facilityManager ).isPartnerAllowed( "urn:oid:1.3.6.1.4.1.26580.10", OperationOnOff.IN_DR );
				will( returnValue( true ) );
			}
		} );

		RetrieveDocumentSetResponseType response
				= instance.respondingGatewayCrossGatewayRetrieve( request );

		TestUtils.assertResultsOk( RetrieveDocumentSetResponseType.class, response,
				"/RetrieveDocumentSetResponseType/RegistryResponse/@status", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/@highestSeverity", "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/RegistryError/@errorCode", "XDSUnknownRepositoryId",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/RegistryError/@severity", "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error"
		);
		context.assertIsSatisfied();
	}

	@Test
	public void testRespondingGatewayCrossGatewayRetrieve_NoShare() throws Exception {
		AdapterDocRetrieve instance = new AdapterDocRetrieve();
		Mockery context = new JUnit4Mockery();
		DataManager dm = TestUtils.makeDM();

		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayCrossGatewayRetrieveRequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayCrossGatewayRetrieveRequestType request
				= TestUtils.fileToPojo( REQUEST_FILE,
						RespondingGatewayCrossGatewayRetrieveRequestType.class, unm );

		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );
		final DocumentRepository docrepo
				= context.mock( DocumentRepository.class );

		DocRetrieve docret = new DocRetrieve();

		final AdapterPolicyEnginePortTypeLocal policyEngine
				= new FakeTestingAdapterPolicyEngine( true );

		final Document doc = new Document();
		doc.setDocumentUniqueId( "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45" );
		doc.setDocGenQueryParams( "homeCommunityId=urn:oid:2.16.840.1.113883.17.8.1,documentRepositoryId=2.16.840.1.113883.17.8.1,documentUniqueId=2.16.840.1.113883.17.8.1^JUf1Z0KDquAxANlg" );
		doc.setRawData( new byte[]{} );

		docret.setFacilityManager( facilityManager );
		docret.setAuditManager( auditManager );
		docret.setDataManager( dm );
		docret.setDocumentRepository( docrepo );

		instance.setFacilityManager( facilityManager );
		instance.setDocRetrieve( docret );
		instance.setPolicyEngine( policyEngine );
		
		CreateResponseError errorResponse = new CreateResponseError();
		instance.setErrorResponse( errorResponse );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "2.16.840.1.113883.4.349.1" );
				facility.setFullHomeCommunityId( "urn:oid:2.16.840.1.113883.4.349.1" );

				allowing( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );
			}
		} );

		RetrieveDocumentSetResponseType response
				= instance.respondingGatewayCrossGatewayRetrieve( request );

		TestUtils.assertResultsOk( RetrieveDocumentSetResponseType.class, response,
				"/RetrieveDocumentSetResponseType/RegistryResponse/@status", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/@highestSeverity", "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/RegistryError/@errorCode", "XDSRepositoryError",
				"/RetrieveDocumentSetResponseType/RegistryResponse/RegistryErrorList/RegistryError/@severity", "urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error"
		);
		context.assertIsSatisfied();
	}
}
