/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.patientdiscovery;

import gov.va.med.nhin.adapter.adaptergateway.FakeTestingExecutorService;
import gov.hhs.fha.nhinc.patientdb.model.Patient;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingPatientDiscoverySender;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.audit.requests.RequestAudit;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.mvi.AdapterMviPortTypeLocal;
import gov.va.med.nhin.adapter.patientcorrelation.PatientCorrelationPortTypeLocal;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXBContext;

import javax.xml.bind.Unmarshaller;
import org.hl7.v3.AddPatientCorrelationRequestType;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.RespondingGatewayPRPAIN201305UV02RequestType;
import org.hl7.v3.RespondingGatewayPRPAIN201306UV02ResponseType;
import org.jmock.Expectations;
import static org.jmock.Expectations.any;
import static org.jmock.Expectations.returnValue;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static gov.va.med.nhin.adapter.adaptergateway.TestUtils.fileToPojo;
import org.hl7.fhir.dstu3.model.AuditEvent;

/**
 *
 * @author Ry Bobko
 */
@RunWith( JMock.class )
public class AdapterGatewayPatientDiscoveryTest {

	private static final String TESTDIR = "src/test/resources";
	private static final File REQUEST_FILE
			= new File( TESTDIR, "test-prpa_in201305uv02-request.xml" );
	private static final File REQUEST_FILE_TARGETED
			= new File( TESTDIR, "test-prpa_in201305uv02-request-targeted.xml" );
	private static final File RESPONSE_FILE_MPI
			= new File( TESTDIR, "test-prpa_in201306uv02-match-response-mpi.xml" );
	private static final File RESPONSE_FILE_PARTNER
			= new File( TESTDIR, "test-prpa_in201306uv02-match-response-partner.xml" );
	private static final File RESULT_FILE
			= new File( TESTDIR, "pd-out-result-ok.xml" );

	private Mockery context;
	private AdapterGatewayPatientDiscovery instance;

	@Before
	public void setUp() {
		this.instance = new AdapterGatewayPatientDiscovery();
		this.context = new JUnit4Mockery();
	}

	/**
	 * Test of respondingGatewayPRPAIN201305UV02 method, of class
	 * AdapterGatewayPatientDiscovery.
	 */
	@Test( expected = Throwable.class )
	public void testRespondingGatewayPRPAIN201305UV02NullRequest() {
		instance.respondingGatewayPRPAIN201305UV02( null );
	}

	@Test
	public void testAllOk() throws Exception {
		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayPRPAIN201305UV02RequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayPRPAIN201305UV02RequestType request = fileToPojo( REQUEST_FILE,
				RespondingGatewayPRPAIN201305UV02RequestType.class, unm );

		final PRPAIN201306UV02 responseFromPartner = fileToPojo( RESPONSE_FILE_PARTNER,
				PRPAIN201306UV02.class, unm );

		final PRPAIN201306UV02 responseFromMPI = fileToPojo( RESPONSE_FILE_MPI,
				PRPAIN201306UV02.class, unm );
		Patient patient = new Patient();
		patient.setPatientId( 1l );

		final Map<String, Object> mpiMap = new HashMap<>();
		mpiMap.put( "PRPAIN201306UV02", responseFromMPI );
		mpiMap.put( "SEARCH_RESULT_PATIENT", patient );

		AdapterGatewayPatientDiscovery.SendRequestResponse sendresp
				= instance.new SendRequestResponse();
		sendresp.prpain201306UV02 = responseFromPartner;
		sendresp.remoteHomeCommunityId = request.getAssertion().getHomeCommunity().getHomeCommunityId();

		final AdapterMviPortTypeLocal adapterMvi
				= context.mock( AdapterMviPortTypeLocal.class );
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation
				= context.mock( PatientCorrelationPortTypeLocal.class );
		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final RequestAudit requestAudit
				= context.mock( RequestAudit.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );

		instance.setAdapterMvi( adapterMvi );
		instance.setAdapterPatientCorrelation( adapterPatientCorrelation );
		instance.setExecutorService( new FakeTestingExecutorService<>( sendresp ) );
		instance.setFacilityManager( facilityManager );
		instance.setNhinPatientDiscoverySender( new FakeTestingPatientDiscoverySender( responseFromPartner ) );
		instance.setRequestAudit( requestAudit );
		instance.setAuditManager( auditManager );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "1.1" );

				Facility other = new Facility();
				other.setFacilityNumber( "CAMC" );
				other.setHomeCommunityId( "2.3" );

				oneOf( facilityManager ).isPartnerAllowed( "2.3", OperationOnOff.ONBOARD );
				will( returnValue( true ) );
				oneOf( facilityManager ).isPartnerAllowed( "2.3", OperationOnOff.OUT_PD );
				will( returnValue( true ) );

				oneOf( auditManager ).storeAudit( with( any( Audit.class ) ) );

				exactly( 4 ).of( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				oneOf( facilityManager ).getAllFacilities( "VA" );
				will( returnValue( Arrays.asList( other ) ) );

				exactly( 2 ).of( adapterMvi ).findCandidatesMap( 
						with( any( RespondingGatewayPRPAIN201305UV02RequestType.class ) ),
						with( any( AuditEvent.class ) ) );
				will( returnValue( mpiMap ) );

				exactly( 2 ).of( adapterPatientCorrelation ).addPatientCorrelation(
						with( any( AddPatientCorrelationRequestType.class ) ),
						with( any( Patient.class ) ),
						with( any( Boolean.class ) ),
						with( any( AuditEvent.class )));
			}
		} );

		RespondingGatewayPRPAIN201306UV02ResponseType result
				= instance.respondingGatewayPRPAIN201305UV02( request );

		TestUtils.assertResultsOk( RespondingGatewayPRPAIN201306UV02ResponseType.class,
				result, RESULT_FILE );
		context.assertIsSatisfied();
	}

	@Test
	public void testTargeted() throws Exception {
		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayPRPAIN201305UV02RequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayPRPAIN201305UV02RequestType request = fileToPojo( REQUEST_FILE_TARGETED,
				RespondingGatewayPRPAIN201305UV02RequestType.class, unm );

		final PRPAIN201306UV02 responseFromPartner = fileToPojo( RESPONSE_FILE_PARTNER,
				PRPAIN201306UV02.class, unm );

		final PRPAIN201306UV02 responseFromMPI = fileToPojo( RESPONSE_FILE_MPI,
				PRPAIN201306UV02.class, unm );
		Patient patient = new Patient();
		patient.setPatientId( 1l );

		final Map<String, Object> mpiMap = new HashMap<>();
		mpiMap.put( "PRPAIN201306UV02", responseFromMPI );
		mpiMap.put( "SEARCH_RESULT_PATIENT", patient );

		AdapterGatewayPatientDiscovery.SendRequestResponse sendresp
				= instance.new SendRequestResponse();
		sendresp.prpain201306UV02 = responseFromPartner;
		sendresp.remoteHomeCommunityId = request.getAssertion().getHomeCommunity().getHomeCommunityId();

		final AdapterMviPortTypeLocal adapterMpi
				= context.mock( AdapterMviPortTypeLocal.class );
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation
				= context.mock( PatientCorrelationPortTypeLocal.class );
		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final RequestAudit requestAudit
				= context.mock( RequestAudit.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );

		instance.setAdapterMvi( adapterMpi );
		instance.setAdapterPatientCorrelation( adapterPatientCorrelation );
		instance.setExecutorService( new FakeTestingExecutorService<>( sendresp ) );
		instance.setFacilityManager( facilityManager );
		instance.setNhinPatientDiscoverySender( new FakeTestingPatientDiscoverySender( responseFromPartner ) );
		instance.setRequestAudit( requestAudit );
		instance.setAuditManager( auditManager );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "1.1" );

				Facility other = new Facility();
				other.setFacilityNumber( "CAMC" );
				other.setHomeCommunityId( "2.3" );

				oneOf( facilityManager ).isPartnerAllowed( "1.1", OperationOnOff.ONBOARD );
				will( returnValue( true ) );
				oneOf( facilityManager ).isPartnerAllowed( "1.1", OperationOnOff.OUT_PD );
				will( returnValue( true ) );

				oneOf( facilityManager ).getFacilityByHomeCommunityId( "1.1" );
				will( returnValue( facility ) );

				oneOf( auditManager ).storeAudit( with( any( Audit.class ) ) );

				exactly( 4 ).of( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				exactly( 2 ).of( adapterMpi ).findCandidatesMap( 
						with( any( RespondingGatewayPRPAIN201305UV02RequestType.class ) ),
						with( any( AuditEvent.class ) ) );
				will( returnValue( mpiMap ) );

				exactly( 2 ).of( adapterPatientCorrelation ).addPatientCorrelation(
						with( any( AddPatientCorrelationRequestType.class ) ),
						with( any( Patient.class ) ),
						with( any( Boolean.class ) ),
						with( any( AuditEvent.class )));
			}
		} );

		RespondingGatewayPRPAIN201306UV02ResponseType result
				= instance.respondingGatewayPRPAIN201305UV02( request );

		TestUtils.assertResultsOk( RespondingGatewayPRPAIN201306UV02ResponseType.class,
				result, RESULT_FILE );
		context.assertIsSatisfied();
	}

	@Test( expected = RuntimeException.class )
	public void testProblemCorrelating() throws Exception {
		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayPRPAIN201305UV02RequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayPRPAIN201305UV02RequestType request = fileToPojo( REQUEST_FILE_TARGETED,
				RespondingGatewayPRPAIN201305UV02RequestType.class, unm );

		final PRPAIN201306UV02 responseFromPartner = fileToPojo( RESPONSE_FILE_PARTNER,
				PRPAIN201306UV02.class, unm );

		final PRPAIN201306UV02 responseFromMPI = fileToPojo( RESPONSE_FILE_MPI,
				PRPAIN201306UV02.class, unm );
		Patient patient = new Patient();
		patient.setPatientId( 1l );

		final Map<String, Object> mpiMap = new HashMap<>();
		mpiMap.put( "PRPAIN201306UV02", responseFromMPI );
		mpiMap.put( "SEARCH_RESULT_PATIENT", patient );

		AdapterGatewayPatientDiscovery.SendRequestResponse sendresp
				= instance.new SendRequestResponse();
		sendresp.prpain201306UV02 = responseFromPartner;
		sendresp.remoteHomeCommunityId = request.getAssertion().getHomeCommunity().getHomeCommunityId();

		final AdapterMviPortTypeLocal adapterMpi
				= context.mock( AdapterMviPortTypeLocal.class );
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation
				= context.mock( PatientCorrelationPortTypeLocal.class );
		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final RequestAudit requestAudit
				= context.mock( RequestAudit.class );

		instance.setAdapterMvi( adapterMpi );
		instance.setAdapterPatientCorrelation( adapterPatientCorrelation );
		instance.setExecutorService( new FakeTestingExecutorService<>( sendresp ) );
		instance.setFacilityManager( facilityManager );
		instance.setNhinPatientDiscoverySender( new FakeTestingPatientDiscoverySender( responseFromPartner ) );
		instance.setRequestAudit( requestAudit );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "1.1" );

				Facility other = new Facility();
				other.setFacilityNumber( "CAMC" );
				other.setHomeCommunityId( "2.3" );

				oneOf( facilityManager ).isPartnerAllowed( "1.1", OperationOnOff.ONBOARD );
				will( returnValue( true ) );
				oneOf( facilityManager ).isPartnerAllowed( "1.1", OperationOnOff.OUT_PD );
				will( returnValue( true ) );

				oneOf( facilityManager ).getFacilityByHomeCommunityId( "1.1" );
				will( returnValue( facility ) );

				exactly( 2 ).of( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				oneOf( adapterMpi ).findCandidatesMap( 
						with( any( RespondingGatewayPRPAIN201305UV02RequestType.class ) ),
						with( any( AuditEvent.class ) ) );
				will( returnValue( mpiMap ) );

				oneOf( adapterPatientCorrelation ).addPatientCorrelation(
						with( any( AddPatientCorrelationRequestType.class ) ),
						with( any( Patient.class ) ),
						with( any( Boolean.class ) ),
						with( any( AuditEvent.class )));
				will( throwException( new RuntimeException() ) );
			}
		} );

		instance.respondingGatewayPRPAIN201305UV02( request );
	}


	/*
	@Test
	public void testRespondingGatewayPRPAIN201305UV02NoMatchFromPartner() {
		System.out.println("respondingGatewayPRPAIN201305UV02NoMatchFromPartner");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(null,
				prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);

				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.PERMIT);

				will(returnValue(bd));
				allowing(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(returnValue(checkPolicyResponse));
				oneOf(executorService).execute(with(any(Runnable.class)));
				will(RunTaskAction.runTask());
				oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
				will(returnValue(responseFromPartner));
				never(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
				never(adapterPatientCorrelation).addPatientCorrelation(
						with(any(AddPatientCorrelationRequestType.class)));
			}
		});

		RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
		assertEquals(1, result.getCommunityResponse().size());
		assertTrue(result.getCommunityResponse().get(0) != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
				&& NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02()
						.getControlActProcess().getSubject()));
	}

	@Test
	public void testRespondingGatewayPRPAIN201305UV02MatchFromPartnerNoMatchFromVerify() {
		System.out.println("respondingGatewayPRPAIN201305UV02MatchFromPatnerNoMatchFromVerify");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		Patient patient = HL7DbParser201305.extractMpiPatientFromMessage(prpain201305UV02);
		List<Patient> patients = new ArrayList<Patient>();
		patients.add(patient);
		final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients,
				prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);

		PRPAIN201305UV02 prpain201305UV02FromExternal = createPRPAIN201305("Patient",
				Arrays.asList(new String[] { "Test" }), null, null, "20120724", "New Orleans", "LA",
				Arrays.asList(new String[] { "1234 Test Lane" }), "70143", "tel:+1-504-529-6111", "M", "no", "M",
				"1234567890V123456", TEST_RECEIVING_HCID, TEST_RECEIVING_AA, "666003333");

		final PRPAIN201306UV02 responseFromMPI = HL7DbParser201306.BuildMessageFromMpiPatients(null,
				prpain201305UV02FromExternal, TEST_SENDING_HCID, TEST_SENDING_AA);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);

				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.PERMIT);

				will(returnValue(bd));
				allowing(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(returnValue(checkPolicyResponse));
				oneOf(executorService).execute(with(any(Runnable.class)));
				will(RunTaskAction.runTask());
				oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
				will(returnValue(responseFromPartner));
				oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
				will(returnValue(responseFromMPI));
				never(adapterPatientCorrelation).addPatientCorrelation(
						with(any(AddPatientCorrelationRequestType.class)));
			}
		});

		RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
		assertEquals(1, result.getCommunityResponse().size());
		assertTrue(result.getCommunityResponse().get(0) != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
				&& NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02()
						.getControlActProcess().getSubject()));
	}

	@Test
	public void testRespondingGatewayPRPAIN201305UV02CheckPolicyDeny() {
		System.out.println("respondingGatewayPRPAIN201305UV02CheckPolicyDeny");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);

				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.DENY);

				will(returnValue(bd));
				oneOf(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(returnValue(checkPolicyResponse));
				never(executorService).execute(with(any(Runnable.class)));
				never(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
			}
		});

		RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
		assertEquals(1, result.getCommunityResponse().size());
		assertTrue(result.getCommunityResponse().get(0) != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
				&& NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02()
						.getControlActProcess().getSubject()));
	}

	@Test
	public void testRespondingGatewayPRPAIN201305UV02NHINSenderError() {
		System.out.println("respondingGatewayPRPAIN201305UV02NHINSenderError");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);

				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.PERMIT);

				will(returnValue(bd));
				oneOf(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(returnValue(checkPolicyResponse));
				oneOf(executorService).execute(with(any(Runnable.class)));
				will(RunTaskAction.runTask());
				oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
				will(throwException(new RuntimeException()));
			}
		});

		RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
		assertEquals(1, result.getCommunityResponse().size());
		assertTrue(result.getCommunityResponse().get(0) != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
				&& result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
				&& NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02()
						.getControlActProcess().getSubject()));
	}

	@Test
	public void testRespondingGatewayPRPAIN201305UV02CheckPolicyException() {
		System.out.println("respondingGatewayPRPAIN201305UV02CheckPolicyException");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);

				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.PERMIT);

				will(returnValue(bd));
				allowing(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(throwException(new RuntimeException()));
				never(executorService).execute(with(any(Runnable.class)));
				never(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
				never(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
				never(adapterPatientCorrelation).addPatientCorrelation(
						with(any(AddPatientCorrelationRequestType.class)));
			}
		});

		try {
			RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
			fail("This shouldn't happen!");
		} catch (Throwable t) {
			assertTrue(true);
		}
	}

	@Test
	public void testRespondingGatewayPRPAIN201305UV02AdapterMpiException() {
		System.out.println("respondingGatewayPRPAIN201305UV02AdapterMpiException");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		Patient patient = HL7DbParser201305.extractMpiPatientFromMessage(prpain201305UV02);
		List<Patient> patients = new ArrayList<Patient>();
		patients.add(patient);
		final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients,
				prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);
				
				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.PERMIT);

				will(returnValue(bd));
				allowing(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(returnValue(checkPolicyResponse));
				oneOf(executorService).execute(with(any(Runnable.class)));
				will(RunTaskAction.runTask());
				oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
				will(returnValue(responseFromPartner));
				oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
				will(throwException(new RuntimeException()));
				never(adapterPatientCorrelation).addPatientCorrelation(
						with(any(AddPatientCorrelationRequestType.class)));
			}
		});

		try {
			RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
			fail("This shouldn't happen!");
		} catch (Throwable t) {
			assertTrue(true);
		}
	}

	@Test
	public void testRespondingGatewayPRPAIN201305UV02PatientCorrelationException() {
		System.out.println("respondingGatewayPRPAIN201305UV02PatientCorrelationException");

		RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
		PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305("Patient", Arrays.asList(new String[] { "Test" }), null,
				null, "20120724", "New Orleans", "LA", Arrays.asList(new String[] { "1234 Test Lane" }), "70143",
				"tel:+1-504-529-6111", "M", "no", "M", "1234567890V123456", TEST_SENDING_HCID, TEST_SENDING_AA,
				"666003333");
		request.setPRPAIN201305UV02(prpain201305UV02);

		Patient patient = HL7DbParser201305.extractMpiPatientFromMessage(prpain201305UV02);
		List<Patient> patients = new ArrayList<Patient>();
		patients.add(patient);
		final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients,
				prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);

		PRPAIN201305UV02 prpain201305UV02FromExternal = createPRPAIN201305("Patient",
				Arrays.asList(new String[] { "Test" }), null, null, "20120724", "New Orleans", "LA",
				Arrays.asList(new String[] { "1234 Test Lane" }), "70143", "tel:+1-504-529-6111", "M", "no", "M",
				"1234567890V123456", TEST_RECEIVING_HCID, TEST_RECEIVING_AA, "666003333");

		final PRPAIN201306UV02 responseFromMPI = HL7DbParser201306.BuildMessageFromMpiPatients(patients,
				prpain201305UV02FromExternal, TEST_SENDING_HCID, TEST_SENDING_AA);

		AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();

		final ExecutorService executorService = context.mock(ExecutorService.class);
		final AdapterMviPortTypeLocal adapterMpi = context.mock(AdapterMviPortTypeLocal.class);
		final PatientCorrelationPortTypeLocal adapterPatientCorrelation = context.mock(PatientCorrelationPortTypeLocal.class);
		final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
		final FacilityManager facilityManager = context.mock(FacilityManager.class);
		final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);

		instance.setAdapterMvi(adapterMpi);
		instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
		instance.setExecutorService(executorService);
		instance.setFacilityManager(facilityManager);
		instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

		context.checking(new Expectations() {
			{
				BusinessDetail bd = new BusinessDetail();
				BusinessEntity be = new BusinessEntity();
				KeyedReference keyedRef = new KeyedReference();
				keyedRef.setKeyName("");
				keyedRef.setKeyValue(TEST_RECEIVING_HCID);
				keyedRef.setTModelKey("uddi:nhin:nhie:homecommunityid");
				IdentifierBag iBag = new IdentifierBag();
				iBag.getKeyedReference().add(keyedRef);
				be.setIdentifierBag(iBag);
				bd.getBusinessEntity().add(be);

				Facility facility = new Facility();
				facility.setFacilityNumber("VA");
				facility.setHomeCommunityId(TEST_SENDING_HCID);

				CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
				ResponseType response = new ResponseType();
				checkPolicyResponse.setResponse(response);
				ResultType result = new ResultType();
				response.getResult().add(result);
				result.setDecision(DecisionType.PERMIT);

				will(returnValue(bd));
				allowing(facilityManager).getFacilityByFacilityNumber("VA");
				will(returnValue(facility));
				oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
				will(returnValue(checkPolicyResponse));
				oneOf(executorService).execute(with(any(Runnable.class)));
				will(RunTaskAction.runTask());
				oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)),
						with(any(AssertionType.class)), with(any(String.class)));
				will(returnValue(responseFromPartner));
				oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
				will(returnValue(responseFromMPI));
				oneOf(adapterPatientCorrelation).addPatientCorrelation(
						with(any(AddPatientCorrelationRequestType.class)));
				will(throwException(new RuntimeException()));
			}
		});

		try {
			RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
			fail("This shouldn't happen!");
		} catch (Throwable t) {
			assertTrue(true);
		}
	}
	 */
}
