/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.docretrieve;

import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingAdapterPolicyEngine;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingDocRetrieveRequestSender;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingExecutorService;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.patientcorrelation.PatientCorrelationPortTypeLocal;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;
import org.jmock.Expectations;
import static org.jmock.Expectations.any;
import static org.jmock.Expectations.returnValue;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author ryan
 */
public class EntityDocRetrieveBeanTest {

	private static final String TESTDIR = "src/test/resources";
	private static final File REQUEST_FILE
			= new File( TESTDIR, "test-entitydocretreive-request.xml" );
	private static final File RESPONSE_CORRELATIONS
			= new File( TESTDIR, "correlations-response.xml" );
	private static final File SETTYPE_FILE
			= new File( TESTDIR, "RetrieveDocumentSetResponseType-response.xml" );
	private static final File RESULT_FILE
			= new File( TESTDIR, "rd-out-result-ok.xml" );

	public EntityDocRetrieveBeanTest() {
	}

	@BeforeClass
	public static void setUpClass() {
		System.setProperty( "javax.xml.parsers.SAXParserFactory",
				"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl" );
	}

	@AfterClass
	public static void tearDownClass() {
	}

	@Before
	public void setUp() {
	}

	@After
	public void tearDown() {
	}

	@Test
	public void testRespondingGatewayCrossGatewayRetrieve() throws Exception {
		EntityDocRetrieveBean instance = new EntityDocRetrieveBean();
		Mockery context = new JUnit4Mockery();

		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayCrossGatewayRetrieveRequestType.class,
				AdhocQueryResponse.class, RetrievePatientCorrelationsResponseType.class,
				RetrieveDocumentSetResponseType.class, RetrieveDocumentSetRequestType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayCrossGatewayRetrieveRequestType request
				= TestUtils.fileToPojo( REQUEST_FILE,
						RespondingGatewayCrossGatewayRetrieveRequestType.class, unm );
		RetrieveDocumentSetResponseType settyperesp
				= TestUtils.fileToPojo( SETTYPE_FILE, RetrieveDocumentSetResponseType.class, unm );
		final RetrievePatientCorrelationsResponseType corrresp
				= TestUtils.fileToPojo( RESPONSE_CORRELATIONS,
						RetrievePatientCorrelationsResponseType.class, unm );

		final PatientCorrelationPortTypeLocal adapterPatientCorrelation
				= context.mock( PatientCorrelationPortTypeLocal.class );
		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final AuditManager auditManager
				= context.mock( AuditManager.class );
		final DocumentRepository docrepo
				= context.mock( DocumentRepository.class );

		AdapterGatewayDocRetrieve docret = new AdapterGatewayDocRetrieve();
		AdapterGatewayDocRetrieve.SendRequestResponse sendresp = docret.new SendRequestResponse();
		sendresp.retrieveDocumentSetResponse = settyperesp;

		final AdapterPolicyEnginePortTypeLocal policyEngine
				= new FakeTestingAdapterPolicyEngine( true );
		final NHINDocRetrieveRequestSender sender
				= new FakeTestingDocRetrieveRequestSender( settyperesp );
		final FakeTestingExecutorService executor
				= new FakeTestingExecutorService<>( sendresp );
		final Document doc = new Document();
		doc.setDocumentUniqueId( "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45" );
		doc.setDocGenQueryParams( "homeCommunityId=urn:oid:2.16.840.1.113883.17.8.1,documentRepositoryId=2.16.840.1.113883.17.8.1,documentUniqueId=2.16.840.1.113883.17.8.1^JUf1Z0KDquAxANlg" );

		docret.setAdapterPolicyEngine( policyEngine );
		docret.setExecutorService( executor );
		docret.setNhinDocQueryRequestSender( sender );
		docret.setFacilityManager( facilityManager );

		final Properties props = new Properties();
		props.setProperty( "CHECK_PREFETCH_CACHE", Boolean.FALSE.toString() );
		props.setProperty( "HomeCommunityId", "2.16.840.1.113883.4.349.1" );
		props.setProperty( "docQueryClassCodeScheme", "2.16.840.1.113883.6.1" );
		props.setProperty( "AssertionIssuer", "Test Issuer" );
		props.setProperty( "AssertionIssuerFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified" );

		PropertyLookup pl = new PropertyLookup() {
			@Override
			public String getProperty( String key ) {
				// System.out.println( "props.setProperty( \"" + key + "\",\"\");" );
				return props.getProperty( key );
			}
		};

		instance.setAdapterPolicyEngine( policyEngine );
		instance.setDataManager( TestUtils.makeDM() );
		instance.setDocumentRepository( docrepo );
		instance.setEntityDocRetrieve( docret );
		instance.setFacilityManager( facilityManager );
		instance.setPropertyLookup( pl );
		instance.setAuditManager( auditManager );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "1.1" );
				facility.setFullHomeCommunityId( "1.1" );

				allowing( auditManager ).storeAudit( with( any( Audit.class ) ) );

				allowing( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				allowing( facilityManager ).getFacilityByFacilityNumber( "200NSS" );
				will( returnValue( facility ) );

				allowing( facilityManager ).getFacilityByHomeCommunityId( "urn:oid:2.16.840.1.113883.3.184.6.1" );
				will( returnValue( facility ) );

				allowing( facilityManager ).getFacilitiesContainingAssigningAuthority(
						with( any( String.class ) ) );
				will( returnValue( Arrays.asList( facility ) ) );

				allowing( facilityManager ).getFacilityByHomeCommunityId( "1.1" );
				will( returnValue( facility ) );

				allowing( facilityManager ).isPartnerAllowed( "urn:oid:2.16.840.1.113883.17.8.1", OperationOnOff.ONBOARD );
				will( returnValue( true ) );

				allowing( facilityManager ).isPartnerAllowed( "urn:oid:2.16.840.1.113883.17.8.1", OperationOnOff.OUT_DR );
				will( returnValue( true ) );

				allowing( adapterPatientCorrelation ).retrievePatientCorrelations(
						with( any( RetrievePatientCorrelationsRequestType.class ) ) );
				will( returnValue( corrresp ) );

				allowing( docrepo ).getDocumentByDocumentUniqueId( "7ddad0cc-c71c-40e9-b92f-ecf96c56bc45" );
				will( returnValue( doc ) );

				allowing( docrepo ).storeDocument( with( any( Document.class ) ) );
			}
		} );

		RetrieveDocumentSetResponseType response
				= instance.respondingGatewayCrossGatewayRetrieve( request );

		TestUtils.assertResultsOk( RetrieveDocumentSetResponseType.class, response,
		 		"//RegistryResponse/@status", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success" );
		context.assertIsSatisfied();
	}
}
