/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.docquery;

import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingAdapterPolicyEngine;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingDocQueryRequestSender;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingExecutorService;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.audit.requests.RequestAudit;
import gov.va.med.nhin.adapter.audit.requests.RequestAuditEntity;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.patientcorrelation.PatientCorrelationPortTypeLocal;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;
import org.jmock.Expectations;
import static org.jmock.Expectations.any;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 *
 * @author ryan
 */
@RunWith( JMock.class )
public class EntityDocQueryBeanTest {

	private static final String TESTDIR = "src/test/resources";
	private static final File REQUEST_FILE
			= new File( TESTDIR, "test-entitydocquery-request-targeted.xml" );
	private static final File RESPONSE_ADHOC
			= new File( TESTDIR, "adhoc-response.xml" );
	private static final File RESPONSE_CORRELATIONS
			= new File( TESTDIR, "correlations-response.xml" );
	private static final File RESULT_FILE
			= new File( TESTDIR, "qd-out-result-ok.xml" );

	private Mockery context;
	private EntityDocQueryBean instance;

	@Before
	public void setUp() {
		this.instance = new EntityDocQueryBean();
		this.context = new JUnit4Mockery();
	}

	public EntityDocQueryBeanTest() {
	}

	@BeforeClass
	public static void setUpClass() {
		System.setProperty( "javax.xml.parsers.SAXParserFactory",
				"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl" );
	}

	@AfterClass
	public static void tearDownClass() {
	}

	@After
	public void tearDown() {
	}

	@Test
	public void testAllOk() throws Exception {
		JAXBContext jaxb = JAXBContext.newInstance( RespondingGatewayCrossGatewayQueryRequestType.class,
				AdhocQueryResponse.class, RetrievePatientCorrelationsResponseType.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		RespondingGatewayCrossGatewayQueryRequestType request
				= TestUtils.fileToPojo( REQUEST_FILE,
						RespondingGatewayCrossGatewayQueryRequestType.class, unm );
		AdhocQueryResponse adhocresp
				= TestUtils.fileToPojo( RESPONSE_ADHOC, AdhocQueryResponse.class, unm );
		final RetrievePatientCorrelationsResponseType corrresp
				= TestUtils.fileToPojo( RESPONSE_CORRELATIONS,
						RetrievePatientCorrelationsResponseType.class, unm );

		final PatientCorrelationPortTypeLocal adapterPatientCorrelation
				= context.mock( PatientCorrelationPortTypeLocal.class );
		final FacilityManager facilityManager
				= context.mock( FacilityManager.class );
		final RequestAudit requestAudit
				= context.mock( RequestAudit.class );
		final DocumentRepository docrepo
				= context.mock( DocumentRepository.class );

		EntityDocQueryOrchBean docquery = new EntityDocQueryOrchBean();
		EntityDocQueryOrchBean.SendRequestResponse sendresp = docquery.new SendRequestResponse();
		sendresp.adhocQueryResponse = adhocresp;
		sendresp.remoteHomeCommunityId = request.getAssertion().getHomeCommunity().getHomeCommunityId();

		final AdapterPolicyEnginePortTypeLocal policyEngine
				= new FakeTestingAdapterPolicyEngine( true );
		final NHINDocQueryRequestSender sender
				= new FakeTestingDocQueryRequestSender( adhocresp );
		final FakeTestingExecutorService executor
				= new FakeTestingExecutorService<>( sendresp );

		docquery.setAdapterPatientCorrelation( adapterPatientCorrelation );
		docquery.setAdapterPolicyEngine( policyEngine );
		docquery.setExecutorService( executor );
		docquery.setNhinDocQueryRequestSender( sender );
		docquery.setFacilityManager( facilityManager );
		docquery.setRequestAudit( requestAudit );

		final Properties props = new Properties();
		props.setProperty( "CHECK_PREFETCH_CACHE", Boolean.FALSE.toString() );
		props.setProperty( "HomeCommunityId", "2.16.840.1.113883.4.349.1" );
		props.setProperty( "docQueryClassCodeScheme", "2.16.840.1.113883.6.1" );
		props.setProperty( "AssertionIssuer", "Test Issuer" );
		props.setProperty( "AssertionIssuerFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified" );

		PropertyLookup pl = new PropertyLookup() {
			@Override
			public String getProperty( String key ) {
				return props.getProperty( key );
			}
		};

		instance.setAdapterPolicyEngine( policyEngine );
		instance.setDataManager( TestUtils.makeDM() );
		instance.setDocumentRepository( docrepo );
		instance.setEntityDocQuery( docquery );
		instance.setFacilityManager( facilityManager );
		instance.setPropertyLookup( pl );
		instance.setRequestAudit( requestAudit );

		context.checking( new Expectations() {
			{
				Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "1.1" );
				facility.setFullHomeCommunityId( "1.1" );

				allowing( requestAudit ).storeAudit( with( any( RequestAuditEntity.class ) ) );

				allowing( facilityManager ).getFacilityByFacilityNumber( "VA" );
				will( returnValue( facility ) );

				allowing( facilityManager ).getFacilityByFacilityNumber( "200NSS" );
				will( returnValue( facility ) );

				allowing( facilityManager ).getFacilityByHomeCommunityId( "urn:oid:2.16.840.1.113883.3.184.6.1" );
				will( returnValue( facility ) );

				allowing( facilityManager ).getFacilitiesContainingAssigningAuthority(
						with( any( String.class ) ) );
				will( returnValue( Arrays.asList( facility ) ) );

				allowing( facilityManager ).getFacilityByHomeCommunityId( "1.1" );
				will( returnValue( facility ) );

				allowing( facilityManager ).isPartnerAllowed( "1.1", OperationOnOff.ONBOARD );
				will( returnValue( true ) );

				allowing( facilityManager ).isPartnerAllowed( "1.1", OperationOnOff.OUT_DQ );
				will( returnValue( true ) );

				allowing( adapterPatientCorrelation ).retrievePatientCorrelations(
						with( any( RetrievePatientCorrelationsRequestType.class ) ) );
				will( returnValue( corrresp ) );

				allowing( docrepo ).storeDocument( with( any( Document.class ) ) );
			}
		} );

		AdhocQueryResponse response = instance.respondingGatewayCrossGatewayQuery( request );

		TestUtils.assertResultsOk( AdhocQueryResponse.class, response,
				"//Slot[@name='hash']/ValueList/Value", "96562c5b225d9a37d63e75da1ff61d5ce55b80dc" );
		context.assertIsSatisfied();
	}
}
