/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway;

import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataManagerFactory;
import gov.va.med.nhin.adapter.datamanager.DataManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import static org.junit.Assert.assertEquals;

/**
 *
 * @author ryan
 */
public class TestUtils {

	private static final String DM_CONFIG
			= "../weblogic/domains/ehx_devl/config/adapter/dataManagerConfig.xml";

	public static <T> T fileToPojo( File file, Class<T> klass, Unmarshaller unm )
			throws IOException, JAXBException {
		try ( FileInputStream fis = new FileInputStream( file ) ) {
			return unm.unmarshal( new StreamSource( fis ), klass ).getValue();
		}
	}

	public static String fileToString( File dir, String fname, String extension ) throws IOException {
		return FileUtils.readFileToString( new File( dir, fname + extension ), "utf-8" );
	}

	public static DataManager makeDM() throws IOException {
		// avoid a problem with the filename normalization algorithm
		File f = new File( "." );
		File f2 = new File( f.getAbsoluteFile(), DM_CONFIG );

		DataManagerImpl dm = DataManagerFactory.getDataManager( "TEST", f2.getCanonicalPath() );
		dm.setDataAdapter( "VistALink", new FileBasedVistA() );
		dm.setDataAdapter( "MVI1305ICNDataAdapter", new MviAdapter() );
		dm.setDataAdapter( "ESR", new EsrAdapter() );

		dm.setTranslationDef( "STSTranslate", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		dm.setTranslationDef( "STSLookup", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		dm.setTranslationDef( "Lookup", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		dm.setTranslationDef( "Translate", "gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator" );
		return dm;
	}

	public static <T> void assertResultsOk( Class<T> klass, T response,
			File expected ) throws Exception {
		JAXBContext jaxb = JAXBContext.newInstance( klass );
		StringWriter writer = new StringWriter();
		JAXBElement<T> ele
				= new JAXBElement<>( new QName( "urn:hl7-org:v3",
						klass.getSimpleName() ),
						klass, null, response );
		jaxb.createMarshaller().marshal( ele, writer );

		// System.out.println( writer );
		final String dateregex = "<creationTime value=\"[0-9]+\"/>";
		String experimental = writer.toString().replaceAll( dateregex, "" ).replaceAll( "\\s", "" );
		String ok = FileUtils.readFileToString( expected, "utf-8" ).replaceAll( dateregex, "" ).replaceAll( "\\s", "" );

		assertEquals( ok, experimental );
	}

	/**
	 * checks a marshalled version of the given response. The marshalled version
	 * has all namespaces stripped.
	 *
	 * @param <T>
	 * @param klass
	 * @param response
	 * @param xpathAndExpected an array of [i] xpath (no namespaces) [i+1]
	 * expected result
	 * @throws JAXBException
	 * @throws DocumentException
	 */
	public static <T> void assertResultsOk( Class<T> klass, T response,
			String... xpathAndExpected ) throws JAXBException, DocumentException {
		assertEquals( "xpath arg must have pairs of values",
				0, xpathAndExpected.length % 2 );

		JAXBContext jaxb = JAXBContext.newInstance( klass );
		StringWriter writer = new StringWriter();
		JAXBElement<T> ele
				= new JAXBElement<>( new QName( "urn:hl7-org:v3",
						klass.getSimpleName() ),
						klass, null, response );
		jaxb.createMarshaller().marshal( ele, writer );

		SAXReader rdr = new SAXReader();
		// System.out.println( writer );
		Document doc = rdr.read( new StringReader( writer.toString() ) );

		doc.accept( new VisitorSupport() {
			@Override
			public void visit( Document document ) {
				( (DefaultElement) document.getRootElement() )
						.setNamespace( Namespace.NO_NAMESPACE );
				document.getRootElement().additionalNamespaces().clear();
			}

			@Override
			public void visit( Element node ) {
				if ( node instanceof DefaultElement ) {
					( (DefaultElement) node ).setNamespace( Namespace.NO_NAMESPACE );
					node.additionalNamespaces().clear();
				}
			}

			@Override
			public void visit( Attribute node ) {
				if ( node.toString().contains( "xmlns" )
						|| node.toString().contains( "xsi:" ) ) {
					node.getParent().remove( node );
				}
			}
		} );

		for ( int i = 0; i < xpathAndExpected.length; i += 2 ) {
			String xpath = xpathAndExpected[i];
			String expected = xpathAndExpected[i + 1];
			String docval = doc.valueOf( xpath );
			assertEquals( "xpath failed: " + xpath, expected, docval );
		}
	}

}
