/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.mvi.hl7parsers.HL7Parser201306;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.hl7.v3.PRPAIN201306UV02;

/**
 *
 * @author ryan
 */
public class MviAdapter implements DataAdapter<Map<String, Object>> {

	private static final Logger log = Logger.getLogger( MviAdapter.class );
	private static final File RESOURCES = new File( "src/test/resources/vista-docs" );
	private static final File PRPA201306 = new File( RESOURCES, "MVI.findDemographics.xml" );

	@Override
	public List<Map<String, Object>> getData( DataQuery dataQuery ) throws Exception {
		List<Map<String, Object>> list = new ArrayList<>();
		JAXBContext jaxb = JAXBContext.newInstance( PRPAIN201306UV02.class );
		Unmarshaller unm = jaxb.createUnmarshaller();
		PRPAIN201306UV02 prpa201306
				= TestUtils.fileToPojo( PRPA201306, PRPAIN201306UV02.class, unm );

		final String queryName = dataQuery.getName();

		if ( "MVI.findDemographics".equals( queryName ) ) {
			Map<String, Object> map1306
					= HL7Parser201306.extractDemographics( prpa201306 );
			list.add( map1306 );
		}

		return list;
	}
}
