/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway;

import gov.va.med.esr.webservices.jaxws.schemas.GetEESummaryResponse;
import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

/**
 *
 * @author ryan
 */
public class EsrAdapter implements DataAdapter<GetEESummaryResponse> {

	private static final Logger log = Logger.getLogger(EsrAdapter.class );
	private static final File RESOURCES = new File( "src/test/resources/vista-docs" );
	private static final File SUMMARYFILE = new File( RESOURCES, "ESR.findEESummary.xml" );

	@Override
	public List<GetEESummaryResponse> getData( DataQuery dataQuery ) throws Exception {
		List<GetEESummaryResponse> list = new ArrayList<>();
		JAXBContext jaxb = JAXBContext.newInstance( GetEESummaryResponse.class );
		Unmarshaller unm = jaxb.createUnmarshaller();

		final String queryName = dataQuery.getName();
		if( "ESR.findEESummary".equals( queryName ) ){
			GetEESummaryResponse ee
					= TestUtils.fileToPojo( SUMMARYFILE, GetEESummaryResponse.class, unm );
			list.add( ee );
		}

		return list;
	}
}
