/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.patientcorrelation.model;

import gov.va.med.nhin.adapter.mvi.hl7parsers.HL7Parser201306;
import gov.va.med.nhin.adapter.patientdiscovery.AdapterPatientDiscovery;
import java.util.ArrayList;
import java.util.List;
import org.hl7.v3.II;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.PRPAIN201310UV02;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author jay
 */
public class Correlations extends ArrayList<Correlation> {
    
    private static final Logger logger = LoggerFactory.getLogger(Correlations.class.getName());

    public static Correlations GetFrom1306(PRPAIN201306UV02 response, boolean dedupe) {
        return GetFromList(HL7Parser201306.extractPatientIds(response), dedupe);
    }
    public static Correlations GetFrom1310(PRPAIN201310UV02 response, boolean dedupe) {
        
        if(
            response == null
            ||response.getControlActProcess() == null 
            || response.getControlActProcess().getSubject() == null 
            || response.getControlActProcess().getSubject().get(0) == null
            || response.getControlActProcess().getSubject().get(0).getRegistrationEvent() == null
            || response.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1() == null
            || response.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient() == null
            || response.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId() == null
        ) {
            throw new IllegalArgumentException("The 1310 response provided does not have any correlations contained therein.");
        }
        
        return GetFromList(response.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId(), dedupe);

    }
    public static Correlations GetFromList(List<II> patientIds, boolean dedupe) {
        if(patientIds == null) {
            throw new IllegalArgumentException("The list provided does not have any correlations contained therein.");
        }
        Correlations c = new Correlations();
        
        for(II patientId : patientIds) {
            try {
                Correlation nc = new Correlation(patientId);
                if(!dedupe || !c.contains(nc)) {
                    c.add(nc);
                }
            }catch(Exception e) {
                logger.debug("Something happened parsing a correlation: "+patientId.getExtension()+ " : "+e.getMessage());
            }
        }
        
        return c;
    }
    public Correlations toLink(Correlation candidate) {
        Correlations ret = new Correlations();
        if(!this.contains(candidate) && !candidate.getFacilityId().equalsIgnoreCase("200NSS")) {
            ret.add(candidate);
        }
        return ret;
    }
    public Correlations toUnlink(Correlation candidate) {
        Correlations ret = new Correlations();
        for(Correlation c: this) {
            if(!c.isSameFacilityAA(candidate) || c.equals(candidate)) { continue; }
            ret.add(c);
        }
        return ret;
    }
}
