/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.patientcorrelation.model;

import gov.va.med.nhin.adapter.datamanager.ParseErrorException;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.util.HashMap;
import java.util.Objects;
import org.hl7.v3.II;
import gov.hhs.fha.nhinc.patientcorrelation.nhinc.model.QualifiedPatientIdentifier;

/**
 *
 * @author jay
 */
public class Correlation extends HashMap<String, String>{
    
    public static final String VAAAID = "USVHA";
    
    public Correlation(String patientId, String type, String facilityNumber, String assigningAuthority, String status) {
        super(5);
        if(NullChecker.isNullOrEmpty(patientId)) {
            throw new ParseErrorException("Patient ID can not be empty.");
        }
        if(NullChecker.isNullOrEmpty(facilityNumber)) {
            throw new ParseErrorException("Facility ID can not be empty.");
        }
        if(NullChecker.isNullOrEmpty(assigningAuthority)) {
            throw new ParseErrorException("Assigning Authority ID can not be empty.");
        }
        this.put("correlatedPatientId", patientId);
        this.put("correlationType", NullChecker.isNullOrEmpty(type) ? "NI" : type);
        this.put("correlatedAssigningFacility", facilityNumber);
        this.put("correlatedAssigningAuthority", assigningAuthority);
        this.put("correlationStatus", NullChecker.isNullOrEmpty(status) ? "A" : status);
    }
    public Correlation(II mvi201310PatiengId) {
        super(5);
        String ext = mvi201310PatiengId.getExtension();
        if(NullChecker.isNullOrEmpty(ext)) {
            throw new ParseErrorException("Patient correlation has no extension.");
        }
        String[] splitExt = ext.split("\\^", -1);
        if(splitExt.length < 5) {
            throw new ParseErrorException("Patient correlation has not in the right format: "+ext);
        }
        if(NullChecker.isNullOrEmpty(splitExt[0])) {
            throw new ParseErrorException("Patient ID can not be empty: "+ext);
        }
        if(NullChecker.isNullOrEmpty(splitExt[1])) {
            throw new ParseErrorException("Correlation type can not be empty: "+ext);
        }
        if(NullChecker.isNullOrEmpty(splitExt[2])) {
            throw new ParseErrorException("Facility ID can not be empty: "+ext);
        }
        if(NullChecker.isNullOrEmpty(splitExt[3])) {
            throw new ParseErrorException("Assigning Authority ID can not be empty: "+ext);
        }
        if(NullChecker.isNullOrEmpty(splitExt[4])) {
            throw new ParseErrorException("Correlation Status can not be empty: "+ext);
        }
        this.put("correlatedPatientId", splitExt[0]);
        this.put("correlationType", splitExt[1]);
        this.put("correlatedAssigningFacility", splitExt[2]);
        this.put("correlatedAssigningAuthority", splitExt[3]);
        this.put("correlationStatus", splitExt[4]);
    }
    
    public String getPatientId() { return this.get("correlatedPatientId"); }
    public String getType() { return this.get("correlationType"); }
    public String getFacilityId() { return this.get("correlatedAssigningFacility"); }
    public String getAssigningAuthorityId() { return this.get("correlatedAssigningAuthority"); }
    public String getStatus() { return this.get("correlationStatus"); }
    
    public boolean isVAMC() {
        return this.get("correlatedAssigningAuthority").equalsIgnoreCase(VAAAID);
    }
    public boolean isActive() {
        return this.get("status").equalsIgnoreCase("A") || this.get("status").equalsIgnoreCase("P");
    }
    public boolean isSameFacilityAA(Correlation c) {
        return c.getFacilityId().equalsIgnoreCase(this.getFacilityId()) && c.getAssigningAuthorityId().equalsIgnoreCase(this.getAssigningAuthorityId());
    }
    
    public QualifiedPatientIdentifier getQualifiedIdentifier() {
        QualifiedPatientIdentifier qpi = new QualifiedPatientIdentifier();
        qpi.setPatientId(getPatientId());
        qpi.setAssigningAuthority(isVAMC() ? getFacilityId() : getAssigningAuthorityId());
        return qpi;
    }
    
    @Override
    public boolean equals(Object o) {
        if( this == o) { return true; }
        if(o == null || o.getClass() != this.getClass()) { return false; }
        Correlation obj = (Correlation) o;
        
        return obj.getPatientId().equalsIgnoreCase(this.getPatientId()) 
            && obj.isSameFacilityAA(this);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.getPatientId().toLowerCase());
        hash = 37 * hash + Objects.hashCode(this.isVAMC() ? this.getFacilityId().toLowerCase() : this.getAssigningAuthorityId().toLowerCase());
        return hash;
    }
}
