package gov.va.med.nhin.adapter.patientcorrelation;

import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationPortType;
import gov.hhs.fha.nhinc.patientdb.model.Patient;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.patientcorrelation.model.Correlations;

import javax.ejb.Local;

import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.v3.AddPatientCorrelationRequestType;
import org.hl7.v3.AddPatientCorrelationResponseType;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;

/**
 *
 * @author PII
 */
@Local
public interface PatientCorrelationPortTypeLocal extends PatientCorrelationPortType
{
    public RetrievePatientCorrelationsResponseType retrievePatientCorrelations( RetrievePatientCorrelationsRequestType rpcrt, DataQuery parentQuery);
    public AddPatientCorrelationResponseType addPatientCorrelation(AddPatientCorrelationRequestType addPatientCorrelationRequest, Patient searchResultsPatient, Correlations correlations, AuditEvent ae, PRPAIN201306UV02 mviResults, DataQuery parentQuery);
}