package gov.va.med.nhin.adapter.mvi.parsers;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.apache.commons.collections.CollectionUtils;
import org.hl7.v3.PRPAIN201305UV02;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectAdministrativeGender;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectBirthPlaceAddress;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectBirthPlaceName;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectBirthTime;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectId;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectName;
import org.hl7.v3.PRPAMT201306UV02MothersMaidenName;
import org.hl7.v3.PRPAMT201306UV02ParameterList;
import org.hl7.v3.PRPAMT201306UV02PatientAddress;
import org.hl7.v3.PRPAMT201306UV02PatientTelecom;
import org.hl7.v3.ST;
import org.hl7.v3.STExplicit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PRPA1306ParamListModifier
{
	private static final Logger logger = LoggerFactory.getLogger(PRPA1306ParamListModifier.class.getName());

	public static void addSemanticTextOnParamList(PRPAMT201306UV02ParameterList paramList)
	{
		if(paramList != null)
		{
			addSemTextOnGender(paramList.getLivingSubjectAdministrativeGender());
			addSemTextOnPOBTime(paramList.getLivingSubjectBirthTime());
			addSemTextOnID(paramList.getLivingSubjectId());
			addSemTextOnName(paramList.getLivingSubjectName());
			addSemTextOnAddr(paramList.getPatientAddress());
			addSemTextOnTelecom(paramList.getPatientTelecom());
			addSemTextOnBirthPlaceAddr(paramList.getLivingSubjectBirthPlaceAddress());
			addSemTextOnBirthPlaceName(paramList.getLivingSubjectBirthPlaceName());
			addSemTextOnMothersMaiden(paramList.getMothersMaidenName());
		}
	}

	public static void addSemTextOnGender(List<PRPAMT201306UV02LivingSubjectAdministrativeGender> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02LivingSubjectAdministrativeGender gender : list)
			{
				gender.setSemanticsText(createSemText("LivingSubject.administrativeGender"));
			}
		}
	}

	public static void addSemTextOnPOBTime(List<PRPAMT201306UV02LivingSubjectBirthTime> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02LivingSubjectBirthTime time : list)
			{
				time.setSemanticsText(createSemText("LivingSubject.birthTime"));
			}
		}
	}

	public static void addSemTextOnID(List<PRPAMT201306UV02LivingSubjectId> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02LivingSubjectId id : list)
			{
				id.setSemanticsText(createSemText("LivingSubject.id"));
			}
		}
	}

	public static void addSemTextOnName(List<PRPAMT201306UV02LivingSubjectName> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02LivingSubjectName name : list)
			{
				name.setSemanticsText(createSemText("LivingSubject.Name"));
			}
		}
	}

	public static void addSemTextOnAddr(List<PRPAMT201306UV02PatientAddress> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02PatientAddress addr : list)
			{
				addr.setSemanticsText(createSemText("Patient.addr"));
			}
		}
	}

	public static void addSemTextOnBirthPlaceAddr(List<PRPAMT201306UV02LivingSubjectBirthPlaceAddress> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02LivingSubjectBirthPlaceAddress addr : list)
			{
				addr.setSemanticsText(createSemText("LivingSubject.BirthPlace.Addr"));
			}
		}
	}

	public static void addSemTextOnBirthPlaceName(List<PRPAMT201306UV02LivingSubjectBirthPlaceName> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02LivingSubjectBirthPlaceName name : list)
			{
				name.setSemanticsText(createSemText("LivingSubject.BirthPlace.Place.Name"));
			}
		}
	}

	public static void addSemTextOnMothersMaiden(List<PRPAMT201306UV02MothersMaidenName> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02MothersMaidenName name : list)
			{
				name.setSemanticsText(createSemText("Person.MothersMaidenName"));
			}
		}
	}

	public static void addSemTextOnTelecom(List<PRPAMT201306UV02PatientTelecom> list)
	{
		if(CollectionUtils.isNotEmpty(list))
		{
			for(PRPAMT201306UV02PatientTelecom telecom : list)
			{
				telecom.setSemanticsText(createSemText("Patient.telecom"));
			}
		}
	}

	public static STExplicit createSemText(final String value)
	{
		STExplicit semText = new STExplicit();
		semText.getContent().add(value);
		semText.setMediaType("test/plain");

		return semText;
	}

	public static void logSemTextFrom1305(final PRPAIN201305UV02 request)
	{
		if(request != null && request.getControlActProcess() != null && request.getControlActProcess().getQueryByParameter() != null && request.getControlActProcess().getQueryByParameter().getValue() != null && request.getControlActProcess().getQueryByParameter().getValue().getParameterList() != null)
		{
			logSemanticTextFromParamList(request.getControlActProcess().getQueryByParameter().getValue().getParameterList());

			logger.trace("XML conversion : ", convertXmlToString(request));
		}
	}

	public static void logSemanticTextFromParamList(PRPAMT201306UV02ParameterList paramList)
	{
		if(paramList != null)
		{
			logListSemText(paramList.getLivingSubjectAdministrativeGender(), "Subject Gender");
			logListSemText(paramList.getLivingSubjectBirthTime(), "Subject BirthTime");
			logListSemText(paramList.getLivingSubjectId(), "Subject Id");
			logListSemText(paramList.getLivingSubjectName(), "Subject name");
			logListSemText(paramList.getPatientAddress(), "Subject Addr");
			logListSemText(paramList.getPatientTelecom(), "Subject Telecom");
			logListSemText(paramList.getLivingSubjectBirthPlaceAddress(), "Subject Birth Address");
			logListSemText(paramList.getLivingSubjectBirthPlaceName(), "Subject Birth Place Name");
			logListSemText(paramList.getMothersMaidenName(), "Subject Maiden Name");
		}
		else
		{
			logger.trace("SEMTEXT: No parameters found. {}");
		}
	}

	public static String convertXmlToString(PRPAIN201305UV02 ret)
	{
		try
		{
			JAXBContext context = JAXBContext.newInstance(PRPAIN201305UV02.class);
			Marshaller m = context.createMarshaller();
			// for pretty-print XML in JAXB
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

			// Write to System.out for debugging
			// m.marshal(emp, System.out);
			// Write to File
			StringWriter sw = new StringWriter();
			m.marshal(ret, sw);

			// CCR 177986
			logger.debug("XML String {} ", sw.getBuffer().toString());

			return sw.getBuffer().toString();
		}
		catch(Exception ex)
		{
			// CCR 177986 - logger updates
			logger.error("TEMP : couldn't convert xml to String", ex);
		}

		return null;
	}

	public static void logListSemText(final List objs, final String desc)
	{
		for(Object obj : objs)
		{
			logSemText(obj, desc);
		}
	}

	public static void logSemText(final Object obj, final String desc)
	{
		if(obj != null)
		{
			Method methods[] = obj.getClass().getMethods();
			for(Method method : methods)
			{
				if("getSemanticsText".equalsIgnoreCase(method.getName()))
				{
					Object reqObj = null;
					try
					{
						reqObj = method.invoke(obj, null);
					}
					// CCR 177821 - code update
					catch(IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
					{
						// CCR 177986
						logger.trace("Failed to parse incoming object methods {}");
					}

					if(reqObj instanceof STExplicit)
					{
						STExplicit text = (STExplicit) reqObj;

						//CCR 177986
						logger.trace("SEMTEXT: {} " + desc + " has a value of {}: "
								+ text.getContent().get(0) + " and a mediatype of {}:  "
								+ text.getMediaType());
					}
				}
			}

		}
	}
}
