package gov.va.med.nhin.adapter.adaptergateway.patientannounce;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;

import org.hl7.v3.AD;
import org.hl7.v3.ADExplicit;
import org.hl7.v3.ActClassControlAct;
import org.hl7.v3.AdxpExplicitCity;
import org.hl7.v3.AdxpExplicitPostalCode;
import org.hl7.v3.AdxpExplicitState;
import org.hl7.v3.AdxpExplicitStreetAddressLine;
import org.hl7.v3.BL;
import org.hl7.v3.CE;
import org.hl7.v3.CS;
import org.hl7.v3.EnExplicitFamily;
import org.hl7.v3.EnExplicitGiven;
import org.hl7.v3.EnExplicitPrefix;
import org.hl7.v3.EnExplicitSuffix;
import org.hl7.v3.II;
import org.hl7.v3.PNExplicit;
import org.hl7.v3.PRPAIN201305UV02;
import org.hl7.v3.PRPAMT201301UV02BirthPlace;
import org.hl7.v3.PRPAMT201301UV02Patient;
import org.hl7.v3.PRPAMT201301UV02Person;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectId;
import org.hl7.v3.PRPAMT201306UV02ParameterList;
import org.hl7.v3.RespondingGatewayPRPAIN201305UV02RequestType;
import org.hl7.v3.RespondingGatewayPRPAIN201306UV02ResponseType;
import org.hl7.v3.ST;
import org.hl7.v3.TELExplicit;
import org.hl7.v3.TSExplicit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.CeType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlIssuerType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlAuthnStatementType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlAuthzDecisionStatementType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlAuthzDecisionStatementEvidenceType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlAuthzDecisionStatementEvidenceAssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.SamlAuthzDecisionStatementEvidenceConditionsType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import gov.hhs.fha.nhinc.transform.subdisc.HL7Constants;
import gov.hhs.fha.nhinc.transform.subdisc.HL7DataTransformHelper;
import gov.hhs.fha.nhinc.transform.subdisc.HL7PRPA201305Transforms;
import gov.hhs.fha.nhinc.transform.subdisc.HL7PatientTransforms;
import gov.va.med.nhin.adapter.adaptergateway.patientdiscovery.EntityPatientDiscoveryPortTypeLocal;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientResponseType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientType;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.audit.AuditManagerLocal;
import gov.va.med.nhin.adapter.audit.requests.RequestActions;
import gov.va.med.nhin.adapter.audit.requests.RequestAudit;
import gov.va.med.nhin.adapter.audit.requests.RequestAuditEntity;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.ejb.DataManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.logging.MaintLog;
import gov.va.med.nhin.adapter.mvi.parsers.PRPA1306ParamListModifier;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.med.nhin.adapter.utils.AuditUtil;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.util.Calendar;
import javax.jws.HandlerChain;
import org.hl7.v3.CommunityPRPAIN201306UV02ResponseType;
import org.hl7.v3.PRPAMT201306UV02MothersMaidenName;
import org.hl7.v3.STExplicit;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AnnouncePatientService",
            portName = "AnnouncePatientPort",
            endpointInterface = "gov.va.med.nhin.adapter.announcepatient.AnnouncePatientPortType",
            targetNamespace = "urn:gov:va:med:nhin:adapter:announcepatient"/*,
            wsdLocation = "META-INF/wsdl/AnnouncePatient.wsdl"*/)
@HandlerChain(file = "SOAPHandlerChain.xml")
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AnnouncePatient", mappedName = "AnnouncePatient")
public class AnnouncePatient implements AnnouncePatientLocal, AnnouncePatientRemote
{
    // CCR 177986- logger update
    private static final Logger logger = LoggerFactory.getLogger(AnnouncePatient.class.getName());

    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private AuditManager auditManager;
    private EntityPatientDiscoveryPortTypeLocal entityPatientDiscovery;
    private DataManager dataManager;
    private RequestAudit requestAudit;

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager)
    {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = EntityPatientDiscoveryPortTypeLocal.class, beanName = "AdapterGatewayPatientDiscovery")
    public void setEntityPatientDiscovery(EntityPatientDiscoveryPortTypeLocal entityPatientDiscovery)
    {
        this.entityPatientDiscovery = entityPatientDiscovery;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }

    @EJB(beanInterface = RequestAudit.class, beanName = "RequestAudit")
    public void setRequestAudit(RequestAudit requestAudit)
    {
        this.requestAudit = requestAudit;
    }

    @Override
    public AnnouncePatientResponseType announcePatient(AnnouncePatientType body)
    {
        // CCR177821
        logger.debug("announcePatient invoked");
        
        
        DataQuery parentQuery = dataManager.getQuery("JustCache");
        parentQuery.getResults();

        AnnouncePatientResponseType ret = new AnnouncePatientResponseType();
        RequestAuditEntity requestAuditEntity = new RequestAuditEntity();
        requestAuditEntity.generateUUID();
        requestAuditEntity.setStartTime(new Date());
        requestAuditEntity.setAction(RequestActions.ANNOUNCE_PATIENT.getValue());
        if (body != null && body.getUserInfo() != null) {
            requestAuditEntity.setuName(body.getUserInfo().getUserId());
        }
        else {
            requestAuditEntity.setuName("Failed to find PID.");
        }
        try {
            if (body == null || body.getPatientId() == null) {
                logger.warn("No Patient ID/ICN was found in the AnnoucePatient request.");
                requestAuditEntity.setStatus("No PID");
                ret.setReturn(-1);
            }
            else {
                Map patient = getPatient(body.getPatientId(), parentQuery);
                Map demographics = null;

                if (patient != null && (demographics = (Map)patient.get("demographics")) != null) {
                    String givenName = (String)demographics.get("nameGiven");
                    String prefix = (String)demographics.get("namePrefix");
                    String middleName = (String)demographics.get("nameMiddle");
                    String suffix = (String)demographics.get("nameSuffix");
                    String lastName = (String)demographics.get("nameFamily");
                    String mmn = (String)demographics.get("mothersMaidenName");
                    String gender = (String)demographics.get("genderCode");
                    String dob = demographics.get("birthDate").toString();
                    String ssn = (String)demographics.get("SSN");
                    String patientId = (String)demographics.get("MRN");
                    String homeCommunityId = getHomeFacility().getHomeCommunityId();
                    String address = (String)demographics.get("homeAddressStreet");
                    String city = (String)demographics.get("homeAddressCity");
                    String state = (String)demographics.get("homeAddressState");
                    String zip = (String)demographics.get("homeAddressPostal");
                    String pobAddress = (String)demographics.get("pobStreet");
                    String pobCity = (String)demographics.get("pobCity");
                    String pobState = (String)demographics.get("pobState");
                    String pobZip = (String)demographics.get("pobPostal");
                    String phone = (String)demographics.get("phoneHome");
                    String maritalStatus = (String)demographics.get("maritalStatusCode");
                    String multiBirth = (String)demographics.get("multipleBirthCode");

                    String patientDemographics = null;
                    patientDemographics = "ssn=" + ssn + ", lastName=" + lastName + ", ";
                    if (givenName != null) {

                        patientDemographics += "middleName=" + givenName + ", ";
                    }
                    else {
                        patientDemographics += "middleName=, ";
                    }
                    patientDemographics += "givenName=" + givenName + ", prefix=" + prefix + ", ";
                    patientDemographics += "suffix=" + suffix + ", mmn=" + mmn + ", dob=" + dob + ", ";
                    if (address != null) {
                        patientDemographics += "address=" + address + ", ";
                    }
                    patientDemographics += "city=" + city + ", ";
                    patientDemographics += "state=" + state + ", zip=" + zip + ", ";
                    patientDemographics += "phone=" + phone + ", gender=" + gender + ", ";
                    patientDemographics += "multiBirth=" + multiBirth + ", maritalStatus=" + maritalStatus + ", ";
                    patientDemographics += "patientId=" + patientId + ", homeCommunityId=" + homeCommunityId + ", ";
                    patientDemographics += "pobcity=" + pobCity + ", pobstate=" + pobState;

                    PRPAIN201305UV02 prpain201305 = createPRPAIN201305(lastName, givenName, middleName, prefix, suffix, mmn, dob, city, state, address, zip, pobCity, pobState, pobAddress, pobZip, phone, gender, multiBirth, maritalStatus, patientId, homeCommunityId, ssn);

                    AssertionType assertion = createAssertion(body, parentQuery);

                    RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
                    request.setPRPAIN201305UV02(prpain201305);
                    request.setAssertion(assertion);

                    if (hasFacilities(body)) {
                        NhinTargetCommunitiesType targetCommunities = new NhinTargetCommunitiesType();

                        for (String facilityNumber : body.getFacilities().getFacility()) {
                            // Facilities can be specified using VistA facility number or urn:oid: format.
                            Facility facility;
                            if (facilityNumber.regionMatches(true, 0, "urn:oid:", 0, 8)) {
                                facility = facilityManager.getFacilityByFullHomeCommunityId(facilityNumber);
                            }
                            else {
                                facility = facilityManager.getFacilityByFacilityNumber(facilityNumber);
                            }
                            
                            if (facility != null) {
                                if (facilityManager.isPartnerAllowed(facility.getHomeCommunityId(), OperationOnOff.ONBOARD)) {
                                    if (facilityManager.isPartnerAllowed(facility.getHomeCommunityId(), OperationOnOff.OUT_PD)) {
                                        NhinTargetCommunityType targetCommunity = new NhinTargetCommunityType();
                                        HomeCommunityType hc = new HomeCommunityType();
                                        hc.setHomeCommunityId(facility.getHomeCommunityId());
                                        targetCommunity.setHomeCommunity(hc);
                                        targetCommunities.getNhinTargetCommunity().add(targetCommunity);
                                    }
                                    else {
                                        MaintLog.queryError(null, ErrorMessage.OUT_PD_DISABLED, "Will not announce to " + facility.getHomeCommunityId(), logger);
                                        auditWarning(requestAuditEntity.getUuid(), facility.getHomeCommunityId(), ErrorMessage.OUT_PD_DISABLED.getMessage());
                                        // Log if no announcement will be made to partner
                                        auditFacilityStatus(assertion, body.getPatientId(), ErrorMessage.OUT_PD_DISABLED.getMessage() + " " + patientDemographics, facility, givenName, lastName, ssn, body.getHieTransactionId());
                                    }
                                }
                                else {
                                    MaintLog.queryError(null, ErrorMessage.OUT_PD_NOT_A_PARTNER, "Will not announce to " + facility.getHomeCommunityId(), logger);
                                    auditWarning(requestAuditEntity.getUuid(), facility.getHomeCommunityId(), ErrorMessage.OUT_PD_NOT_A_PARTNER.getMessage());
                                    // Log if no announcement will be made to partner
                                    auditFacilityStatus(assertion, body.getPatientId(), ErrorMessage.OUT_PD_NOT_A_PARTNER.getMessage() + " " + patientDemographics, facility, givenName, lastName, ssn, body.getHieTransactionId());
                                }
                            }
                            else {
                                logger.warn("{} is not a known facility number.", facilityNumber);
                                auditWarning(requestAuditEntity.getUuid(), facilityNumber, ErrorMessage.OUT_PD_NOT_A_PARTNER.getMessage());
                            }
                        }

                        request.setNhinTargetCommunities(targetCommunities);
                    }

                    if (request.getNhinTargetCommunities() == null || NullChecker.isNotNullOrEmpty(request.getNhinTargetCommunities().getNhinTargetCommunity())) {
                        requestAuditEntity.setPid(body.getPatientId());

                        if (assertion != null) {
                            if (assertion.getHomeCommunity() != null && NullChecker.isNotNullOrEmpty(assertion.getHomeCommunity().getHomeCommunityId())) {
                                requestAuditEntity.setHcid(assertion.getHomeCommunity().getHomeCommunityId());
                            }
                        }

                        II queryId = new II();
                        queryId.setRoot(propertyLookup.getProperty("HomeCommunityId"));
                        queryId.setExtension(requestAuditEntity.getUuid());
                        request.getPRPAIN201305UV02().getControlActProcess().getQueryByParameter().getValue().setQueryId(queryId);

                        try {
                            //RespondingGatewayPRPAIN201306UV02ResponseType result = entityPatientDiscovery.respondingGatewayPRPAIN201305UV02(request);
                            RespondingGatewayPRPAIN201306UV02ResponseType result = entityPatientDiscovery.respondingGatewayPRPAIN201305UV02(request, patientDemographics, parentQuery);
                            ret.setReturn(getSuccessfulPDs(result.getCommunityResponse()));
                        }
                        catch (Exception e) {
                            logger.error("Call to entityPatientDiscovery failed due to some exception.", e);
                            requestAuditEntity.setStatus("Failed: " + e.getMessage());
                            ret.setReturn(-1);
                        }
                    }
                    else {
                        logger.warn("Announce not initiated because given targets don't correspond to known NwHIN partners.");
                        requestAuditEntity.setStatus("Failed: No partners.");
                        ret.setReturn(0);
                    }
                }
                else {
                    // CCR 177986-logger updates
                    logger.debug("Patient with ICN={} does not have enough information to be announced to NwHIN", body.getPatientId());
                    ret.setReturn(0);
                }
            }
        }
        catch (Exception ex) {
            requestAuditEntity.setStatus("ERROR: " + ex.toString());
            logger.error("Failed to process announce: ", ex);
            ret.setReturn(-1);
        }

        requestAuditEntity.setStopTime(new Date());

        try {
            requestAudit.storeAudit(requestAuditEntity);
        }
        catch (Exception ex) {
            logger.error("Failed to store announce audit logging with exception: ", ex);
        }

        logger.debug(" announcePatient exited");

        return ret;
    }

    private int getSuccessfulPDs(List<CommunityPRPAIN201306UV02ResponseType> results)
    {
        int ret = 0;
        for (CommunityPRPAIN201306UV02ResponseType r : results) {
            if (r.getPRPAIN201306UV02() != null
                && r.getPRPAIN201306UV02().getControlActProcess() != null
                && r.getPRPAIN201306UV02().getControlActProcess().getQueryAck() != null
                && r.getPRPAIN201306UV02().getControlActProcess().getQueryAck().getQueryResponseCode() != null
                && r.getPRPAIN201306UV02().getControlActProcess().getQueryAck().getQueryResponseCode().getCode() != null
                && r.getPRPAIN201306UV02().getControlActProcess().getQueryAck().getQueryResponseCode().getCode().equals("OK")
                && r.getPRPAIN201306UV02().getControlActProcess().getSubject() != null
                && r.getPRPAIN201306UV02().getControlActProcess().getSubject().size() > 0) {
                ++ret;
            }
        }
        return ret;
    }
    
    private void auditFacilityStatus(AssertionType assertion, String patientId, String errorMessage, Facility facility, String givenName, String lastName, String ssn, String hieTransactionId)
    {
        Audit audit = new Audit();
        audit.setAction("Announce");
        audit.setDetails("Failure - " + errorMessage);
        audit.setAuditTime(new Date());
        audit.setUserId(assertion.getUserInfo().getUserName());

        audit.setSystemId(AuditUtil.checkSystemId(assertion));

        audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
        audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
        audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
        if (assertion.getUserInfo().getPersonName() != null) {
            PersonNameType personName = assertion.getUserInfo().getPersonName();
            if (!NullChecker.isNullOrEmpty(personName.getFullName())) {
                audit.setUserName(personName.getFullName());
            }
            else {
                audit.setUserName(personName.getGivenName() + " " + personName.getFamilyName());
            }
        }
        audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
        audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
        audit.setPatientId(patientId);
        audit.setPatientGivenName(givenName);
        audit.setPatientLastName(lastName);
        audit.setPatientSSN(ssn);
        audit.setHieTransactionId(hieTransactionId);
        audit.setRemoteOrganization(facility);
        audit.setRemoteOrganizationId(facility.getFullHomeCommunityId());

        auditManager.storeAudit(audit);
    }

    private boolean hasFacilities(final AnnouncePatientType body)
    {
        if (body == null || NullChecker.isNullOrEmpty(body.getFacilities())) {
            return false;
        }

        if (NullChecker.isNullOrEmpty(body.getFacilities().getFacility())) {
            return false;
        }

        return true;
    }

    private void auditWarning(final String uuid, final String remoteHCID, final String errorMsg)
    {
        RequestAuditEntity auditEntity = new RequestAuditEntity();
        auditEntity.setStartTime(new Date());
        auditEntity.setUuid(uuid);

        auditEntity.setPid("N/A");

        auditEntity.setHcid(remoteHCID);
        auditEntity.setAction(RequestActions.PATIENT_DISCOVERY.getValue());
        auditEntity.setStopTime(new Date());
        auditEntity.setStatus("Warning: " + errorMsg);
        requestAudit.storeAudit(auditEntity);
    }

    private Map getPatient(String icn, DataQuery parentQuery)
    {
        Map ret = null;

        // DataQuery query = dataManager.getQuery("Composite.findDemographics");
        DataQuery query = dataManager.getQuery("Composite.findDemographics2", parentQuery);
        query.setParameter("icn", icn);
        List<Map> results = query.getResults();
        if (NullChecker.isNotNullOrEmpty(results)) {
            ret = results.get(0);
        }

        return ret;
    }

    private PRPAIN201305UV02 createPRPAIN201305(String lastName, String givenName, String middleName, String prefix, String suffix, String mothersMaidenName, String dob, String city, String state, String address, String zip, String pobCity, String pobState, String pobAddress, String pobZip, String phone, String gender, String multiBirth, String maritalStatus, String patientId, String homeCommunityId, String ssn)
    {
        JAXBElement<PRPAMT201301UV02Person> patientPerson = buildPRPAIN201301PatientPerson(lastName, givenName, middleName, prefix, suffix, mothersMaidenName, dob, city, state, address, zip, pobCity, pobState, pobAddress, pobZip, phone, gender, multiBirth, maritalStatus);
        org.hl7.v3.ObjectFactory factory = new org.hl7.v3.ObjectFactory();
        
        String assigningAuthority = propertyLookup.getProperty("AssigningAuthority");

        II ii = new II();
        ii.setRoot(assigningAuthority);
        ii.setExtension(patientId);
        String assigningAuthorityName = propertyLookup.getProperty("AssigningAuthorityName");
        if (NullChecker.isNotNullOrEmpty(assigningAuthorityName)) {
            ii.setAssigningAuthorityName(assigningAuthorityName);
        }

        PRPAMT201301UV02Patient patient = HL7PatientTransforms.create201301Patient(patientPerson, ii);

        PRPAIN201305UV02 ret = HL7PRPA201305Transforms.createPRPA201305(patient, homeCommunityId, "1.1", assigningAuthority);

        // add ssn.
        PRPAMT201306UV02ParameterList paramList = ret.getControlActProcess().getQueryByParameter().getValue().getParameterList();
        PRPA1306ParamListModifier.addSemanticTextOnParamList(paramList);

        PRPAMT201306UV02LivingSubjectId ssnId = new PRPAMT201306UV02LivingSubjectId();
        ii = new II();
        ii.setRoot("2.16.840.1.113883.4.1");
        ii.setExtension(ssn);
        ssnId.getValue().add(ii);
        STExplicit text = new STExplicit();
        text.getContent().add("LivingSubject.id");
        ssnId.setSemanticsText(text);
        paramList.getLivingSubjectId().add(ssnId);

        if (NullChecker.isNotNullOrEmpty(mothersMaidenName)) {
            PRPAMT201306UV02MothersMaidenName mmn = new PRPAMT201306UV02MothersMaidenName();
            PNExplicit pne = new PNExplicit();
            EnExplicitFamily family = new EnExplicitFamily();
            family.setPartType("FAM");
            family.setContent(mothersMaidenName);
            pne.getContent().add(factory.createPNExplicitFamily(family));
            STExplicit text2 = new STExplicit();
            text2.getContent().add("MothersMaidenName"); // TODO: make sure this is right.
            mmn.setSemanticsText(text2);
            mmn.getValue().add(pne);
            paramList.getMothersMaidenName().add(mmn);
        }
        
        // fix the interaction id.
        ret.setInteractionId(HL7DataTransformHelper.IIFactory(HL7Constants.INTERACTION_ID_ROOT, "PRPA_IN201305UV02"));

        // fix the controlActProccess/code.
        ret.getControlActProcess().setCode(HL7DataTransformHelper.CDFactory("PRPA_TE201305UV02", HL7Constants.INTERACTION_ID_ROOT));

        // fix the acceptAckCode.
        ret.setAcceptAckCode(HL7DataTransformHelper.CSFactory("NE"));

        // fix the processingModeCode.
        ret.setProcessingModeCode(HL7DataTransformHelper.CSFactory("T"));

        ret.getControlActProcess().setClassCode(ActClassControlAct.CACT);
        ret.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().setClassCode("ASSIGNED");

        // fix the creation time of the message.
        TSExplicit te = new TSExplicit();
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        te.setValue(formatter.format(now));
        ret.setCreationTime(te);

        CS responseModalityCode = new CS();
        responseModalityCode.setCode("R");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponseModalityCode(responseModalityCode);

        CS responsePriorityCode = new CS();
        responsePriorityCode.setCode("I");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponsePriorityCode(responsePriorityCode);

        return ret;
    }

    private JAXBElement<PRPAMT201301UV02Person> buildPRPAIN201301PatientPerson(String lastName, String givenName, String middleName, String prefix, String suffix, String mothersMaidenName, String dob, String city, String state, String address, String zip, String pobCity, String pobState, String pobAddress, String pobZip, String phone, String gender, String multiBirth, String maritalStatus)
    {
        PRPAMT201301UV02Person patientPerson = new PRPAMT201301UV02Person();

        // --------------------------------------------------------------
        // build name
        org.hl7.v3.ObjectFactory factory = new org.hl7.v3.ObjectFactory();
        PNExplicit name = (PNExplicit)(factory.createPNExplicit());
        List namelist = name.getContent();

        // Last name
        EnExplicitFamily familyName = new EnExplicitFamily();
        familyName.setPartType("FAM");
        familyName.setContent(lastName);
        namelist.add(factory.createPNExplicitFamily(familyName));

        // First name
        if (NullChecker.isNotNullOrEmpty(givenName)) {
            EnExplicitGiven gn = new EnExplicitGiven();
            gn.setPartType("GIV");
            gn.setContent(givenName);
            namelist.add(factory.createPNExplicitGiven(gn));

            // Middle name
            if (NullChecker.isNotNullOrEmpty(middleName)) {
                EnExplicitGiven mn = new EnExplicitGiven();
                mn.setPartType("GIV");
                mn.setContent(middleName);
                namelist.add(factory.createPNExplicitGiven(mn));
            }
        }

        EnExplicitPrefix pfx = new EnExplicitPrefix();
        pfx.setContent(prefix);
        pfx.setPartType("PFX");
        namelist.add(factory.createENExplicitPrefix(pfx));

        EnExplicitSuffix sfx = new EnExplicitSuffix();
        sfx.setContent(suffix);
        sfx.setPartType("SFX");
        namelist.add(factory.createENExplicitSuffix(sfx));

        patientPerson.getName().add(name);
        // ------------------------------------------------------------

        // build Mother's Maiden Name
        if (NullChecker.isNotNullOrEmpty(mothersMaidenName)) {
            PNExplicit mmn = (PNExplicit)(factory.createPNExplicit());
            mmn.getUse().add("C");
            List mmnNameList = mmn.getContent();
            EnExplicitFamily mothersFamilyName = new EnExplicitFamily();
            mothersFamilyName.setPartType("FAM");
            mothersFamilyName.setContent(mothersMaidenName);
            mmnNameList.add(factory.createPNExplicitFamily(mothersFamilyName));
            patientPerson.getName().add(mmn);
        }

        // Date of Birth
        TSExplicit valueTSExplicit = new TSExplicit();
        valueTSExplicit.setValue(dob);
        patientPerson.setBirthTime(valueTSExplicit);

        // Gender
        CE valueCE = new CE();
        valueCE.setCode(gender);
        patientPerson.setAdministrativeGenderCode(valueCE);

        // -------------------------------------------------------------
        // build address
        ADExplicit addr = (ADExplicit)(factory.createADExplicit());
        List addrlist = addr.getContent();

        // address
        AdxpExplicitCity valueCity = new AdxpExplicitCity();
        valueCity.setContent(city);
        addrlist.add(factory.createADExplicitCity(valueCity));

        AdxpExplicitState valueState = new AdxpExplicitState();
        valueState.setContent(state);
        addrlist.add(factory.createADExplicitState(valueState));

        if (NullChecker.isNotNullOrEmpty(address)) {
            AdxpExplicitStreetAddressLine line = new AdxpExplicitStreetAddressLine();
            line.setContent(address);
            addrlist.add(factory.createADExplicitStreetAddressLine(line));
        }

        AdxpExplicitPostalCode valueZip = new AdxpExplicitPostalCode();
        valueZip.setContent(zip);
        addrlist.add(factory.createADExplicitPostalCode(valueZip));

        patientPerson.getAddr().add(addr);
        // --------------------------------------------------------------

        // build place of birth
        if (NullChecker.isNotNullOrEmpty(pobCity) || NullChecker.isNotNullOrEmpty(pobState) || NullChecker.isNotNullOrEmpty(pobAddress) || NullChecker.isNotNullOrEmpty(pobZip)) {
            PRPAMT201301UV02BirthPlace reqPob = new PRPAMT201301UV02BirthPlace();
            AD pobAddr = (AD)(factory.createAD());
            List pobAddrList = pobAddr.getContent();
            // address
            if (NullChecker.isNotNullOrEmpty(pobCity)) {
                AdxpExplicitCity pobValueCity = new AdxpExplicitCity();
                pobValueCity.setContent(pobCity);
                pobAddrList.add(factory.createADExplicitCity(pobValueCity));
            }
            if (NullChecker.isNotNullOrEmpty(pobState)) {
                AdxpExplicitState pobValueState = new AdxpExplicitState();
                pobValueState.setContent(pobState);
                pobAddrList.add(factory.createADExplicitState(pobValueState));
            }
            if (NullChecker.isNotNullOrEmpty(pobAddress)) {
                AdxpExplicitStreetAddressLine pobLine = new AdxpExplicitStreetAddressLine();
                pobLine.setContent(pobAddress);
                addrlist.add(factory.createADExplicitStreetAddressLine(pobLine));
            }
            if (NullChecker.isNotNullOrEmpty(pobZip)) {
                AdxpExplicitPostalCode pobValueZip = new AdxpExplicitPostalCode();
                pobValueZip.setContent(pobZip);
                pobAddrList.add(factory.createADExplicitPostalCode(pobValueZip));
            }
            reqPob.setAddr(pobAddr);
            patientPerson.setBirthPlace(factory.createPRPAMT201301UV02PersonBirthPlace(reqPob));
        }
        // telephone
        TELExplicit valueTELE = new TELExplicit();
        valueTELE.setValue(phone);
        patientPerson.getTelecom().add(valueTELE);

        // multi birth
        BL valueBL = new BL();
        if (multiBirth == null || multiBirth.length() == 0 || multiBirth.startsWith("NO") || multiBirth.startsWith("no")) {
            valueBL.setValue(false);
        }
        else {
            valueBL.setValue(true);
        }
        patientPerson.setMultipleBirthInd(valueBL); // BL value

        // marital status
        CE maritalStatusCode = new CE();
        maritalStatusCode.setCode(maritalStatus);
        patientPerson.setMaritalStatusCode(maritalStatusCode);

        return factory.createPRPAMT201301UV02PatientPatientPerson(patientPerson);
    }

    private AssertionType createAssertion(AnnouncePatientType announcePatient, DataQuery parentQuery)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        PersonNameType personName = new PersonNameType();
        if (NullChecker.isNotNullOrEmpty(announcePatient.getUserInfo().getFullName())) {
            personName.setFamilyName(announcePatient.getUserInfo().getFullName());
        }
        else {
            personName.setFamilyName(announcePatient.getUserInfo().getUserId());
        }

        UserType user = new UserType();
        user.setUserName(announcePatient.getUserInfo().getUserId() + ", CN=" + personName.getFamilyName() + ", O=" + homeFacility.getFacilityName());
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        CeType roleCoded = new CeType();
        roleCoded.setCodeSystem("2.16.840.1.113883.6.96");
        roleCoded.setCodeSystemName("SNOMED_CT");
        roleCoded.setCode("224608005");
        DataQuery query = dataManager.getQuery("STS.lookupSNOMED", parentQuery);
        query.setParameter("code", roleCoded.getCode());
        List<Map> results = query.getResults();
        roleCoded.setDisplayName((String)results.get(0).get("name"));
        user.setRoleCoded(roleCoded);
        ret.setUserInfo(user);

        ret.getUniquePatientId().add(announcePatient.getPatientId() + "^^^&" + propertyLookup.getProperty("AssigningAuthority") + "&ISO");

        CeType p = new CeType();
        p.setCode("TREATMENT");
        p.setCodeSystem("2.16.840.1.113883.3.18.7.1");
        p.setCodeSystemName("nhin-purpose");
        p.setDisplayName("Treatment");
        ret.setPurposeOfDisclosureCoded(p);

        SamlIssuerType sit = new SamlIssuerType();
        sit.setIssuer(propertyLookup.getProperty("AssertionIssuer"));
        sit.setIssuerFormat(propertyLookup.getProperty("AssertionIssuerFormat"));
        ret.setSamlIssuer(sit);
        
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Calendar cal = Calendar.getInstance();
        String nowDate = formatter.format(cal.getTime());
        cal.add(Calendar.MINUTE, 20);
        
        SamlAuthnStatementType sast = new SamlAuthnStatementType();
        sast.setAuthInstant(nowDate); // DATE
        sast.setSessionIndex(UUID.randomUUID().toString()); // SESSION-INDEX
        sast.setAuthContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:X509"); // AUTH-CONTEXT-CLASS-REF
        sast.setSubjectLocalityAddress("Austin, TX USA"); // SUBJECT-LOCALITY-ADDRESS
        sast.setSubjectLocalityDNSName("DOMAIN.EX"); // SUBJECT-LOCALITY-DNS-NAME
        ret.setSamlAuthnStatement(sast);
        
        SamlAuthzDecisionStatementType sadst = new SamlAuthzDecisionStatementType();
        sadst.setDecision("Permit"); // The Decision attribute of the Authorization Decision Statement must be Permit.
        sadst.setResource(""); // The Resource attribute of the Authorization Decision Statement must be the Uniform Resource Identifier
                               // (URI) of the endpoint to which the CMS esMD CONNECT Gateway request is addressed or an empty
                               // URI reference.
        sadst.setAction("Execute"); // This action must be specified using a value of Execute
        SamlAuthzDecisionStatementEvidenceType sasdet = new SamlAuthzDecisionStatementEvidenceType();
        SamlAuthzDecisionStatementEvidenceAssertionType sadseat = new SamlAuthzDecisionStatementEvidenceAssertionType();
        sadseat.setId(UUID.randomUUID().toString());
        sadseat.setIssueInstant(nowDate); // date
        sadseat.setVersion("2.0");
        sadseat.setIssuerFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName"); 
        sadseat.setIssuer("CN=eHX, OU=MiddleWare Infrastructure, O=U.S. Department of Veterans Affairs, L=Austin, S=Texas, C=US"); // CN=SAML User,OU=connect,O=FHA,L=Melbourne,ST=FL,C=US
        SamlAuthzDecisionStatementEvidenceConditionsType sadsect = new SamlAuthzDecisionStatementEvidenceConditionsType();
        sadsect.setNotBefore(nowDate); // date
        sadsect.setNotOnOrAfter(formatter.format(cal.getTime())); // date
        sadseat.setConditions(sadsect);
        sasdet.setAssertion(sadseat);
        sadst.setEvidence(sasdet);
        ret.setSamlAuthzDecisionStatement(sadst);

        ret.setMessageId("urn:uuid:" + UUID.randomUUID().toString());

        return ret;
    }

    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}
T