package gov.va.med.nhin.adapter.adaptergateway.docretrieve;

import com.sun.xml.ws.client.BindingProviderProperties;
import java.net.MalformedURLException;
import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrieve;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType;
import gov.va.med.nhin.adapter.logging.EventAuditingFactoryImpl;
import gov.va.med.nhin.adapter.logging.MessagingHelper;
import gov.va.med.nhin.adapter.logging.MessagingHelper.QueryType;
import gov.va.med.nhin.adapter.utils.soap.handler.SOAPHandlerResolver;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.MTOMFeature;
import org.hl7.fhir.dstu3.model.AuditEvent;

/**
 *
 * @author David Vazquez
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "NhincProxyNHINDocRetrieveRequestSender")
public class NhincProxyNHINDocRetrieveRequestSender implements NHINDocRetrieveRequestSender
{
    private static final Logger logger = LoggerFactory.getLogger(NhincProxyNHINDocRetrieveRequestSender.class.getName());

    private EntityDocRetrieve entityDocRetrieve;
    private EntityDocRetrieve entityDocRetrieve2011;
    private PropertyLookup propertyLookup;

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @Override
    public RetrieveDocumentSetResponseType sendRequest(RetrieveDocumentSetRequestType docRetrieveRequest,
                                                       AssertionType assertion, String remoteHomeCommunityId, boolean use2011Spec, AuditEvent event)
    {
        // CCR 177986
        logger.debug("Entering NhincProxyNHINDocRetrieveRequestSender::sendRequest");

        RetrieveDocumentSetResponseType ret = null;

        try {
            gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType request = new gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType();
            request.setRetrieveDocumentSetRequest(docRetrieveRequest);
            request.setAssertion(assertion);
            request.setNhinTargetCommunities(createNhinTargetCommunities(remoteHomeCommunityId));

            //changed on 02/01/2017 (EHX-12)
            logger.debug("Implementing timeout properties!");
            EntityDocRetrievePortType port = getDocRetrieveEntityPort(use2011Spec);
            Map<String, Object> requestContext = ((BindingProvider)port).getRequestContext();
            requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, Integer.parseInt(propertyLookup.getProperty("REQUEST_TIMEOUT")));
            requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, Integer.parseInt(propertyLookup.getProperty("CONNECT_TIMEOUT")));

            MessagingHelper<AuditEvent> msg
                                        = EventAuditingFactoryImpl.getFactory(AuditEvent.class).messaging();
            if (null != event) {
                msg.addQuery(event, request, RespondingGatewayCrossGatewayRetrieveRequestType.class,
                             QueryType.REQUEST, null);
            }

            ret = port.respondingGatewayCrossGatewayRetrieve(request);

            if (null != event) {
                msg.addQuery(event, ret, RetrieveDocumentSetResponseType.class,
                             QueryType.RESPONSE, null);
            }
        }
        catch (MalformedURLException t) {
            logger.error("Sending request failed due to {}", t);
        }
        return ret;
    }

    private NhinTargetCommunitiesType createNhinTargetCommunities(String homeCommunityId)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeCommunityId);

        NhinTargetCommunityType homeTargetCommunity = new NhinTargetCommunityType();
        homeTargetCommunity.setHomeCommunity(homeCommunity);

        NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
        ret.getNhinTargetCommunity().add(homeTargetCommunity);

        return ret;
    }

    private EntityDocRetrievePortType getDocRetrieveEntityPort(boolean use2011Spec) throws MalformedURLException
    {
        // disable MTOMFeature because MTOM client requests sent by JAX-WS 2.2.11
        // implementation in weblogic 12c (12.2.1.2.0) are not compatible with
        // older MTOM server side implemenations (e. g. jdk7/weblogic 12c (12.1.1)
        // on which CONNECT 4.5 is runs.  TODO: Revisit this when we upgrade
        // to CONNECT 5.
        MTOMFeature m = new MTOMFeature(false);

        if (use2011Spec) {
            if (entityDocRetrieve2011 == null) {
                entityDocRetrieve2011 = new EntityDocRetrieve(new URL(propertyLookup.getProperty("DocRetrieve2011ProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitydocretrieve", "EntityDocRetrieve"));
                entityDocRetrieve2011.setHandlerResolver(new SOAPHandlerResolver(true));
            }

            return entityDocRetrieve2011.getEntityDocRetrievePortSoap(m);
        }
        else {
            if (entityDocRetrieve == null) {
                entityDocRetrieve = new EntityDocRetrieve(new URL(propertyLookup.getProperty("DocRetrieveProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitydocretrieve", "EntityDocRetrieve"));
                entityDocRetrieve.setHandlerResolver(new SOAPHandlerResolver(true));
            }

            return entityDocRetrieve.getEntityDocRetrievePortSoap(m);
        }
    }
}
