package gov.va.med.nhin.adapter.policyengine.pdpproxy;

import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;

import gov.va.med.nhin.adapter.permission.pdp.PermissionPDPPortType;
import gov.va.med.nhin.adapter.permission.pdp.PermissionPDPService;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

/**
 *
 * @author PII
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "PDPProxyCPP")
public class PDPProxyCPP implements PDPProxyLocal
{
	private PermissionPDPService permissionPDPService;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public ResponseType checkPolicy(RequestType request)
	{
		return getPermissionPDPPort().checkPolicy(request);
	}

	private PermissionPDPPortType getPermissionPDPPort()
	{
		if(permissionPDPService == null)
		{
			try
			{
				permissionPDPService = new PermissionPDPService(new URL(propertyLookup.getProperty("PermissionPDPServiceWSDL")), new QName("urn:gov:va:med:nhin:adapter:permission:pdp", "PermissionPDPService"));
			}
			catch(Throwable t)
			{
				throw new RuntimeException("Unable to get PermissionPDPPort.");
			}
		}

		return permissionPDPService.getPermissionPDPPort();
	}
}
