/**
 *
 *
 */
package gov.va.med.nhin.adapter.dataquality.transmissionlog;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.TransactionRequiredException;

/**
 *
 *
 */
public interface DqTransmissionLogManager {
    
    public static final String DHUPLOAD_EVENTTYPE = "DiameterHealth_UploadDataFile"; 
    public static final String DQZIPSTORE_EVENTTYPE = "DQZipFile_PackDataFileInside"; 
    public static final String DQZIPMOVE_EVENTTYPE = "DQZipFile_MoveZipFileForPickup";
    
    
    public void logDHUpload(String batchId, Date startTime, Date endTime, String hostname, String localDocId, String filename, String filetype, double filesize, String destination, String status, String remoteDocId, String error) throws EntityExistsException , IllegalArgumentException , TransactionRequiredException;
    
    public void logDQZipStore(String batchId, Date startTime, Date endTime, String hostname, String localDocId, String filename, String filetype, double filesize, String destination, String status, String remoteDocId, String error) throws EntityExistsException , IllegalArgumentException , TransactionRequiredException;
    
    public void logDQZipMove(String batchId, Date startTime, Date endTime, String hostname, String localDocId, String filename, String filetype, double filesize, String destination, String status, String remoteDocId, String error) throws EntityExistsException , IllegalArgumentException , TransactionRequiredException;
    
    public int getDHUploadEventCount(Date beginStartDate, Date finishStartDate, String batchId, String hostname, String filename, String destination, String status);
        
    public int getDQZipStoreEventCount(Date beginStartDate, Date finishStartDate, String batchId, String hostname, String filename, String destination, String status);
    
    public int getDQZipSendEventCount(Date beginStartDate, Date finishStartDate, String batchId, String hostname, String filename, String destination, String status);
    
    public int getEventCount(String eventType, Date beginStartDate, Date finishStartDate, String batchId, String hostname, String filename, String destination, String status);
    
    public int getUniqueFilenameEventCount(String eventType, Date beginStartDate, Date finishStartDate, String batchId, String filename, String status);
    
    public int getUniqueFilenameStatusCountNative(String eventType, Date beginStartDate, Date finishStartDate, String status);
    
    public boolean isAlreadySuccessfulEventByFilename(String eventType, String filename, Date beginStartDate, Date finishStartDate);
    
    public boolean isAlreadySuccessfulEventByLocalDocId(String eventType, String localDocId, Date beginStartDate, Date finishStartDate);
        
    public List<DqTransmissionLog> getErrorsByMostRecentFirstForEventType(String eventType, Date beginStartDate, Date finishStartDate, String batchId, String hostname, boolean isMostRecentOnly);
    
    public DqTransmissionLog findDqTransmissionLog(Long id);
   
    public List<DqTransmissionLog> findAll();
    
    public List<DqTransmissionLog> findByDqTransmissionId(Long dqTransmissionId);
    
    public List<DqTransmissionLog> findByBatchId(String batchId);

    public List<DqTransmissionLog> findByFilename(String filename);

    public List<DqTransmissionLog> findByLocalDocId(String localDocId);

    public List<DqTransmissionLog> findByRemoteDocId(String remoteDocId);  
    
    public List<DqTransmissionLog> findByVarious(String eventType, Date beginStartDate, Date finishStartDate, Date beginEndDate, Date finishEndDate, String batchId, String hostname, String localDocId, String filename, String destination, String status, String remoteDocId); 
    
}
