/*
 * Queries the DqTransmissionLog DAO to get statistics, and 
 * creates the report contents of the daily status email.
 *
 */
package gov.va.med.nhin.adapter.dataquality.reporting;


import gov.va.med.nhin.adapter.dataquality.transmissionlog.DqTransmissionLog;
import gov.va.med.nhin.adapter.dataquality.transmissionlog.DqTransmissionLogManager;
import gov.va.med.nhin.adapter.dataquality.transmissionlog.DqTransmissionLogManagerLocal;

import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "TransmissionReport", mappedName = "TransmissionReport")
public class TransmissionReportBean implements TransmissionReportLocal {
    
    private static final Logger LOG = LoggerFactory.getLogger(TransmissionReportBean.class.getName());  
    
    private static final String NEWLINE = "\r\n    ";
    //private static final String NEWLINE = "<br>    ";
    private static final String TABCHAR = "    ";
    //private static final String TABCHAR = "&nbsp;&nbsp;&nbsp;&nbsp;";
    
    private DqTransmissionLogManager dqlm;
        
    @EJB(beanInterface = DqTransmissionLogManagerLocal.class, beanName = "DqTransmissionLogManager")
    public void setDqlm(DqTransmissionLogManager dqlm) {
        this.dqlm = dqlm;
    }

    
    /**
     * Create the report text for the given date range with statistics retrieved
     * from the DQ_Transmission_Log database table.
     * 
     * @param beginLogStartDate - uses date, hour, and minute, and so seconds and 
     * milliseconds ignored, as these values are reset in the DAO class queries.
     * @param finishLogStartDate - uses date, hour, and minute, and so seconds and 
     * milliseconds ignored, as these values are reset in the DAO class queries.
     * @return 
     */
    @Override
    public String generateReportText(final Date beginLogStartDate, final Date finishLogStartDate, 
            final Date auditStartDate, final Date auditEndDate,
            final boolean performDH, final boolean performDQ) {                
        
        // get unique status
        //List<String> listStatusValues = dqlm.getUniqueStatus(beginLogStartDate, finishLogStartDate);
        // get unique destinations    
        //List<String> listDestinationValues = dqlm.getUniqueDestinations(beginLogStartDate, finishLogStartDate);
        // get unique hostnames
        //List<String> listHostnameValues = dqlm.getUniqueHostnames(beginLogStartDate, finishLogStartDate);               
        
        //public int getCountByStartDateHourMinuteRange(Date beginLogStartDate, Date finishLogStartDate, String status, String hostname, String destination); 
        // findByStartDateRange(Date beginStartDate, Date finishStartDate, String dhStatus, String zipFileLoadStatus, String zipFileSendStatus, String hostname, String destination);
        //int totalAttempted = dqlm.getCountByStartDateRange(beginLogStartDate, finishLogStartDate, null, null, null, null, null, true);        
        
        // Totals Per DH Status
        // total: successes + failures 
        // failures: count in startDate range with status1 entry = "Failed to send file to Diameter Health"
        //int dhUploadFailures = dqlm.getCountByStartDateRange(beginLogStartDate, finishLogStartDate, "failure", null, null, null, null, false);
        int dhUploadFailures = dqlm.getDHUploadEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "failure");
        //int dhUploadFailuresNative = dqlm.getUniqueFilenameStatusCountNative(DqTransmissionLogManager.DHUPLOAD_EVENTTYPE, beginLogStartDate, finishLogStartDate, "failure");
        // successes: count in startDate range with status1 entry = "Successfully sent file to Diameter Health" 
        int dhUploadSuccesses = dqlm.getDHUploadEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "success"); 
        //int dhUploadSuccessesNative = dqlm.getUniqueFilenameStatusCountNative(DqTransmissionLogManager.DHUPLOAD_EVENTTYPE, beginLogStartDate, finishLogStartDate, "success");
        int dhUploadTotal = dhUploadFailures + dhUploadSuccesses;
        //int dhUploadTotal2 = dqlm.getUniqueFilenameEventCount(DqTransmissionLogManager.DHUPLOAD_EVENTTYPE, beginLogStartDate, finishLogStartDate, null, null, null);
        
        // Totals Per DQ Server .zip File Load Status
        //total: failures1 + failures2 + successes
        //failures because of DH failures: count in startDate range with status2 entry = "Process failed before storing health data file in zip file"
        //failures in Data Quality zip file archive step: count in startDate range with status2 entry = "Failed to store health data file in zip file on eHX Adapter server"
        //successes in Data Quality zip file archive step: count in startDate range with status2 entry = "Successfully stored health data file in zip file on eHX Adapter server"
        //int dqZipFileStoreDhCausedFailures = dhUploadFailures;
        //int dqZipFileStoreFailures = dqlm.getCountByStartDateRange(beginLogStartDate, finishLogStartDate, null, "failure", null, null, null, false);
        //int dqZipFileStoreFailures = dqlm.getDHUploadEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "failure");
        int dqZipFileStoreFailures = dqlm.getDQZipStoreEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "failure");
        //int dqZipFileStoreFailuresNative = dqlm.getUniqueFilenameStatusCountNative(DqTransmissionLogManager.DQZIPSTORE_EVENTTYPE, beginLogStartDate, finishLogStartDate, "failure");
        //int dqZipFileStoreSuccesses = dqlm.getCountByStartDateRange(beginLogStartDate, finishLogStartDate, null, "success", null, null, null, false);
        int dqZipFileStoreSuccesses = dqlm.getDQZipStoreEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "success"); 
        //int dqZipFileStoreSuccessesNative = dqlm.getUniqueFilenameStatusCountNative(DqTransmissionLogManager.DQZIPSTORE_EVENTTYPE, beginLogStartDate, finishLogStartDate, "success");
        //int dqZipFileStoreTotal = dqZipFileStoreFailures + dqZipFileStoreSuccesses;
        //int dqZipFileStoreTotal2 = dqlm.getUniqueFilenameEventCount(DqTransmissionLogManager.DQZIPSTORE_EVENTTYPE, beginLogStartDate, finishLogStartDate, null, null, null);
        
        // Totals Per DQ Server .zip File Send Status
        //total: successes + failures
        //send failures: count in startDate range with status3 entry = "Failed to send zip file to Data Quality server"
        //send successes: count in startDate range with status3 entry = "Successfully sent zip file to Data Quality server"
        //int dqZipFileSentFailures = dqlm.getCountByStartDateRange(beginLogStartDate, finishLogStartDate, null, null, "failure", null, null, false);
        int dqZipFileSentFailures = dqlm.getDQZipSendEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "failure");
        int dqZipFileSentSuccesses = dqlm.getDQZipSendEventCount(beginLogStartDate, finishLogStartDate, null, null, null, null, "success");
        int dqZipFileSentTotal = dqZipFileSentFailures + dqZipFileSentSuccesses;
        //int dqZipFileSentTotal2 = dqlm.getUniqueFilenameEventCount(DqTransmissionLogManager.DQZIPMOVE_EVENTTYPE, beginLogStartDate, finishLogStartDate, null, null, null);
        
        // Most recent Stored DH file send error text stored in current batch date range:
        List<DqTransmissionLog> dqTransLogRecentDhErrorList = dqlm.getErrorsByMostRecentFirstForEventType(DqTransmissionLogManager.DHUPLOAD_EVENTTYPE, beginLogStartDate, finishLogStartDate, null, null, true);

        LOG.debug(String.format("dqZipFileStoreSuccesses = %d; dqZipFileStoreFailures=%d ", dqZipFileStoreSuccesses, dqZipFileStoreFailures));
        // Most recent Stored .zip file file load error text stored in current batch date range:
 //       List<String> dqTransLogRecentDqZipFileStoreErrorList = dqlm.getErrorsByMostRecentFirstForEventType(DqTransmissionLogManager.DQZIPSTORE_EVENTTYPE, beginLogStartDate, finishLogStartDate, null, null, true);

        // Most recent Stored .zip file send error text stored in current batch date range:
//        List<String> dqTransLogRecentDqZipFileSendErrorList = dqlm.getErrorsByMostRecentFirstForEventType(DqTransmissionLogManager.DQZIPMOVE_EVENTTYPE, beginLogStartDate, finishLogStartDate, null, null, true);
        
//        Map<String,Integer> aggregateStatusCountValues = new HashMap<>();
//        for (String statusValue : listStatusValues) {            
//            int currentCount = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, statusValue, null, null);
//            aggregateStatusCountValues.put(statusValue, new Integer(currentCount));
//	}
//                
//        // get per destination statistics for each value: total count of all combined status, count for each status               
//        Map<String, Map<String, Integer>> perDestinationAndStatusCountValues = new HashMap<String, Map<String, Integer>>();        
//        for (String destinationValue : listDestinationValues) { 
//            Map<String, Integer> innerMap = new HashMap<String, Integer>();
//            int totalPerDestinationAttempted = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, null, null, destinationValue);            
//            innerMap.put("total", totalPerDestinationAttempted);
//            for (String statusValue : listStatusValues) {
//                int currentCount1 = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, statusValue, null, destinationValue);                
//                innerMap.put(statusValue, new Integer(currentCount1));
//            }
//            perDestinationAndStatusCountValues.put(destinationValue, innerMap);            
//        }
//        
//        // get per hostname statistics for each value: total count of all combined status, count for each status        
//        Map<String, Map<String, Integer>> perHostnameAndStatusCountValues = new HashMap<String, Map<String, Integer>>();
//        for (String hostnameValue : listHostnameValues) { 
//            Map<String, Integer> innerMap2 = new HashMap<String, Integer>();
//            int totalPerHostnameAttempted = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, null, hostnameValue, null);            
//            innerMap2.put("total", totalPerHostnameAttempted);
//            for (String statusValue : listStatusValues) {
//                int currentCount2 = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, statusValue, hostnameValue, null);                
//                innerMap2.put(statusValue, currentCount2);
//            }
//            perHostnameAndStatusCountValues.put(hostnameValue, innerMap2);            
//        }
//        
//        // get per hostname and destination statistics for each value: total count of all combined status, count for each status        
//        Map<String, Map<String, Map<String, Integer>>> perHostnameAndDestinationAndStatusCountValues = new HashMap<String, Map<String, Map<String, Integer>>>();
//        for (String hostnameValue : listHostnameValues) { 
//            Map<String, Map<String, Integer>> innerMap3 = new HashMap<String, Map<String, Integer>>();
//            Map<String, Integer> innerMap4 = new HashMap<String, Integer>();
//            for (String destinationValue : listDestinationValues) {
//                int totalPerHostnamePerDestinationAttempted = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, null, hostnameValue, destinationValue);            
//                innerMap4.put("total", totalPerHostnamePerDestinationAttempted);                
//                for (String statusValue : listStatusValues) {
//                    int currentCount3 = dqlm.getCountByStartDateHourMinuteRange(beginLogStartDate, finishLogStartDate, statusValue, hostnameValue, destinationValue);                
//                    innerMap4.put(statusValue, currentCount3);
//                }
//                innerMap3.put(destinationValue, innerMap4);                  
//            }
//            perHostnameAndDestinationAndStatusCountValues.put(hostnameValue, innerMap3);
//        }
        
        // later?: get filenames for failure status per destination, hostname - cap the output at a certain limit of size
        
        
        // generate report in a StringBuilder with formatting characters, esp. newline
        StringBuilder sb = new StringBuilder();
        
        sb.append(NEWLINE);          
        sb.append("Data Quality File Upload Summary: ");
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        
        sb.append("Batch Upload Report Start Time: ");
        sb.append(beginLogStartDate);
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("Batch Upload Report End Time: ");
        sb.append(finishLogStartDate);
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        
        sb.append("Audited Documents Start Time: ");
        sb.append(auditStartDate);
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("Audited Documents End Time: ");
        sb.append(auditEndDate);
        sb.append(NEWLINE);
        sb.append(NEWLINE);        
        
//        sb.append("Total # Data Files Downloaded From eHX Adapter: ");
//        sb.append(totalAttempted);
//        sb.append(NEWLINE);
//        sb.append(NEWLINE);
        if (performDH) {
            sb.append("Totals for Health Data Files Uploaded To Diameter Health: ");
            sb.append(NEWLINE);      
            sb.append(TABCHAR);
            sb.append("# Failures For Send: ");
            sb.append(dhUploadFailures);
            sb.append(NEWLINE);
            sb.append(TABCHAR);
    //        sb.append("# Failures For Send Native: ");
            //sb.append(dhUploadFailuresNative);
    //        sb.append(NEWLINE);
    //        sb.append(TABCHAR);        
            sb.append("# Successes For Send: ");
            sb.append(dhUploadSuccesses);
            sb.append(NEWLINE);  
            sb.append(TABCHAR);
     //       sb.append("# Successes For Send Native: ");
            //sb.append(dhUploadSuccessesNative);
    //        sb.append(NEWLINE);  
    //        sb.append(TABCHAR);        
            sb.append("# Total Attempts For Send: ");
            sb.append(dhUploadTotal);
            sb.append(NEWLINE);          
            sb.append(NEWLINE);
    //        sb.append("# Total Attempts For Send 2: ");
    //        sb.append(dhUploadTotal2);
    //        sb.append(NEWLINE);          
    //        sb.append(NEWLINE);        

    //        sb.append("Totals for Health Data Files Stored In A .zip File On An eHX Adapter Server: ");
    //        sb.append(NEWLINE);   
    //        sb.append(TABCHAR);
    ////        sb.append("# Failures Caused By Diameter Health Send Failure: ");
    ////        sb.append(dqZipFileStoreDhCausedFailures); 
    ////        sb.append(NEWLINE);   
    ////        sb.append(TABCHAR);
    //        sb.append("# Failures For Store Into .zip: ");
    //        sb.append(dqZipFileStoreFailures);
    //        sb.append(NEWLINE);
    //        sb.append(TABCHAR);
    ////        sb.append("# Failures For Store Into .zip Native: ");
    ////        //sb.append(dqZipFileStoreFailuresNative);
    ////        sb.append(NEWLINE);
    ////        sb.append(TABCHAR);        
    //        sb.append("# Successes For Store Into .zip: ");
    //        sb.append(dqZipFileStoreSuccesses);
    //        sb.append(NEWLINE); 
    //        sb.append(TABCHAR);
    ////        sb.append("# Successes For Store Into .zip Native: ");
    ////        sb.append(dqZipFileStoreSuccessesNative);
    ////        sb.append(NEWLINE); 
    ////        sb.append(TABCHAR);        
    //        sb.append("# Total Attempts For Store: ");
    //        sb.append(dqZipFileStoreTotal);
    //        sb.append(NEWLINE);          
    //        sb.append(NEWLINE);
    //        sb.append("# Total Attempts For Store 2: ");
    //        sb.append(dqZipFileStoreTotal2);
    //        sb.append(NEWLINE);          
    //        sb.append(NEWLINE);
        } else {
            sb.append("Diameter Health uploads are not currently enabled");
            sb.append(NEWLINE);          
            sb.append(NEWLINE);
        }
        
        if (performDQ) {
            sb.append("Totals For zip Files Sent To A Data Quality Share: ");
            sb.append(NEWLINE);        
            sb.append(TABCHAR);
            sb.append("# Failures For Send: ");
            sb.append(dqZipFileSentFailures);
            sb.append(NEWLINE);
            sb.append(TABCHAR);
            sb.append("# Successes For Send: ");
            sb.append(dqZipFileSentSuccesses);
            sb.append(NEWLINE); 
            sb.append(TABCHAR);
            sb.append("# Total Attempts For Send: ");
            sb.append(dqZipFileSentTotal);
            sb.append(NEWLINE);           
            sb.append(NEWLINE); 
//          sb.append("# Total Attempts For Send 2: ");
//          sb.append(dqZipFileSentTotal2);
//          sb.append(NEWLINE);           
//          sb.append(NEWLINE); 
        } else {
            sb.append("Data Quality share zip files are not currently enabled");
            sb.append(NEWLINE);          
            sb.append(NEWLINE);
        }

      
        sb.append("Most recent error information logged in this report date range for a failed Diameter Health data file upload: ");
        sb.append(NEWLINE);    
        sb.append(TABCHAR);
        int dhErrorNum = dqTransLogRecentDhErrorList.size();
        if(dhErrorNum > 0) { 
            DqTransmissionLog dqTransLogRecentDhError = dqTransLogRecentDhErrorList.get(0);
            //  startTime, cdafilename, hostname, errorException text
            sb.append("Start Time: ");
            sb.append(dqTransLogRecentDhError.getStartTime());
            sb.append(NEWLINE);
            sb.append(TABCHAR);
            sb.append("End Time: ");
            sb.append(dqTransLogRecentDhError.getStartTime());
            sb.append(NEWLINE);
            sb.append(TABCHAR);            
            sb.append("Filename: ");
            sb.append(dqTransLogRecentDhError.getFilename());
            sb.append(NEWLINE);   
            sb.append(TABCHAR);
            sb.append("VA Hostname: ");
            sb.append(dqTransLogRecentDhError.getHostname());
            sb.append(NEWLINE); 
            sb.append(TABCHAR);
            sb.append("Error: ");
            sb.append(NEWLINE);  
            sb.append(TABCHAR);
            sb.append(dqTransLogRecentDhError.getError());
            sb.append(NEWLINE); 
        } else {
            sb.append("No Results");
        }
        sb.append(NEWLINE);        

/*          
        sb.append("Most recent error logged in this date range for a failed health data file storage into a zip file on an eHX Adapter server: ");
        sb.append(NEWLINE);  
        sb.append(TABCHAR);        
        int dqZipStoreErrorNum = dqTransLogRecentDqZipFileStoreErrorList.size();
        if(dqZipStoreErrorNum > 0) { 
            DqTransmissionLog dqTransLogRecentDqZipFileStoreError = dqTransLogRecentDqZipFileStoreErrorList.get(0);
            //  startTime, cdafilename, hostname, errorException text
            sb.append("Start Time: ");
            sb.append(dqTransLogRecentDqZipFileStoreError.getStartTime());
            sb.append(NEWLINE);
            sb.append(TABCHAR);
            sb.append("Health Data Filename: ");
            sb.append(dqTransLogRecentDqZipFileStoreError.getFilename1());
            sb.append(NEWLINE); 
            sb.append(TABCHAR);
            sb.append("VA Hostname: ");
            sb.append(dqTransLogRecentDqZipFileStoreError.getHostname());
            sb.append(NEWLINE); 
            sb.append(TABCHAR);
            sb.append("Exception: ");
            sb.append(NEWLINE); 
            sb.append(TABCHAR);            
            sb.append(dqTransLogRecentDqZipFileStoreError.getExceptionText());
            sb.append(NEWLINE); 
        } else {
            sb.append("No Results");
        }
        sb.append(NEWLINE);        
        
        sb.append("Most recent error logged in this date range for a failed attempt to send a zip file to a Data Quality server: ");
        sb.append(NEWLINE);  
        sb.append(TABCHAR);
        int dqZipSendErrorNum = dqTransLogRecentDqZipFileSendErrorList.size();
        if(dqZipSendErrorNum > 0) { 
            DqTransmissionLog dqTransLogRecentDqZipFileSendError = dqTransLogRecentDqZipFileSendErrorList.get(0);
            //  startTime, zipfilename, hostname, errorException text
            sb.append("Start Time: ");            
            sb.append(dqTransLogRecentDqZipFileSendError.getStartTime());
            sb.append(NEWLINE);
            sb.append(TABCHAR);
            sb.append(".zip Filename: ");
            sb.append(dqTransLogRecentDqZipFileSendError.getFilename1());
            sb.append(NEWLINE);  
            sb.append(TABCHAR);
            sb.append("VA Hostname: ");
            sb.append(dqTransLogRecentDqZipFileSendError.getHostname());
            sb.append(NEWLINE); 
            sb.append(TABCHAR);
            sb.append("Exception: ");
            sb.append(NEWLINE);  
            sb.append(TABCHAR);
            sb.append(dqTransLogRecentDqZipFileSendError.getExceptionText());
            sb.append(NEWLINE); 
        } else {
            sb.append("No Results");
        }
        sb.append(NEWLINE);  
*/        
        // return the report
        return sb.toString();
    } 
    
}
