/**
 * 
 *
 */
package gov.va.med.nhin.adapter.dataquality.common;

/**
 *
 * 
 */
public class RestClientException extends Exception {

    private static final long serialVersionUID = 1234567890L;  

    private int statusCode;
    
    private String httpResponse;
    
    public RestClientException() {
    }

    public RestClientException(String message) {
        super(message);
    }

    public RestClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public RestClientException(Throwable cause) {
        super(cause);
    }   

    public RestClientException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public RestClientException(int statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public RestClientException(int statusCode, Throwable cause) {
        super(cause);
        this.statusCode = statusCode;
    } 
    
    public RestClientException(int statusCode, String httpResponse, String message) {
        super(message);
        this.statusCode = statusCode;
        this.httpResponse = httpResponse;
    }

    public RestClientException(int statusCode, String httpResponse, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.httpResponse = httpResponse;
    }
    
    /**
     * Get the value of statusCode
     *
     * @return the value of statusCode
     */
    public int getStatusCode() {
        return statusCode;
    }

    /**
     * Set the value of statusCode
     *
     * @param statusCode new value of statusCode
     */
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }    
    
    /**
     * Get the value of httpResponse
     *
     * @return the value of httpResponse
     */
    public String getHttpResponse() {
        return httpResponse;
    }

    /**
     * Set the value of httpResponse
     *
     * @param httpResponse new value of httpResponse
     */
    public void setHttpResponse(String httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public String toString() {
        return super.toString() + " statusCode: " + statusCode + " httpResponse: " + httpResponse;
    }
    
}
