package gov.va.med.nhin.adapter.dataquality.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Loads email.properties file as properties once since it 
 * functions as a singleton class bean, and called with getInstance().
 * 
 */
public class EmailBean {
    
    private static final Logger LOG = LoggerFactory.getLogger(EmailBean.class.getName());
    
	private String subject;
	private String body;
	private String from;
        private String toList;
	private String host;
	private String username;
	private String password;
	private String port;
	private String link;
	private static EmailBean emailBean;
	
	
	private EmailBean(){
		Properties props = new Properties();
		String fileName = "email.properties";
		/*
                InputStream inputStream = null;
		try {
			inputStream = getClass().getClassLoader().getResourceAsStream(fileName);
			props.load(inputStream);
		} catch (IOException e) {
			//e.printStackTrace();
                        LOG.error("EmailBean property file loading exception: ",e);
		}finally {
            if (inputStream != null) {
            	try {
                	inputStream.close();
        		} catch (IOException ex) {        			
        			//e.printStackTrace();
                                LOG.error("EmailBean property loading stream close exception: ",ex);
        		}

            }
        }
                */
                
                ClassLoader cL = getClass().getClassLoader();
                if (cL == null) return;
                try (InputStream inputStream = cL.getResourceAsStream(fileName)){
                    props.load(inputStream);
		} catch (IOException e) {
                    LOG.error("EmailBean property file loading exception: ",e);
		}
                
		setSubject(props.getProperty("email.subject"));
		setBody(props.getProperty("email.body"));
		setFrom(props.getProperty("email.from"));
                setToList(props.getProperty("email.toList"));
		setHost(props.getProperty("email.host"));
		setUsername(props.getProperty("email.username"));
		setPassword(props.getProperty("email.password"));
		setPort(props.getProperty("email.port"));
		setLink(props.getProperty("email.link"));
	}
	
	public static synchronized EmailBean  getInstance(){		
		if ( emailBean == null ){
			emailBean = new EmailBean();
		}
		return emailBean;
	}
	
	
	public String getSubject() {
		return subject;
	}

	private void setSubject(String subject) {
		this.subject = subject;
	}

	public String getBody() {
		return body;
	}

	private void setBody(String body) {
		this.body = body;
	}

	public String getFrom() {
		return from;
	}
	
	private void setFrom(String from) {
		this.from = from;
	}
	
	public String getHost() {
		return host;
	}
	private void setHost(String host) {
		this.host = host;
	}
	public String getUsername() {
		return username;
	}
	private void setUsername(String username) {
		this.username = username;
	}
	public String getPassword() {
		return password;
	}
	private void setPassword(String password) {
		this.password = password;
	}
	public String getPort() {
		return port;
	}
	private void setPort(String port) {
		this.port = port;
	}
	public String getLink() {
		return link;
	}
	private void setLink(String link) {
		this.link = link;
	}
        public String getToList() {
            return toList;
        }
        private void setToList(String toList) {
            this.toList = toList;
        }
	
}
