package gov.va.med.nhin.adapter.sensitiveInfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayQueryRequestType;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.datamanager.internalApp.InternalAppFilter;
import gov.va.med.nhin.adapter.datamanager.internalApp.InternalAppFilterObj;
import gov.va.med.nhin.adapter.internalApp.InternalAppManager;
import gov.va.med.nhin.adapter.logging.CheckPolicy;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.med.nhin.adapter.utils.NullChecker;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueListType;

@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "SensitiveInfoBean", mappedName = "SensitiveInfoBean")
public class SensitiveInfoBean implements SensitiveInfoManagerLocal, SensitiveInfoManagerRemote
{

	private static final Logger logger = LoggerFactory.getLogger(SensitiveInfoBean.class);

	static private final String SENSITIVE_FILTER_FACILITY_NAME = "SENSITIVE_INFO_FACILITY";
	static private final String FILTER_SENSITIVE_DATA = "FILTER_SENSITIVE_DATA";
	static private final String FILTER_SENSITIVE_OBLIGATION = "FILTER_SENSITIVE_OBLIGATION";

	private EntityManager entityManager;
	private InternalAppManager internalAppManager;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = InternalAppManager.class, beanName = "InternalAppManager")
	public void setInternalAppManager(InternalAppManager internalAppManager)
	{
		this.internalAppManager = internalAppManager;
	}

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	@PersistenceContext
	public void setEntityManager(EntityManager entityManager)
	{
		this.entityManager = entityManager;
	}

	public boolean isFilteringRequired(SmartHashMap map)
	{
		boolean retValue = false;
		String filterSensitiveData = propertyLookup.getProperty(FILTER_SENSITIVE_DATA);
		
		if(filterSensitiveData == null || !filterSensitiveData.equalsIgnoreCase("true"))
		{
			logger.debug("sensitive data filtering not enabled in the properties table");
			return false;
		}
		
		List<String> filterLocations = entityManager.createNamedQuery("SensitiveInfo.listUniqueLocations").getResultList();

		logger.debug("filterLocations {}:", filterLocations); // CCR 177986

		for(String location : filterLocations)
		{
			//logger.trace("checking in hashmap location {}:", location);
			logger.trace("checking in hashmap location {}:");
			if(location.contains("."))
			{
				int index = location.indexOf(".");
				String sectionName = location.substring(0, index);
				String subName = location.substring(index + 1);
				// logger.trace("sectionName {}  and subName {}", sectionName, subName);
				logger.trace("sectionName {}  and subName {}");
				if(!map.containsKey(sectionName))
				{
					continue;
				}
				Object sectionValueObj = map.get(sectionName);
				if(sectionValueObj instanceof List)
				{
					List<SmartHashMap> sectionValueList = (List<SmartHashMap>) sectionValueObj;
					List<String> subSectionValueList = new ArrayList<String>();
					for(SmartHashMap sectionValue : sectionValueList)
					{
						if(!sectionValue.containsKey(subName))
						{
							continue;
						}
						String subSectionValue = (String) sectionValue.get(subName);
						subSectionValueList.add(subSectionValue);
					}
					if(subSectionValueList.size() > 0)
					{
						// logger.trace("checking database for location {} and num of values {} ", location, subSectionValueList.size());
						logger.trace("checking database for location {} and num of values {} ");
						if(isSectionFilteringRequired(location, subSectionValueList))
						{
							return true;
						}
					}
				}
				else if(sectionValueObj instanceof SmartHashMap)
				{
					SmartHashMap sectionValueObjMap = (SmartHashMap) sectionValueObj;
					String value = (String) sectionValueObjMap.get(subName);
					if(value != null && value.length() > 0)
					{
						List subSectionValueList = new ArrayList();
						subSectionValueList.add(value);
						if(isSectionFilteringRequired(location, subSectionValueList))
						{
							return true;
						}
					}
				}
			}
		}

		return retValue;
	}

	private boolean isSectionFilteringRequired(String location, List subSectionValueList)
	{

		boolean retValue = false;
		Object countObj = entityManager.createNamedQuery("SensitiveInfo.getCountForSensitiveSections").setParameter("location", location).setParameter("valueList", subSectionValueList).getSingleResult();
		// long count = objects.size();

		long count = 0;

		if(countObj instanceof Long)
		{
			count = ((Long) countObj).longValue();
			logger.trace("long count {}:", count); // CCR 177986
		}
		if(countObj instanceof Integer)
		{
			count = ((Integer) countObj).longValue();
			logger.trace("int count {}:", count);
		}

		if(count > 0)
		{
			retValue = true;
		}

		return retValue;
	}

	@Override
	public SmartHashMap filterSensitiveData(SmartHashMap map)
	{
		boolean sensitiveDataRemoved = false;
		if(map != null && map.keySet() != null && map.keySet().size() > 0)
		{
			Iterator<String> iterator = map.keySet().iterator();

			while(iterator.hasNext())
			{
				String section = iterator.next();
				logger.trace("processing section {}:", section);

				List<SensitiveInfo> sensitiveInfoList = entityManager.createNamedQuery("SensitiveInfo.getSensitiveInfosBySection").setParameter("section", section + "%").getResultList();
				for(SensitiveInfo sensitiveInfo : sensitiveInfoList)
				{
					String location = sensitiveInfo.getLocation();
					int index = location.indexOf(".");
					// String sectionName = location.substring(0, index);
					if(index <= 0)
					{
						// logger.warn("location: {} is not configured correctly as per the requirements. It should be configured as 'section.subsection", location);
						logger.warn("location: {} is not configured correctly as per the requirements. It should be configured as 'section.subsection");
						continue;
					}
					String subName = location.substring(index + 1);
					if(subName.indexOf(".") >= 0)
					{
						// logger.warn("location: {} is not configured correctly as per the requirements. It should be configured as 'section.subsection", location);
						logger.warn("location: {} is not configured correctly as per the requirements. It should be configured as 'section.subsection");
						continue;
					}
					Object sectionValueObj = map.get(section);
					if(sectionValueObj instanceof List)
					{
						List<SmartHashMap> sectionValueList = (List<SmartHashMap>) sectionValueObj;
						List<SmartHashMap> objectToBeRemovedList = new ArrayList<SmartHashMap>();
						for(SmartHashMap sectionValue : sectionValueList)
						{
							if(!sectionValue.containsKey(subName))
							{
								continue;
							}

							if(sectionValue.get(subName) instanceof String)
							{
								String subSectionValue = (String) sectionValue.get(subName);
//								logger.trace("checking section {} and subName {} and subSectionValue {} and sentisitiveValue {}", new Object[] { section, subName, subSectionValue, sensitiveInfo.getSensitiveValue() }); // CCR
																																																							// 177986

								if(NullChecker.isNotNullOrEmpty(subSectionValue) && subSectionValue.equalsIgnoreCase(sensitiveInfo.getSensitiveValue()))
								{
									// remove the object from the list
									// logger.trace("section {} and subName {} and subSectionValue {} ", new Object[] { section, subName, subSectionValue });
									// logger.trace("removing subSection {} and subName {} ", subName, subSectionValue);
									logger.trace("section {} and subName {} and subSectionValue {} ");
									logger.trace("removing subSection {} and subName {} ");

									objectToBeRemovedList.add(sectionValue);
									sensitiveDataRemoved = true;
								}
							}
							else
							{
								// logger.warn("location: {} sub section is not String data tyoe so can not be compared.", location);
								logger.warn("location: {} sub section is not String data tyoe so can not be compared.");
							}
						}

						if(objectToBeRemovedList.size() >= sectionValueList.size())
						{
							logger.trace("removing section {}:", section);
							iterator.remove();
						}
						else
						{
							for(SmartHashMap sectionValue : objectToBeRemovedList)
							{
								// logger.trace("removing subSection: {} and object : {} ", subName, sectionValue);
								logger.trace("removing subSection: {} and object : {} ");
								sectionValueList.remove(sectionValue);
							}
						}
					}
					else if(sectionValueObj instanceof SmartHashMap)
					{
						// String location = sensitiveInfo.getLocation();
						SmartHashMap smMap = (SmartHashMap) sectionValueObj;
						String subSectionValue = (String) smMap.get(subName);
						if(subSectionValue.equalsIgnoreCase(sensitiveInfo.getSensitiveValue()))
						{
							// remove the object from the list
							logger.trace("removing section {}:", section);
							iterator.remove();
							sensitiveDataRemoved = true;
						}
					}
				}
			}
		}

		//logger.trace("map size after applying sensitive data filtering {}:" + map.size());
		logger.trace("map size after applying sensitive data filtering {}:" + (map!=null?map.size():"null"));
                

		if(sensitiveDataRemoved)
		{
			Map<String, List<InternalAppFilterObj>> filterMap = internalAppManager.generateFiltersByNumber(SENSITIVE_FILTER_FACILITY_NAME);

			InternalAppFilter appFilter = new InternalAppFilter();
			if(!map.isEmpty())
			{
				logger.trace("additional data filter size {}:", filterMap.size());
				appFilter.filterObjects(filterMap, map);
			}
			logger.trace("map size after applying additional filtering:" + map);
		}

		return map;
	}

	@Override
	public void checkPolicyAndAddSlot(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest, CheckPolicyResponseType checkPolicyResponse)
	{
		String filterSensitiveData = propertyLookup.getProperty(FILTER_SENSITIVE_DATA);
		if(filterSensitiveData != null && filterSensitiveData.equalsIgnoreCase("true"))
		{
			if(CheckPolicy.checkObligation(checkPolicyResponse, propertyLookup.getProperty(FILTER_SENSITIVE_OBLIGATION)))
			{
				if(respondingGatewayCrossGatewayQueryRequest != null && respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest() != null && respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest().getAdhocQuery() != null && respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest().getAdhocQuery().getSlot() != null)
				{
					respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest().getAdhocQuery().getSlot().add(createSensitiveSlot());
				}
			}
		}
	}

	private SlotType1 createSensitiveSlot()
	{
		SlotType1 ret = new SlotType1();
		ret.setName("FILTER_SENSITIVE");
		ret.setValueList(createSensitiveValue());

		return ret;
	}

	private ValueListType createSensitiveValue()
	{
		ValueListType ret = new ValueListType();

		ret.getValue().add("true");

		return ret;
	}

}
