package gov.va.med.nhin.adapter.propertylookup;

import java.io.*;
import java.util.*;

import javax.annotation.*;
import javax.ejb.*;

import org.slf4j.*;

import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Singleton(name = "PropertyFileLookup", mappedName = "PropertyFileLookup")
public class PropertyFileLookupBean implements PropertyLookupLocal, PropertyLookupRemote
{
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileLookupBean.class.getName());
    
    Properties properties;
    
    @PostConstruct
    public void init()
    {
        InputStream in = null;
        Properties p;
        
        try {
            p = new Properties();
            in = Utils.getResourceAsStream("adapter.properties");
            p.load(in);
        }
        catch (IOException ioe) {
            logger.warn("Error loading adapter.properties.  Returning null.", ioe);
            p = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Error closing input stream.", ioe);
            }
        }
        
        properties = p;
    }
    
    @Override
    public String getProperty(String key)
    {
        String ret = null;

        if (properties != null) {
            ret = properties.getProperty(key);
        }
        
        return ret;
    }
}
