package gov.va.med.nhin.adapter.logging;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.AdapterProvideAndRegisterDocumentSetRequestType;
import gov.va.med.nhin.adapter.utils.NullChecker;

import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectListType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotListType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XDRError
{
	private static final Logger logger = LoggerFactory.getLogger(XDRError.class.getName());

	public static void queryError(final AdapterProvideAndRegisterDocumentSetRequestType respondingGatewayType, final String errorText)
	{
		if(respondingGatewayType != null)
		{
			ProvideAndRegisterDocumentSetRequestType adhocQuery = respondingGatewayType.getProvideAndRegisterDocumentSetRequest() != null ? respondingGatewayType.getProvideAndRegisterDocumentSetRequest() : null;
			AssertionType assertionType = respondingGatewayType.getAssertion() != null ? respondingGatewayType.getAssertion() : null;
			queryError(adhocQuery, assertionType, errorText);
		}
	}

	public static void queryError(final AdapterProvideAndRegisterDocumentSetRequestType respondingGatewayType, final ErrorMessage errorText)
	{
		queryError(respondingGatewayType, errorText.getMessage());
	}

	public static void queryError(final AdapterProvideAndRegisterDocumentSetRequestType respondingGatewayType, final ErrorMessage errorText, final String additionalInfo)
	{
		queryError(respondingGatewayType, errorText.getMessage() + ": " + additionalInfo);
	}

	public static String requestTypeError(final ProvideAndRegisterDocumentSetRequestType queryType)
	{
		StringBuilder sb = new StringBuilder();
		if(queryType != null)
		{
			SubmitObjectsRequest request = queryType.getSubmitObjectsRequest();
			RegistryObjectListType regObjects = request.getRegistryObjectList();
			SlotListType slots = request.getRequestSlotList();
			Map<String, List<String>> slotMap = getMapFromSlots(slots.getSlot());
                        logger.info(String.format("RegistryObjectListType=%d; slotMap size = %s", 
                                regObjects != null &&regObjects.getIdentifiable() !=null ? regObjects.getIdentifiable().size():0,
                                slotMap!=null? String.valueOf(slotMap.size()):"null"));
                        
		}
		else
		{
			sb.append("All Document Query parameters are missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static String assertionError(final AssertionType assertionType)
	{
		StringBuilder sb = new StringBuilder();
		if(assertionType != null)
		{
			String hcid = assertionType.getHomeCommunity() != null && StringUtils.isNotBlank(assertionType.getHomeCommunity().getHomeCommunityId()) ? assertionType.getHomeCommunity().getHomeCommunityId() : "Missing";
			sb.append("\tAssertion HCID: ").append(hcid).append("\n");
		}
		else
		{
			sb.append("Document Query Assertion is missing.\n");
		}
		if(sb.length() > 0)
		{
			return sb.toString();
		}

		return StringUtils.EMPTY;
	}

	public static void queryError(final ProvideAndRegisterDocumentSetRequestType queryType, AssertionType assertionType, final String errorText)
	{
		StringBuilder sb = new StringBuilder();

		sb.append(LoggingUtils.ERROR_PREFIX).append(" ").append(errorText).append("\n");
		sb.append(requestTypeError(queryType));
		sb.append(assertionError(assertionType));

		// CCR 177986- logging updates
		logger.trace("error string {} ", sb);
	}

	private static Map<String, List<String>> getMapFromSlots(List<SlotType1> slots)
	{
		HashMap<String, List<String>> ret = new HashMap<String, List<String>>();

		for(SlotType1 slot : slots)
		{
			if(NullChecker.isNotNullOrEmpty(slot.getName()) && NullChecker.isNotNullOrEmpty(slot.getValueList()) && NullChecker.isNotNullOrEmpty(slot.getValueList().getValue()))
			{
				List<String> values = ret.get(slot.getName());
				if(values == null)
				{
					values = new ArrayList<String>();
					ret.put(slot.getName(), values);
				}
				values.addAll(slot.getValueList().getValue());
			}
		}

		return ret;
	}
}
