package gov.va.med.nhin.adapter.facilitymanager;

import java.io.Serializable;
import java.util.Collection;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

import gov.va.med.nhin.adapter.audit.Audit;

/**
 *
 * @author David Vazquez
 */
@Entity
@Cache(
		  type = CacheType.SOFT, // Cache everything until the JVM decides memory is low.
		  size = 64000,  // Use 64,000 as the initial cache size.
		  expiry = 360000,  // 6 minutes
		  coordinationType = CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS  // if cache coordination is used, only send invalidation messages.
		)
@Table(name = "FACILITIES")
@NamedQueries({
    @NamedQuery(name = "Facility.findAll", query = "SELECT f FROM Facility f"),
    @NamedQuery(name = "Facility.findByFacilityId", query = "SELECT f FROM Facility f WHERE f.facilityId = :facilityId"),
    @NamedQuery(name = "Facility.findByFacilityNumber", query = "SELECT f FROM Facility f WHERE f.facilityNumber = :facilityNumber"),
    @NamedQuery(name = "Facility.findByHomeCommunityId", query = "SELECT f FROM Facility f WHERE f.homeCommunityId = :homeCommunityId"),
    @NamedQuery(name = "Facility.findByFullHomeCommunityId", query = "SELECT f FROM Facility f WHERE f.fullHomeCommunityId = :fullHomeCommunityId"),
    @NamedQuery(name = "Facility.findByFacilityName", query = "SELECT f FROM Facility f WHERE f.facilityName = :facilityName")
})
public class Facility implements Serializable
{
	private static final long serialVersionUID = 1L;

	public static final String SPEC_VERSION_2010 = "2.0";
	public static final String SPEC_VERSION_2011 = "3.0";

	@Id
	@Basic(optional = false)
	@Column(name = "FACILITY_ID")
	private Long facilityId;
	@Basic(optional = false)
	@Column(name = "FACILITY_NUMBER")
	private String facilityNumber;
	@Basic(optional = false)
	@Column(name = "HOME_COMMUNITY_ID")
	private String homeCommunityId;
	@Basic(optional = false)
	@Column(name = "FACILITY_NAME")
	private String facilityName;
	@Basic(optional = false)
	@Column(name = "FULL_HOME_COMMUNITY_ID")
	private String fullHomeCommunityId;
	@Basic(optional = false)
	@Column(name = "ACP_CHECK")
	private String acpCheck;

	@Basic(optional = false)
	@Column(name = "USE_SPEC_VERSION")
	private String useSpecVersion;

	// Added by Armand --> to handle Partner operations
	@OneToOne(fetch = FetchType.LAZY)
	@PrimaryKeyJoinColumn
	private Operations operations;

	@OneToMany(cascade = CascadeType.ALL, mappedBy = "facility", fetch = FetchType.EAGER)
	private Collection<FacilityToAA> facilitiesToAAs;
	@OneToMany(cascade = CascadeType.ALL, mappedBy = "organization")
	private Collection<Audit> organizationAudits;
	@OneToMany(cascade = CascadeType.ALL, mappedBy = "remoteOrganization")
	private Collection<Audit> remoteOrganizationAudits;

	public Facility()
	{
	}

	public Facility(Long facilityId)
	{
		this.facilityId = facilityId;
	}

	public Facility(Long facilityId, String facilityNumber, String homeCommunityId, String facilityName)
	{
		this.facilityId = facilityId;
		this.facilityNumber = facilityNumber;
		this.homeCommunityId = homeCommunityId;
		this.facilityName = facilityName;
	}

	public Long getFacilityId()
	{
		return facilityId;
	}

	public void setFacilityId(Long facilityId)
	{
		this.facilityId = facilityId;
	}

	public String getFacilityNumber()
	{
		return facilityNumber;
	}

	public void setFacilityNumber(String facilityNumber)
	{
		this.facilityNumber = facilityNumber;
	}

	public String getHomeCommunityId()
	{
		return homeCommunityId;
	}

	public void setHomeCommunityId(String homeCommunityId)
	{
		this.homeCommunityId = homeCommunityId;
	}

	public String getFacilityName()
	{
		return facilityName;
	}

	public void setFacilityName(String facilityName)
	{
		this.facilityName = facilityName;
	}

	public String getFullHomeCommunityId()
	{
		return fullHomeCommunityId;
	}

	public void setFullHomeCommunityId(String fullHomeCommunityId)
	{
		this.fullHomeCommunityId = fullHomeCommunityId;
	}

	public String getAcpCheck()
	{
		return acpCheck;
	}

	public void setAcpCheck(String acpCheck)
	{
		this.acpCheck = acpCheck;
	}

	public String getUseSpecVersion()
	{
		return this.useSpecVersion;
	}

	public void setUseSpecVersion(String useSpecVersion)
	{
		this.useSpecVersion = useSpecVersion;
	}

	public Collection<FacilityToAA> getFacilitiesToAAs()
	{
		return facilitiesToAAs;
	}

	public void setFacilitiesToAAs(Collection<FacilityToAA> facilitiesToAAs)
	{
		this.facilitiesToAAs = facilitiesToAAs;
	}

	public Collection<Audit> getOrganizationAudits()
	{
		return organizationAudits;
	}

	public void setOrganizationAudits(Collection<Audit> organizationAudits)
	{
		this.organizationAudits = organizationAudits;
	}

	public Collection<Audit> getRemoteOrganizationAudits()
	{
		return remoteOrganizationAudits;
	}

	public void setRemoteOrganizationAudits(Collection<Audit> remoteOrganizationAudits)
	{
		this.remoteOrganizationAudits = remoteOrganizationAudits;
	}

	public Operations getOperations()
	{
		return operations;
	}

	public void setOperations(Operations operations)
	{
		this.operations = operations;
	}

	@Override
	public int hashCode()
	{
		int hash = 0;
		hash += (facilityId != null ? facilityId.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object object)
	{
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if(!(object instanceof Facility))
		{
			return false;
		}
		Facility other = (Facility) object;
		if((this.facilityId == null && other.facilityId != null) || (this.facilityId != null && !this.facilityId.equals(other.facilityId)))
		{
			return false;
		}
		return true;
	}

	@Override
	public String toString()
	{
		return "gov.va.med.nhin.adapter.permission.data.Facility[facilityId=" + facilityId + "]";
	}
}
