package gov.va.med.nhin.adapter.documentrepository;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import gov.va.med.nhin.adapter.audit.Audit;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "DOCUMENTS")
@NamedQueries({
    @NamedQuery(name = "Document.findAll", query = "select d from Document d"),
    @NamedQuery(name = "Document.findByDocumentId", query = "select d from Document d where d.documentId=:documentId"),
    @NamedQuery(name = "Document.findByDocumentUniqueId", query = "select d from Document d where d.documentUniqueId=:documentUniqueId")
})
@SequenceGenerator(name = "documentIdGenerator", sequenceName = "DOCUMENT_ID_SEQ", allocationSize = 1)
public class Document implements Serializable
{
	private static final long serialVersionUID = 1L;
	
	@Id
    @Basic(optional = false)
    @Column(name = "DOCUMENT_ID")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "documentIdGenerator")
    private Long documentId;
    @Basic(optional = true)
    @Column(name = "DOCUMENT_UNIQUE_ID")
    private String documentUniqueId;
    @Basic(optional = true)
    @Column(name = "CLASS_CODE")
    private String classCode;
    @Basic(optional = true)
    @Column(name = "CLASS_CODE_SCHEME")
    private String classCodeScheme;
    @Basic(optional = true)
    @Column(name = "CLASS_CODE_DISPLAY_NAME")
    private String classCodeDisplayName;
    @Basic(optional = true)
    @Column(name = "PATIENT_ID")
    private String patientId;
    @Basic(optional = true)
    @Column(name = "PATIENT_SSN")
    private String patientSSN;
    @Basic(optional = true)
    @Column(name = "PATIENT_LAST_NAME")
    private String patientLastName;
    @Basic(optional = true)
    @Column(name = "PATIENT_GIVEN_NAME")
    private String patientGivenName;
    @Basic(optional = true)
    @Column(name = "PATIENT_PREF_FACILITY_NUMBER")
    private String patientPreferredFacilityNumber;
    @Basic(optional = true)
    @Column(name = "PATIENT_PREF_FACILITY_NAME")
    private String patientPreferredFacilityName;
    @Basic(optional = true)
    @Column(name = "TITLE")
    private String title;
    @Basic(optional = true)
    @Column(name = "CREATION_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date creationTime;
    @Basic(optional = true)
    @Column(name = "BEGIN_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date beginDate;
    @Basic(optional = true)
    @Column(name = "END_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date endDate;
    @Basic(optional = true)
    @Column(name = "MIME_TYPE")
    private String mimeType;
    @Basic(optional = true, fetch = FetchType.EAGER)
    @Lob
    @Column(name = "RAW_DATA")
    private byte[] rawData;
    @Basic(optional = true)
    @Column(name = "RAW_DATA_SIZE")
    private Integer size;
    @Basic(optional = true)
    @Column(name = "RAW_DATA_HASH")
    private String hash;
    @Basic(optional = true)
    @Column(name = "LAST_ACCESSED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date lastAccessedTime;
    @Basic(optional = true)
    @Column(name = "DOC_GEN_QUERY_NAME")
    private String docGenQueryName;
    @Basic(optional = true)
    @Column(name = "DOC_GEN_QUERY_PARAMS")
    private String docGenQueryParams;
    @Basic(optional = true)
    @Column(name = "FORMAT_CODE")
    private String formatCode;
    @Basic(optional = true)
    @Column(name = "FORMAT_CODE_SCHEME")
    private String formatCodeScheme;
    @Basic(optional = true)
    @Column(name = "FORMAT_CODE_DISPLAY_NAME")
    private String formatCodeDisplayName;
    @Basic(optional = true)
    @Column(name = "AVAILABILITY_STATUS")
    private String availabilityStatus;
    @Basic(optional = true)
    @Column(name = "SOURCE_PATIENT_ID")
    private String sourcePatientId;
    @Basic(optional = true)
    @Column(name = "TYPE_CODE")
    private String typeCode;
    @Basic(optional = true)
    @Column(name = "TYPE_CODE_SCHEME")
    private String typeCodeScheme;
    @Basic(optional = true)
    @Column(name = "TYPE_CODE_DISPLAY_NAME")
    private String typeCodeDisplayName;
    // The following fields are not persisted.
    @Transient
    private String authorPerson;
    @Transient
    private String practiceSettingCode;
    @Transient
    private String practiceSettingCodeScheme;
    @Transient
    private String practiceSettingCodeDisplayName;
    @Transient
    private String healthCareFacilityTypeCode;
    @Transient
    private String healthCareFacilityTypeCodeScheme;
    @Transient
    private String healthCareFacilityTypeCodeDisplayName;
    @Transient
    private String confidentialityCode;
    @Transient
    private String confidentialityCodeScheme;
    @Transient
    private String confidentialityCodeDisplayName;
    @Transient
    private String languageCode;
    @OneToMany(mappedBy = "document")
    private Collection<Audit> audits;
    
    public Document()
    {
    }

    public String getClassCodeDisplayName()
    {
        return classCodeDisplayName;
    }

    public void setClassCodeDisplayName(String classCodeDisplayName)
    {
        this.classCodeDisplayName = classCodeDisplayName;
    }

    public String getMimeType()
    {
        return mimeType;
    }

    public void setMimeType(String mimeType)
    {
        this.mimeType = mimeType;
    }

    public Date getCreationTime()
    {
        return creationTime;
    }

    public void setCreationTime(Date creationTime)
    {
        this.creationTime = creationTime;
    }

    public String getPatientId()
    {
        return patientId;
    }

    public void setPatientId(String patientId)
    {
        this.patientId = patientId;
    }

    public String getPatientSSN()
    {
        return patientSSN;
    }

    public void setPatientSSN(String patientSSN)
    {
        this.patientSSN = patientSSN;
    }

    public String getPatientGivenName()
    {
        return patientGivenName;
    }

    public void setPatientGivenName(String patientGivenName)
    {
        this.patientGivenName = patientGivenName;
    }

    public String getPatientLastName()
    {
        return patientLastName;
    }

    public void setPatientLastName(String patientLastName)
    {
        this.patientLastName = patientLastName;
    }

    public String getPatientPreferredFacilityName()
    {
        return patientPreferredFacilityName;
    }

    public void setPatientPreferredFacilityName(String patientPreferredFacilityName)
    {
        this.patientPreferredFacilityName = patientPreferredFacilityName;
    }

    public String getPatientPreferredFacilityNumber()
    {
        return patientPreferredFacilityNumber;
    }

    public void setPatientPreferredFacilityNumber(String patientPreferredFacilityNumber)
    {
        this.patientPreferredFacilityNumber = patientPreferredFacilityNumber;
    }

    public String getDocumentUniqueId()
    {
        return documentUniqueId;
    }

    public void setDocumentUniqueId(String documentUniqueId)
    {
        this.documentUniqueId = documentUniqueId;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public Date getBeginDate()
    {
        return beginDate;
    }

    public void setBeginDate(Date beginDate)
    {
        this.beginDate = beginDate;
    }

    public String getClassCode()
    {
        return classCode;
    }

    public void setClassCode(String classCode)
    {
        this.classCode = classCode;
    }

    public String getClassCodeScheme()
    {
        return classCodeScheme;
    }

    public void setClassCodeScheme(String classCodeScheme)
    {
        this.classCodeScheme = classCodeScheme;
    }

    public Long getDocumentId()
    {
        return documentId;
    }

    public void setDocumentId(Long documentId)
    {
        this.documentId = documentId;
    }

    public Date getEndDate()
    {
        return endDate;
    }

    public void setEndDate(Date endDate)
    {
        this.endDate = endDate;
    }

    public String getHash()
    {
        return hash;
    }

    public void setHash(String hash)
    {
        this.hash = hash;
    }

    public byte[] getRawData()
    {
        return rawData;
    }

    public void setRawData(byte[] rawData)
    {
        this.rawData = rawData;
    }

    public Integer getSize()
    {
        return size;
    }

    public void setSize(Integer size)
    {
        this.size = size;
    }

    public Date getLastAccessedTime()
    {
        return lastAccessedTime;
    }

    public void setLastAccessedTime(Date lastAccessedTime)
    {
        this.lastAccessedTime = lastAccessedTime;
    }

    @Override
    public int hashCode()
    {
        int ret = 0;
        ret += (documentId != null ? documentId.hashCode() : 0);
        return ret;
    }

    public String getDocGenQueryName()
    {
        return docGenQueryName;
    }

    public void setDocGenQueryName(String docGenQueryName)
    {
        this.docGenQueryName = docGenQueryName;
    }

    public String getDocGenQueryParams()
    {
        return docGenQueryParams;
    }

    public void setDocGenQueryParams(String docGenQueryParams)
    {
        this.docGenQueryParams = docGenQueryParams;
    }

    public String getAvailabilityStatus()
    {
        return availabilityStatus;
    }

    public void setAvailabilityStatus(String availabilityStatus)
    {
        this.availabilityStatus = availabilityStatus;
    }

    public String getFormatCode()
    {
        return formatCode;
    }

    public void setFormatCode(String formatCode)
    {
        this.formatCode = formatCode;
    }

    public String getFormatCodeDisplayName()
    {
        return formatCodeDisplayName;
    }

    public void setFormatCodeDisplayName(String formatCodeDisplayName)
    {
        this.formatCodeDisplayName = formatCodeDisplayName;
    }

    public String getFormatCodeScheme()
    {
        return formatCodeScheme;
    }

    public void setFormatCodeScheme(String formatCodeScheme)
    {
        this.formatCodeScheme = formatCodeScheme;
    }

    public String getTypeCode()
    {
        return typeCode;
    }

    public void setTypeCode(String typeCode)
    {
        this.typeCode = typeCode;
    }

    public String getTypeCodeDisplayName()
    {
        return typeCodeDisplayName;
    }

    public void setTypeCodeDisplayName(String typeCodeDisplayName)
    {
        this.typeCodeDisplayName = typeCodeDisplayName;
    }

    public String getTypeCodeScheme()
    {
        return typeCodeScheme;
    }

    public void setTypeCodeScheme(String typeCodeScheme)
    {
        this.typeCodeScheme = typeCodeScheme;
    }

    public String getSourcePatientId()
    {
        return sourcePatientId;
    }

    public void setSourcePatientId(String sourcePatientId)
    {
        this.sourcePatientId = sourcePatientId;
    }

    public String getAuthorPerson()
    {
        return authorPerson;
    }

    public void setAuthorPerson(String authorPerson)
    {
        this.authorPerson = authorPerson;
    }

    public String getConfidentialityCode()
    {
        return confidentialityCode;
    }

    public void setConfidentialityCode(String confidentialityCode)
    {
        this.confidentialityCode = confidentialityCode;
    }

    public String getConfidentialityCodeDisplayName()
    {
        return confidentialityCodeDisplayName;
    }

    public void setConfidentialityCodeDisplayName(String confidentialityCodeDisplayName)
    {
        this.confidentialityCodeDisplayName = confidentialityCodeDisplayName;
    }

    public String getConfidentialityCodeScheme()
    {
        return confidentialityCodeScheme;
    }

    public void setConfidentialityCodeScheme(String confidentialityCodeScheme)
    {
        this.confidentialityCodeScheme = confidentialityCodeScheme;
    }

    public String getHealthCareFacilityTypeCode()
    {
        return healthCareFacilityTypeCode;
    }

    public void setHealthCareFacilityTypeCode(String healthCareFacilityTypeCode)
    {
        this.healthCareFacilityTypeCode = healthCareFacilityTypeCode;
    }

    public String getHealthCareFacilityTypeCodeDisplayName()
    {
        return healthCareFacilityTypeCodeDisplayName;
    }

    public void setHealthCareFacilityTypeCodeDisplayName(String healthCareFacilityTypeCodeDisplayName)
    {
        this.healthCareFacilityTypeCodeDisplayName = healthCareFacilityTypeCodeDisplayName;
    }

    public String getHealthCareFacilityTypeCodeScheme()
    {
        return healthCareFacilityTypeCodeScheme;
    }

    public void setHealthCareFacilityTypeCodeScheme(String healthCareFacilityTypeCodeScheme)
    {
        this.healthCareFacilityTypeCodeScheme = healthCareFacilityTypeCodeScheme;
    }

    public String getLanguageCode()
    {
        return languageCode;
    }

    public void setLanguageCode(String languageCode)
    {
        this.languageCode = languageCode;
    }

    public String getPracticeSettingCode()
    {
        return practiceSettingCode;
    }

    public void setPracticeSettingCode(String practiceSettingCode)
    {
        this.practiceSettingCode = practiceSettingCode;
    }

    public String getPracticeSettingCodeDisplayName()
    {
        return practiceSettingCodeDisplayName;
    }

    public void setPracticeSettingCodeDisplayName(String practiceSettingCodeDisplayName)
    {
        this.practiceSettingCodeDisplayName = practiceSettingCodeDisplayName;
    }

    public String getPracticeSettingCodeScheme()
    {
        return practiceSettingCodeScheme;
    }

    public void setPracticeSettingCodeScheme(String practiceSettingCodeScheme)
    {
        this.practiceSettingCodeScheme = practiceSettingCodeScheme;
    }

    public Collection<Audit> getAudits()
    {
        return audits;
    }

    public void setAudits(Collection<Audit> audits)
    {
        this.audits = audits;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (!(obj instanceof Document)) {
            return false;
        }
        Document doc = (Document)obj;
        if (this != doc && (documentId == null || doc.documentId == null || !documentId.equals(doc.documentId))) {
            return false;
        }
        return true;
    }
}
