package gov.va.med.nhin.adapter.datamanager.ejb;

import javax.ejb.EJB;
import javax.ejb.*;

import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataManagerFactory;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

/**
 *
 * @author PII
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "DataManager")
public class DataManagerBean implements DataManagerLocal
{
    private DataManager dataManager;
    private PropertyLookup propertyLookup;

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @Override
    public DataQuery getQuery(String queryName)
    {
        return getQuery(queryName, null);
    }

    @Override
    public DataQuery getQuery(String queryName, DataQuery parentQuery)
    {
        return getQuery(queryName, parentQuery, null);
    }

    @Override
    public DataQuery getQuery(String queryName, DataQuery parentQuery, String paramPrefix)
    {
        if (dataManager == null) {
            dataManager = DataManagerFactory.getDataManager("DM-Common", propertyLookup.getProperty("dataManagerConfigFilename"));
        }

        return dataManager.getQuery(queryName, parentQuery, paramPrefix);
    }
}
