package gov.va.med.nhin.adapter.audit.requests;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlRootElement;


/**
* Entity is used for placing and extracting request audit records.
*  
* @author ChmaraC
*/
@Entity
@Table(name = "REQUEST_LOG")
@XmlRootElement
@NamedQueries({
	@NamedQuery(name = "RequestAudit.findAll", query = "SELECT f FROM RequestAuditEntity f")})

public class RequestAuditEntity implements Serializable {
	private static final long serialVersionUID = -9030131616900890181L;
    @Id
    @Basic(optional = false)
    @Column(name = "ID")
    private Long requestId;
    
    @Basic(optional = true)
    @Column(name = "HCID")
    private String hcid;
    
    @Basic(optional = true)
    @Column(name = "PID")
    private String pid;

    @Basic(optional = false)
    @Column(name = "START_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date startTime;   
    
    @Basic(optional = false)
    @Column(name = "STOP_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date stopTime;   

    @Basic(optional = true)
    @Column(name = "UUID")
    private String uuid;

    @Basic(optional = true)
    @Column(name = "ACTION")
    private String action;

    @Basic(optional = true)
    @Column(name = "STATUS")
    private String status;
    
    @Basic(optional = true)
    @Column(name = "UNAME")
    private String uName;
    

	/**
	 * @return the requestId
	 */
	public Long getRequestId() {
		return requestId;
	}

	/**
	 * @param requestId the requestId to set
	 */
	public void setRequestId(Long requestId) {
		this.requestId = requestId;
	}

	/**
	 * @return the hcid
	 */
	public String getHcid() {
		return hcid;
	}

	/**
	 * @param hcid the hcid to set
	 */
	public void setHcid(String hcid) {
		this.hcid = hcid;
	}

	/**
	 * @return the pid
	 */
	public String getPid() {
		return pid;
	}

	/**
	 * @param pid the pid to set
	 */
	public void setPid(String pid) {
		this.pid = pid;
	}

	/**
	 * @return the startTime
	 */
	public Date getStartTime() {
		return startTime;
	}

	/**
	 * @param startTime the startTime to set
	 */
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	/**
	 * @return the stopTime
	 */
	public Date getStopTime() {
		return stopTime;
	}

	/**
	 * @param stopTime the stopTime to set
	 */
	public void setStopTime(Date stopTime) {
		this.stopTime = stopTime;
	}

	/**
	 * @return the uuid
	 */
	public String getUuid() {
		return uuid;
	}

	/**
	 * @param uuid the uuid to set
	 */
	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	/**
	 * @return the action
	 */
	public String getAction() {
		return action;
	}

	/**
	 * @param action the action to set
	 */
	public void setAction(String action) {
		if(action != null && action.length() > 254){
			this.action = action.substring(0, 254);
		}else{
			this.action = action;
		}
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		if(status != null && status.length() > 254){
			this.status = status.substring(0, 254);
		}else{
			this.status = status;
		}
	}
	
	/**
	 * generate and store a random UUID.
	 */
	public String generateUUID(){
		setUuid(UUID.randomUUID().toString());
		return getUuid();
	}

	/**
	 * @return the uName
	 */
	public String getuName() {
		return uName;
	}

	/**
	 * @param uName the uName to set
	 */
	public void setuName(String uName) {
		this.uName = uName;
	}
}
