package gov.va.med.nhin.adapter.audit;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.facilitymanager.Facility;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "AUDITS")
@NamedQueries({
    @NamedQuery(name = "Audit.findAll", query = "SELECT a FROM Audit a"),
    @NamedQuery(name = "Audit.findBySystemId", query = "SELECT a FROM Audit a WHERE a.systemId=:systemId")
})
@SequenceGenerator(name = "auditIdGenerator", sequenceName = "AUDIT_ID_SEQ", allocationSize = 1)
public class Audit implements Serializable
{
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "AUDIT_ID")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "auditIdGenerator")
    private Long auditId;
    
    @Basic(optional = false)
    @Column(name = "AUDIT_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date auditTime;
    
    @Basic(optional = false)
    @Column(name = "ACTION_NAME")
    private String action;
    
    @Basic(optional = true)
    @Column(name = "USER_ID")
    private String userId;
    
    @Basic(optional = true)
    @Column(name = "SYSTEM_ID")
    private String systemId;
    
    @Basic(optional = true)
    @Column(name = "USER_NAME")
    private String userName;
    
    @Basic(optional = true)
    @Column(name = "USER_FACILITY_NUMBER")
    private String userFacilityNumber;
    
    @Basic(optional = true)
    @Column(name = "USER_FACILITY_NAME")
    private String userFacilityName;
    
    @Basic(optional = true)
    @Column(name = "USER_ROLE")
    private String userRole;
    
    @ManyToOne(optional = true)
    @JoinColumn(name = "USER_ROLE", referencedColumnName = "USER_ROLE", insertable = false, updatable = false)
    private Occupation occupation;
    
    @Basic(optional = true)
    @Column(name = "ORGANIZATION_ID")
    private String organizationId;
    
    @Basic(optional = true)
    @Column(name = "PATIENT_ID")
    private String patientId;
    
    @Basic(optional = true)
    @Column(name = "PATIENT_SSN")
    private String patientSSN;
    
    @Basic(optional = true)
    @Column(name = "PATIENT_LAST_NAME")
    private String patientLastName;
    
    @Basic(optional = true)
    @Column(name = "PATIENT_GIVEN_NAME")
    private String patientGivenName;    
    
    @Basic(optional = true)
    @Column(name = "PATIENT_MIDDLE_NAME")
    private String patientMiddleName;
    
    @Basic(optional = true)
    @Column(name = "PATIENT_FACILITY_NUMBER")
    private String patientFacilityNumber;    
    
    @Basic(optional = true)
    @Column(name = "MOTHER_MAIDEN_NAME")    
    private String mothersMaidenName; 
    
    @Basic(optional = true)
    @Column(name = "POB_CITY")
    private String pobCity;        
    
    @Basic(optional = true)
    @Column(name = "POB_STATE")
    private String pobState;
    
    @Basic(optional = true)
    @Column(name = "PATIENT_FACILITY_NAME")
    private String patientFacilityName;
    
    @Basic(optional = true)
    @Column(name = "PURPOSE_FOR_USE")
    private String purposeForUse;
    
    @Basic(optional = true)
    @Column(name = "DOCUMENT_ID")
    private String documentId;
    
    @ManyToOne(optional = true)
    @JoinColumn(name = "DOCUMENT_ID", referencedColumnName = "DOCUMENT_UNIQUE_ID", insertable = false, updatable = false)
    private Document document;
    
    @Basic(optional = true)
    @Column(name = "REMOTE_ORGANIZATION_ID")
    private String remoteOrganizationId;
    
    @Basic(optional = true)
    @Column(name = "REMOTE_DOC_REPOSITORY_ID")
    private String remoteDocumentRepositoryId;
    
    @Basic(optional = true)
    @Column(name = "REMOTE_DOC_ID")
    private String remoteDocumentId;
    
    @Basic(optional = true)
    @Column(name = "DETAILS")
    private String details;
    
    @Basic(optional = true)
    @Column(name = "OPTOUT_REASON_ID")
    private Long optoutReasonId;
    
    @ManyToOne(optional = true)
    @JoinColumn(name = "OPTOUT_REASON_ID", referencedColumnName = "OPTOUT_REASON_ID", insertable = false, updatable = false)
    private OptoutReason optoutReason;
    
    @ManyToOne(optional = true)
    @JoinColumn(name = "ORGANIZATION_ID", referencedColumnName = "FULL_HOME_COMMUNITY_ID", insertable = false, updatable = false)
    private Facility organization;
    
    @ManyToOne(optional = true)
    @JoinColumn(name = "REMOTE_ORGANIZATION_ID", referencedColumnName = "FULL_HOME_COMMUNITY_ID", insertable = false, updatable = false)
    private Facility remoteOrganization;
    
    @Basic(optional = true)
    @Column(name = "DOC_SPEC_TYPE")
    private String docSpecType;
    
    
    @Basic(optional = true)
    @Column(name = "PATIENT_SSN_EX", insertable = false, updatable = false)
    private String patientSsnEx;

    @Basic(optional = true)
    @Column(name = "MATCH_FOUND", insertable = false, updatable = false)
    private String matchFound;

    @Basic(optional = true)
    @Column(name = "MATCH_FAILED", insertable = false, updatable = false)
    private String matchFailed;

    @Basic(optional = true)
    @Column(name = "IS_TEST_PATIENT", insertable = false, updatable = false)
    private String isTestPatient;

    @Basic(optional = true)
    @Column(name = "HIE_TRANSACTION_ID")
    private String hieTransactionId;

    public Audit()
    {
    }

    public Audit(Long auditId)
    {
        this.auditId = auditId;
    }

    public Audit(Long auditId, String action, String userId, String organizationId, Date auditTime)
    {
        this.auditId = auditId;
        this.action = action;
        this.userId = userId;
        this.organizationId = organizationId;
        this.auditTime = auditTime;
    }

    public Long getAuditId()
    {
        return auditId;
    }

    public void setAuditId(Long auditId)
    {
        this.auditId = auditId;
    }

    public String getAction()
    {
        return action;
    }

    public void setAction(String action)
    {
        this.action = action;
    }

    public String getUserId()
    {
        return userId;
    }

    public void setUserId(String userId)
    {
        this.userId = userId;
    }
    
    public String getSystemId()
    {
        return systemId;
    }

    public void setSystemId(String systemId)
    {
        this.systemId = systemId;
    }

    public String getUserName()
    {
        return userName;
    }

    public void setUserName(String userName)
    {
        this.userName = userName;
    }

    public String getUserFacilityName()
    {
        return userFacilityName;
    }

    public void setUserFacilityName(String userFacilityName)
    {
        this.userFacilityName = userFacilityName;
    }

    public String getUserFacilityNumber()
    {
        return userFacilityNumber;
    }

    public void setUserFacilityNumber(String userFacilityNumber)
    {
        this.userFacilityNumber = userFacilityNumber;
    }

    public String getUserRole()
    {
        return userRole;
    }

    public void setUserRole(String userRole)
    {
        this.userRole = userRole;
    }

    public Occupation getOccupation() {
        return occupation;
    }

    public void setOccupation(Occupation occupation) {
        this.occupation = occupation;
    }

    public String getOrganizationId()
    {
        return organizationId;
    }

    public void setOrganizationId(String organizationId)
    {
        this.organizationId = organizationId;
    }

    public String getPatientId()
    {
        return patientId;
    }

    public void setPatientId(String patientId)
    {
        this.patientId = patientId;
    }

    public String getPurposeForUse()
    {
        return purposeForUse;
    }

    public void setPurposeForUse(String purposeForUse)
    {
        this.purposeForUse = purposeForUse;
    }

    public Document getDocument()
    {
        return document;
    }

    public void setDocument(Document document)
    {
        this.document = document;
    }

    public Date getAuditTime()
    {
        return auditTime;
    }

    public void setAuditTime(Date auditTime)
    {
        this.auditTime = auditTime;
    }

    public String getRemoteDocumentId()
    {
        return remoteDocumentId;
    }

    public void setRemoteDocumentId(String remoteDocumentId)
    {
        this.remoteDocumentId = remoteDocumentId;
    }

    public String getRemoteDocumentRepositoryId()
    {
        return remoteDocumentRepositoryId;
    }

    public void setRemoteDocumentRepositoryId(String remoteDocumentRepositoryId)
    {
        this.remoteDocumentRepositoryId = remoteDocumentRepositoryId;
    }

    public String getRemoteOrganizationId()
    {
        return remoteOrganizationId;
    }

    public void setRemoteOrganizationId(String remoteOrganizationId)
    {
        this.remoteOrganizationId = remoteOrganizationId;
    }

    public String getDetails()
    {
        return details;
    }

    public void setDetails(String details)
    {
        this.details = details;
    }

    public OptoutReason getOptoutReason()
    {
        return optoutReason;
    }

    public void setOptoutReason(OptoutReason optoutReason)
    {
        this.optoutReason = optoutReason;
    }

    public String getPatientFacilityNumber()
    {
        return patientFacilityNumber;
    }

    public void setPatientFacilityNumber(String patientFacilityNumber)
    {
        this.patientFacilityNumber = patientFacilityNumber;
    }

    public String getPatientFacilityName()
    {
        return patientFacilityName;
    }

    public void setPatientFacilityName(String patientFacilityName)
    {
        this.patientFacilityName = patientFacilityName;
    }

    public String getPatientGivenName()
    {
        return patientGivenName;
    }

    public void setPatientGivenName(String patientGivenName)
    {
        this.patientGivenName = patientGivenName;
    }

    public String getPatientLastName()
    {
        return patientLastName;
    }

    public void setPatientLastName(String patientLastName)
    {
        this.patientLastName = patientLastName;
    }

    public String getPatientMiddleName() {
        return patientMiddleName;
    }

    public void setPatientMiddleName(String patientMiddleName) {
        this.patientMiddleName = patientMiddleName;
    }
    
    public String getMothersMaidenName() {
        return mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }
    
    public String getPatientSSN()
    {
        return patientSSN;
    }

    public void setPatientSSN(String patientSSN)
    {
        this.patientSSN = patientSSN;
    }

    public String getPobCity() {
        return pobCity;
    }

    public void setPobCity(String pobCity) {
        this.pobCity = pobCity;
    }

    public String getPobState() {
        return pobState;
    }

    public void setPobState(String pobState) {
        this.pobState = pobState;
    }
    
    public Facility getOrganization()
    {
        return organization;
    }

    public void setOrganization(Facility organization)
    {
        this.organization = organization;
    }

    public Facility getRemoteOrganization()
    {
        return remoteOrganization;
    }

    public void setRemoteOrganization(Facility remoteOrganization)
    {
        this.remoteOrganization = remoteOrganization;
    }

    public String getDocumentId()
    {
        return documentId;
    }

    public void setDocumentId(String documentId)
    {
        this.documentId = documentId;
    }

    public Long getOptoutReasonId()
    {
        return optoutReasonId;
    }

    public void setOptoutReasonId(Long optoutReasonId)
    {
        this.optoutReasonId = optoutReasonId;
    }
    
    

    public String getDocSpecType() {
		return docSpecType;
	}

	public void setDocSpecType(String docSpecType) {
		this.docSpecType = docSpecType;
	}

    public String getPatientSsnEx()
    {
        return patientSsnEx;
    }

    public void setPatientSsnEx(String patientSsnEx)
    {
        this.patientSsnEx = patientSsnEx;
    }

    public String getMatchFound()
    {
        return matchFound;
    }

    public void setMatchFound(String matchFound)
    {
        this.matchFound = matchFound;
    }

    public String getMatchFailed()
    {
        return matchFailed;
    }

    public void setMatchFailed(String matchFailed)
    {
        this.matchFailed = matchFailed;
    }

    public String geIsTestPatient()
    {
        return isTestPatient;
    }

    public void setIsTestPatient(String isTestPatient)
    {
        this.isTestPatient = isTestPatient;
    }

    public String getHieTransactionId()
    {
        return hieTransactionId;
    }

    public void setHieTransactionId(String hieTransactionId)
    {
        this.hieTransactionId = hieTransactionId;
    }

	@Override
    public int hashCode()
    {
        return new HashCodeBuilder(17, 37)
                .appendSuper(super.hashCode())
                .append(this.getAction())
                .append(this.getAuditId())
                .append(this.getAuditTime())
                .append(this.getDetails())
                .append(this.getDocument())
                .append(this.getDocumentId())
                .append(this.getOptoutReason())
                .append(this.getOptoutReasonId())
                .append(this.getOrganization())
                .append(this.getOrganizationId())
                .append(this.getPatientFacilityName())
                .append(this.getPatientFacilityNumber())
                .append(this.getPatientGivenName())
                .append(this.getPatientId())
                .append(this.getPatientLastName())
                .append(this.getPatientSSN())
                .append(this.getPurposeForUse())
                .append(this.getRemoteDocumentId())
                .append(this.getRemoteDocumentRepositoryId())
                .append(this.getRemoteOrganization())
                .append(this.getRemoteOrganizationId())
                .append(this.getUserFacilityName())
                .append(this.getUserFacilityNumber())
                .append(this.getUserId())
                .append(this.getSystemId())
                .append(this.getUserName())
                .append(this.getUserRole()).toHashCode();
    }

    @Override
    public boolean equals(Object object)
    {
        if (object == null) {
            return false;
        }

        if (object == this) {
            return true;
        }

        if (getClass() != object.getClass()) {
            return false;
        }

        Audit right = (Audit)object;
        return new EqualsBuilder()
                .append(this.getAction(), right.getAction())
                .append(this.getAuditId(), right.getAuditId())
                .append(this.getAuditTime(), right.getAuditTime())
                .append(this.getDetails(), right.getDetails())
                .append(this.getDocument(), right.getDocument())
                .append(this.getDocumentId(), right.getDocumentId())
                .append(this.getOptoutReason(), right.getOptoutReason())
                .append(this.getOptoutReasonId(), right.getOptoutReasonId())
                .append(this.getOrganization(), right.getOrganization())
                .append(this.getOrganizationId(), right.getOrganizationId())
                .append(this.getPatientFacilityName(), right.getPatientFacilityName())
                .append(this.getPatientFacilityNumber(), right.getPatientFacilityNumber())
                .append(this.getPatientGivenName(), right.getPatientGivenName())
                .append(this.getPatientId(), right.getPatientId())
                .append(this.getPatientLastName(), right.getPatientLastName())
                .append(this.getPatientSSN(), right.getPatientSSN())
                .append(this.getPurposeForUse(), right.getPurposeForUse())
                .append(this.getRemoteDocumentId(), right.getRemoteDocumentId())
                .append(this.getRemoteDocumentRepositoryId(), right.getRemoteDocumentRepositoryId())
                .append(this.getRemoteOrganization(), right.getRemoteOrganization())
                .append(this.getRemoteOrganizationId(), right.getRemoteOrganizationId())
                .append(this.getUserFacilityName(), right.getUserFacilityName())
                .append(this.getUserFacilityNumber(), right.getUserFacilityNumber())
                .append(this.getUserId(), right.getUserId())
                .append(this.getSystemId(), right.getSystemId())
                .append(this.getUserName(), right.getUserName())
                .append(this.getUserRole(), right.getUserRole()).isEquals();
    }

    @Override
    public String toString()
    {
        return new ToStringBuilder(this)
                .append("action", this.getAction())
                .append("auditId", this.getAuditId())
                .append("auditTime", this.getAuditTime())
                .append("details", this.getDetails())
                .append("document", this.getDocument())
                .append("documentId", this.getDocumentId())
                .append("optoutReason", this.getOptoutReason())
                .append("optoutReasonId", this.getOptoutReasonId())
                .append("organization", this.getOrganization())
                .append("organizationId", this.getOrganizationId())
                .append("patientFacilityName", this.getPatientFacilityName())
                .append("patientFacilityNumber", this.getPatientFacilityNumber())
                .append("patientGivenName", this.getPatientGivenName())
                .append("patientId", this.getPatientId())
                .append("patientLastName", this.getPatientLastName())
                .append("patientSSN", this.getPatientSSN())
                .append("purposeForUse", this.getPurposeForUse())
                .append("remoteDocumentId", this.getRemoteDocumentId())
                .append("remoteDocumentRepositoryId", this.getRemoteDocumentRepositoryId())
                .append("remoteOrganization", this.getRemoteOrganization())
                .append("remoteOrganizationId", this.getRemoteOrganizationId())
                .append("userFacilityName", this.getUserFacilityName())
                .append("userFacilityNumber", this.getUserFacilityNumber())
                .append("userId", this.getUserId())
                .append("systemId", this.getSystemId())
                .append("userName", this.getUserName())
                .append("userRole", this.getUserRole()).toString();
    }
}
