/*(function () {
    if (window.location.pathname === '/nvap-web/Login.do' || window.location.pathname === '/nvap-web/Logout.do_sec') {
        return;
    }
    $.ajax({
        url: 'Login.do?checkSession=true',
        success: function(result) {
            if (result !== '1') {
                window.location.href = 'Login.do';
            }
        },
        error: function(result) {
            window.location.href = 'Login.do';
        }
    });
})();*/

function doSubmit(form) {
    return true;
}

function setFocus(obj) {
    document.all.formErrors ? document.all.offScreenErrors.focus() : obj.focus();
}

$(document).ready(function () {
    $(document).on('click', '.allableCheckbox', function () {
        if ($(this).val() === 'ALL') {
            if ($('.allableCheckbox[value=ALL]').is(':checked')) {
                $('.allableCheckbox').each(function () {
                    $(this).prop("checked", false);
                });
                $('.allableCheckbox[value=ALL]').prop("checked", true);
            }
        } else {
            var nonAllChecked = false;
            $('.allableCheckbox').each(function () {
                nonAllChecked |= $(this).prop("checked");
            });
            $('.allableCheckbox[value=ALL]').prop("checked", !nonAllChecked);
        }
    });

    if ($(".vap-alert")) {
        window.setTimeout(function () {
            $(".vap-alert").fadeTo(500, 0).slideUp(500, function () {
                $(this).remove();
            });
        }, 5000);
    }
    
    //for all of the tags with a data-tooltip attribute, add the appropriate tooltip for it
    if ($("[data-tooltip]") !== null) {
        $("[data-tooltip]").each(function(){
            var element = $(this);
            var tooltipText = element.data('tooltip'); 

            if(element.is("[data-tooltip-position]")) {
                var position = element.data('tooltip-position');
                if(position === 'left') { //so far we only have left alignment as an option other than the default
                    var pos = {
                        my: 'center right',
                        at: 'center left'
                    };
                }
            } else { //this is the default
                var pos = { 
                    my: 'center left',
                    at: 'center right'
                };
            }

            element.qtip($.extend(tipOptions, {
                content: tooltipText,
                position: pos
            }));
        });
    }
    
    jQuery('#csvButton').on('click', function () {
        if (reportTable.page.info().recordsTotal < scheduledExportThreshold) {
            createExportModal('export-alert', 'exportToCsv', true, validateSSNsBeforeExport);
        }
        else {
            createExportModal('scheduled-csv-export-alert', 'exportToCsv', false, validateSSNsBeforeExport);
        }
    });

    //the button is ajaxed as to not refresh the page
    jQuery('#excelButton').on('click', function () {
        if (reportTable.page.info().recordsTotal < scheduledExportThreshold) {
            createExportModal('export-alert', 'exportToExcel', true, validateSSNsBeforeExport);
        }
        else {
            createExportModal('scheduled-export-alert', 'exportToExcel', false, validateSSNsBeforeExport);
        }
    });
});

createExportModal = function(divToShow, baseUrl, exportNow, mustValidateSSNsBeforeExport) {
    $('#' + divToShow).dialog({
        resizable: false,
        height: "auto",
        width: 400,
        modal: true,
        open: function(event, ui) {
            $('#' + divToShow).show();
        },
        buttons: {
            "Export": function() {
                if(exportNow){
                    if(mustValidateSSNsBeforeExport){
                        if(validateSsns()){
                            window.location.href = constructUrl(baseUrl);
                        }
                    } else {
                        window.location.href = constructUrl(baseUrl);
                    }
                    
                } else {
                    if(mustValidateSSNsBeforeExport){
                        if(validateSsns()){
                            $.ajax(constructUrl(baseUrl));
                            $(this).prop('disabled', true);
                        }
                    } else {
                        $.ajax(constructUrl(baseUrl));
                        $(this).prop('disabled', true);
                    }
                }
                
                $(this).dialog("close");
            },
            Cancel: function() {
                $(this).dialog("close");
            }
        }
    });
};

jQuery(document).ajaxError(function (e, jqXHR, ajaxSettings, thrownError) {
    // if 901 - user does not have an active session, so redirect to login page
    if (jqXHR.status == '901') {
        window.location.href = 'Login.do';
    }
});

//global options for the tool tips (descriptors in the session scope)
tipOptions = {
    position : {
        my: 'center left',
        at: 'center right'
    },
    show : {
        delay: 700
    }
};

function escapeHTML(unsafe) {
    return unsafe
         .replace(/&/g, "&amp;")
         .replace(/</g, "&lt;")
         .replace(/>/g, "&gt;")
         .replace(/"/g, "&quot;")
         .replace(/'/g, "&#039;");
 };

//DataTables specific overrides/functions

function addAriaToDataTable(tableId, dataTableVariable) {
    var $tbody = $('#' + tableId + '').find("tbody");
    $tbody.find("th").attr("role", "rowheader");
    $tbody.find("td").attr("role", "gridcell");

    if ( !dataTableVariable.data().any() ) {
        //we have no records so we have to add a role="row" to the returned tr for aria compliance
        $tbody.find("tr").attr("role", "row");
    }
};

function setProcessingForDataTable(tableId, top) {
    $('#' + tableId).on( 'processing.dt', function () {
        if (top === undefined) top = 0;
        $('#' + tableId + '_processing').css('background', 'rgba(220,220,220,0.8)');
        $('#' + tableId + '_processing').css('font-weight', 'bold');
        $('#' + tableId + '_processing').css('top', top + 'px');
        $('#' + tableId + '_processing').css('height', '100%');
        $('#' + tableId + '_processing').css('z-index', '10');
        if (top !== 0) {
            $('#' + tableId + '_processing').css('padding-bottom', -top + 'px');
        }
    }).dataTable();
};

function handleErrorsInDataTable(tableId, responseObject, colsToSpan) {
    $('#' + tableId + '_processing').hide();
    $('.dataTables_empty').remove();
    var json = responseObject.responseJSON;
    
    //handle session expirations
    if(responseObject.status == '901') {
        window.location.href = 'Login.do';
    }
    
    if(json.errorData){
        var message = json.errorData.customMessage.length > 0 ? json.errorData.customMessage : 'An Error Occurred';
        $('#' + tableId + ' tbody').html('<tr class="odd" role="row"><td valign="top" colspan="' + colsToSpan + '" class="dataTables_empty text-center" role="gridcell">' + message + '</td></tr>');
    } else {
        $('#' + tableId + ' tbody').html('<tr class="odd" role="row"><td valign="top" colspan="' + colsToSpan + '" class="dataTables_empty text-center" role="gridcell">An Error Occurred</td></tr>');
    }
};

//called on the success of the last JSChart created on a page (as they are currently chained together)
function addAriaToJSCharts(){
    $('.chartjs-hidden-iframe').each(function(i, obj) {
        var titleToSet = $(obj).siblings("canvas").data('title');
        $(obj).attr("title", titleToSet);
    });
};

//common method to validate a start and end date. returns an error message if one is found or returns a blank one if none are found. validates dates in mm/dd/yyyy format
function validateStartAndEndDate(startDate, endDate, futureDatesEnabled) {
    var errorMessage = '';
    var today = moment();
    var re = /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/;
    
    if (typeof futureDatesEnabled === 'undefined') {
        futureDatesEnabled = false; //default this to false if its not passed in as it is an optional param
    }
    
    if ((startDate === '' || (moment(startDate, 'MM/DD/YYYY').isValid() && startDate.match(re))) && ((endDate === '' || (moment(endDate, 'MM/DD/YYYY').isValid() && endDate.match(re))))) {
        var startDateToUse = moment(startDate, 'MM/DD/YYYY');
        var endDateToUse = moment(endDate, 'MM/DD/YYYY');

        if (!futureDatesEnabled) { //if the future dates are NOT enabled (default) then we check for start and end dates that need to be prior or equal to today
            if (startDate !== '') {
                if (startDateToUse.isAfter(today)) {
                    errorMessage = 'Start date must be prior or equal to today.';
                }
            }
            if (endDate !== '') {
                if (endDateToUse.isAfter(today)) {
                    errorMessage = 'End date must be prior or equal to today.';
                }
            }
        }
        if (startDate !== '' && endDate !== '') {
            if (startDateToUse.isAfter(endDateToUse)) {
                errorMessage = 'Start date must be before or equal to end date.';
            }
        }
    } else {
        errorMessage = 'Start date and end date must be valid dates in the mm/dd/yyyy format.';
    }
    
    return errorMessage;
}