<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<f:mainTemplate headerText="Set Default Facility">
    <script type="text/javascript">
        function doSubmit(form) {
            //popup('processingDIV');
            return true;
        }
        function enableObject(arg) {
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                elmt.disabled = false;
            }
        }
        function disableObject(arg) {
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                elmt.disabled = true;
            }
        }
        function formShow(id) {
            var elmt = document.getElementById(id);
            if (elmt != null) {
                elmt.style.display = "";
            }
        }
        function formHide(id) {
            var elmt = document.getElementById(id);
            if (elmt != null) {
                elmt.style.display = "none";
            }
        }
        function checkState() {
            //only run the first time
            var state = '${facilityState}';
            newState(state);
            document.getElementById("facility").focus();
        }

        function newState(currentState) {
            if (currentState == "manual") {
                //hide auto and none
                formHide('content-page-auto');
                formHide('content-page-none');
                formHide('content-page-label-auto');
                formHide('content-page-label-none');
                document.getElementById('removeManualFacility').disabled = false;
                //show manual state
                formShow('content-page-manual');
                formShow('content-page-label-manual');
            } else if (currentState == "auto") {
                //hide manual and none
                formHide('content-page-manual');
                formHide('content-page-none');
                formHide('content-page-label-manual');
                formHide('content-page-label-none');
                document.getElementById('removeManualFacility').disabled = true;
                //show auto state
                formShow('content-page-auto');
                formShow('content-page-label-auto');
            } else {
                //hide manual and auto
                formHide('content-page-manual');
                formHide('content-page-auto');
                formHide('content-page-label-manual');
                formHide('content-page-label-auto');
                document.getElementById('removeManualFacility').disabled = true;
                //show none state
                formShow('content-page-none');
                formShow('content-page-label-none');
            }
        }
        $(document).ready(function () {
            checkState();
        });
    </script>
    <div>
        <div id="content-page-manual" class="well" style="display: none;">Your default facility is manually set to <c:out value="${visualDefaultUserFacility}"/></div>
        <div id="content-page-auto" class="well" style="display: none;">Your default facility is automatically set to <c:out value="${visualDefaultUserFacility}"/>, based on your user ID.</div>
        <div id="content-page-none" class="well" style="display: none;">You do not currently have a default facility. To set a default Facility, choose a facility from the drop down list and click Set Default Facility.</div>
        <div id="content-page-label-manual" class="well" style="display: none;">To change your default setting, choose a facility from the drop down list and click Set Default Facility. To remove your default setting and revert to the automatic system setting, click Remove Default Facility</div>
        <div id="content-page-label-auto" class="well" style="display: none;">To change your default setting, choose a facility from the drop down list and click Set Default Facility. *Note: the option to remove the automatic system is not available.</div>
    </div>
    <cpp:errors />
    <div class="form-container">
        <form name="setDefaultFacilityForm" action="SetDefaultFacility.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <div>
                <label for="facility" class="vap-reg-label"><strong>VA Facility </strong></label>
                <select id="facility" name="facility" data-tooltip="<c:out value="${descriptors['defaultFacilityField']}"/>">
                    <c:forEach var="f" items="${facilities}">
                        <option value="<c:out value="${f.facilityStation}"/>"
                            <c:choose>
                                <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                    selected
                                </c:when>
                                <c:when test="${cookie.facility.value == f.facilityStation}">
                                    selected
                                </c:when>
                            </c:choose>>
                            <c:choose>
                                <c:when test="${f.facilityName != ''}">
                                    <c:out value="${f.facilityName}"/>
                                </c:when>
                                <c:otherwise>
                                    <c:out value="${fn:split(f.facilityDns, '.')[0]}"/>
                                </c:otherwise>
                            </c:choose>
                            (<c:out value="${f.facilityStation}"/>)
                        </option>
                    </c:forEach>
                </select>
            </div>
            <br />
            <div>
                <input id="setManualFacility" name="setManualFacility" data-tooltip="<c:out value="${descriptors['setDefaultFacilityButton']}" />" class="button" type="submit" value="Set Default Facility" />
                <span id="removeManualFacilityTip">
                    <input id="removeManualFacility" name="removeManualFacility" title="Remove Default Facility" class="button" type="submit" value="Remove Default Facility" style="z-index: -1;" data-tooltip="<c:out value="${descriptors['removeDefaultFacilityButton']}"/>" />
                </span>
            </div>
        </form>
    </div>
</f:mainTemplate>