<%--
    Document   : apiUsage
    Created on : Feb 4, 2016, 9:05:42 AM
    Author     : Johann Sonnenberg
--%>

<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<f:mainTemplate headerText="Service Audit Report">
    <script language="JavaScript">
        $(document).ready(function () {

            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            $('#service').on('change', function () {
                var service = $('#service').val();

                if (service != 'ALL') {

                    //make the ajax call to get the calls (methods) for the selected web service
                    $.ajax({url: "ServiceAuditReport.do_sec?getCallsByWebService=true&webservice=" + service, success: function (result) {
                            $('#method').html(result);
                        }});
                } else {
                    $('#method').html('<option value="ALL">All</option>');
                }
            });

            var service = $('#service').val();
            var method = $('#method').val();
            var authorized = $('#authorized').val();
            var success = $('#success').val();
            var duration = $('#duration').val();
            var startDate = $('#startDate').val();
            var endDate = $('#endDate').val();

            //initial data table setup and call for the first recordset
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('tblServiceAuditReport');

            var auditReportTable = $('#tblServiceAuditReport').DataTable({
                deferLoading: 0,
                destroy: true,
                searching: false,
                processing: true,
                serverSide: true,
                order: [[2, 'desc']],
                ajax: "ServiceAuditReport.do_sec?doSearch=true&useJSON=true&webservice=" + service + "&method=" + method + "&authorized=" + authorized + "&success=" + success + "&duration=" + duration + "&startDate=" + startDate + "&endDate=" + endDate,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25,
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                columnDefs: [
                    {className: "dt-head-center", targets: [0,1,2,3,4,5,6]},
                    {className: "dt-head-center dt-body-right", targets: [7]}
                ]
            });

            auditReportTable.on('draw', function () {
                addAriaToDataTable('tblServiceAuditReport', auditReportTable);
            });

            //when the search button is pressed this function is used
            $('#btnSearch').on('click', function () {
                var service = $('#service').val();
                var method = $('#method').val();
                var authorized = $('#authorized').val();
                var success = $('#success').val();
                var duration = $('#duration').val();
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    auditReportTable.ajax.url("ServiceAuditReport.do_sec?doSearch=true&useJSON=true&webservice=" + service + "&method=" + method + "&authorized=" + authorized + "&success=" + success + "&duration=" + duration + "&startDate=" + startDate + "&endDate=" + endDate).load();
                }
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });
    </script>

    <div class="form-container pad-bottom-20">
        <form name="patientSearchForm">
            <fieldset>
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="pad-top-10">
                    <label for="service" class="width-120">Service</label>
                    <select id="service" name="service" data-tooltip="<c:out value="${descriptors['serviceAuditServiceField']}" />">
                        <option value="ALL" selected="selected">All</option>
                        <c:forEach var="ws" items="${webservices}" varStatus="i">
                            <option id="<c:out value="${ws}" />"><c:out value="${ws}" /></option>
                        </c:forEach>
                    </select>
                </div>
                <div>
                    <label for="method" class="width-120">Method</label>
                    <select id="method" name="method" data-tooltip="<c:out value="${descriptors['serviceAuditMethodField']}" />">
                        <option value="ALL">All</option>
                    </select>
                </div>
                <div>
                    <label for="authorized" class="width-120">Authorized</label>
                    <select id="authorized" name="authorized" data-tooltip="<c:out value="${descriptors['serviceAuditAuthorizedField']}" />">
                        <option value="ALL">All</option>
                        <option value="1">Yes</option>
                        <option value="0">No</option>
                    </select>
                </div>
                <div>
                    <label for="success" class="width-120">Success</label>
                    <select id="success" name="success" data-tooltip="<c:out value="${descriptors['serviceAuditSuccessField']}" />">
                        <option value="ALL">All</option>
                        <option value="1">Yes</option>
                        <option value="0">No</option>
                    </select>
                </div>
                <div>
                    <label for="duration" class="width-120">Duration</label>
                    <select id="duration" name="duration" data-tooltip="<c:out value="${descriptors['serviceAuditDurationField']}" />">
                        <option value="ALL">All</option>
                        <option value="10">&gt; 10ms</option>
                        <option value="50">&gt; 50ms</option>
                        <option value="100">&gt; 100ms</option>
                        <option value="200">&gt; 200ms</option>
                        <option value="500">&gt; 500ms</option>
                    </select>
                </div>
                <div id="datesTip" class="width-350" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}" />">
                    <div>
                        <label for="startDate" class="width-120">Start Date</label>
                        <input type="text" name="startDate" id="startDate" size="10" maxlength="10" /> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate" class="width-120">End Date</label>
                        <input type="text" name="endDate" id="endDate" size="10" maxlength="10" /> <i>mm/dd/yyyy</i>
                    </div>
                </div>
            </fieldset>
            <div>
                <input name="btnSearch" id="btnSearch" title="Search" class="button" type="button" value="Search" />
            </div>
        </form>
    </div>
    <div id="results">
    <div id="divReportContent">
        <table id="tblServiceAuditReport" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="serviceAuditWebServiceHeader" data-tooltip="<c:out value="${descriptors['serviceAuditWebServiceColumn']}" />">Web Service</span></th>
                    <th role="columnheader"><span id="serviceAuditMethodHeader" data-tooltip="<c:out value="${descriptors['serviceAuditMethodColumn']}" />">Method</span></th>
                    <th role="columnheader"><span id="serviceAuditEventDateHeader" data-tooltip="<c:out value="${descriptors['serviceAuditEventDateColumn']}" />">Event Date (CT)</span></th>
                    <th role="columnheader"><span id="serviceAuditIPAddressHeader" data-tooltip="<c:out value="${descriptors['serviceAuditIPAddressColumn']}" />">IP Address</span></th>
                    <th role="columnheader"><span id="serviceAuditDomainHeader" data-tooltip="<c:out value="${descriptors['serviceAuditDomainColumn']}" />">Domain</span></th>
                    <th role="columnheader"><span id="serviceAuditAuthorizedHeader" data-tooltip="<c:out value="${descriptors['serviceAuditAuthorizedColumn']}" />">Authorized</span></th>
                    <th role="columnheader"><span id="serviceAuditSuccessHeader" data-tooltip="<c:out value="${descriptors['serviceAuditSuccessColumn']}" />">Success</span></th>
                    <th role="columnheader"><span id="serviceAuditDurationHeader" data-tooltip="<c:out value="${descriptors['serviceAuditDurationColumn']}" />" data-tooltip-position="left">Duration (ms)</span></th>
                </tr>
            </thead>
        </table>
    </div>
    </div>
</f:mainTemplate>
