<%--
    Document   : scheduledExports
    Created on : Sep 8, 2016, 12:08:31 PM
    Author     : Zachary Tubb
--%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<f:mainTemplate headerText="Scheduled Exports">
    <script language="JavaScript">
        $(document).ready(function(){
            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('reportTable');

            var reportTable = $('#reportTable').DataTable( {
                destroy: true,
                searching: false,
                processing: true,
                serverSide: true,
                order: [[2, 'desc']],
                ajax: "ScheduledExports.do_sec?getUserExports=true",
                columnDefs: [
                    {orderable: false, targets: 4},
                    {className: "dt-head-center", targets: [0,1,2,3]},
                    {className: "dt-head-center dt-body-center", targets: 4}
                ],
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25
            });
            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });
            $('#refreshButton').on('click', function() {
                $('#reportTable').DataTable().ajax.reload();
            });

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });
        });
    </script>
    <div class="well">
        Excel and CSV exports for reports will appear here for download once the export generation has been completed.
    </div>
    <div id="divReportContent">
        <button class="btn pull-right" id="refreshButton" title="Refresh">Refresh <span class="fa fa-refresh" aria-hidden="true"></span></button>
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader" style="min-width: 320px;"><span data-tooltip="<c:out value="${descriptors['scheduledExportsReportColumn']}" />">Report</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['scheduledExportsFormatColumn']}" />">Format</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['scheduledExportsDateColumn']}" />">Date Generated (CT)</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['scheduledExportsStatusColumn']}" />">Status</span></th>
                    <th role="columnheader"><span data-tooltip="<c:out value="${descriptors['scheduledExportsDownloadColumn']}" />" data-tooltip-position="left">Download</span></th>
                </tr>
            </thead>
        </table>
    </div>
</f:mainTemplate>