<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>

<script type="text/javascript">
    jQuery(document).ready(function () { 
        setFocus(multiSelectListForm.authenticatingFacility);
        opt.init(document.multiSelectListForm);
    });
</script>

<div>
    <p class="detailText">
        The Veteran requests and authorizes VA to revoke ALL restrictions
        previously submitted on the release of his/her personal health
        information for treatment purposes to non-VA health care provider
        organizations through ${organizationName}. By revoking all restrictions 
        requests, the sharing of Veteran electronic health information to 
        non-VA health care provider organizations through ${organizationName} 
        is no longer restricted or limited in any way. <br />
    </p>
    <p class="detailText">
        The VA Form 10-0525 for the revocation of
        Veteran restriction request for sharing of his/her electronic
        health information with non-VA health care provider organizations
        participating in ${organizationName} and partnering with VA for 
        treatment purposes has been validated and verified. The sharing 
        of Veteran electronic health information is no longer restricted 
        or limited in any way.
    </p>
</div>
<div class="form-container">
    <fieldset>
        <legend>Revoke or Terminate</legend>
        <div>
            <input title="Choose the radio button to select Patient revokes access to all ${organizationName} Providers and Organizations" type="radio" name="consentGroup" value="revoke" checked />
            Patient revokes restrictions to all non-VA healthcare providers and Organizations. 
            <br /> <br />
            <p class="detailText">
                * NOTE: Revoke does not restrict sharing of patient information with DoD, VA patient information is always shared with the DoD.
            </p>
        </div>
        <form name="multiSelectListForm" id="multiSelectListForm" action="PatientDetails.do_sec" method="POST" onsubmit="onRevoke(); return doSubmit(this);" enctype="multipart/form-data">
            <input type="hidden" name="icn" value="${patientDemographics.icn}" /> 
            <input type="hidden" name="requestId" value="${requestId}" /> 
            <input type="hidden" name="patientId" value="${consentDirective.patientIen}" /> 
            <input type="hidden" name="consentType" value="NwHIN Organization Restriction Revocation" /> 
            <input type="hidden" name="purposeOfUse" value="TREATMENT" />
            <div id="multiSelectAuthorizeForm">
                <table bgcolor="#eff2ff">
                    <tr>
                        <td>
                            <strong>All Providers and Organizations (unrestricted)</strong>
                        </td>
                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                        <td>
                            <strong>${organizationName} Providers and Organizations who will NOT have access to your records (restricted)</strong>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <select title="All Providers and Organizations list box" style="width: 310px;" class="listSelect" name="list1" id="list1" multiple="multiple" size="10">
                                <c:if test="${!empty authorizedOrganizations}">
                                    <c:forEach var="r" items="${authorizedOrganizations}" varStatus="i">
                                        <c:choose>
                                            <c:when test="${r.orgNumber eq  '200DOD'}">
                                                <option value="<c:out value="${r.orgNumber}"/>"><c:out value="${r.orgName}"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                            </c:when>
                                            <c:otherwise>
                                                <option value="<c:out value="${r.orgNumber}"/>"><c:out value="${r.orgName}"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:forEach>
                                </c:if>
                            </select>
                        </td>
                        <td valign="middle" align="left">
                            <input style="width: 125px; height: 30px;" type="button" title="Move all the Organizations to the right box" class="midButton" name="right" value="Move All &gt;&gt;" onclick="opt.transferAllRight()" disabled="disabled" />
                            <br />
                            <input type="button" title="Move the Selected Organizations to the right box" class="midButton" disabled="disabled" style="width: 125px; height: 30px;" name="right" value="Move Selected &gt;" onclick="opt.transferRight()" />
                            <br /><br /> 
                            <input type="button" title="Move the selected Organizations to the left box" class="midButtonLeft" disabled="disabled" style="width: 125px; height: 30px;" name="left" value="&lt; Move Selected" onclick="opt.transferLeft()" />
                            <br /> 
                            <input type="button" title="Clear all selections" class="midButton" name="left" style="width: 125px; height: 30px;" disabled="disabled" value="Clear" onclick="opt.transferAllLeft()" />
                        </td>
                        <td>
                            <select title="${organizationName} Providers and Organizations who will NOT have access to your records list box" name="list2" class="listSelect" multiple="multiple" size="10" id="list2" style="width: 310px;">
                                <c:if test="${!empty excludedOrganizations}">
                                    <c:forEach var="r" items="${excludedOrganizations}" varStatus="i">
                                        <option value="<c:out value="${r.orgNumber}"/>"><c:out value="${r.orgName}"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                                    </c:forEach>
                                </c:if>
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
            <div>
                <label for="authenticatingFacility">
                    Authenticating Facility 
                    <img alt="Required field" src="res/star-icon_grey_bg.png" />
                </label> 
                <select id="authenticatingFacility" name="userFacility" style="width: 250px; overflow: auto;">
                    <c:forEach var="f" items="${allowedFacilities}">
                        <option value="<c:out value="${f.facilityStation}"/>"
                            <c:choose>
                                <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                    selected
                                </c:when>
                                <c:when test="${cookie.facility.value == f.facilityStation}">
                                    selected
                                </c:when>
                            </c:choose>>
                            <c:choose>
                                <c:when test="${f.facilityName != ''}">
                                    <c:out value="${f.facilityName}"/>
                                </c:when>
                                <c:otherwise>
                                    <c:out value="${fn:split(f.facilityDns, '.')[0]}"/>
                                </c:otherwise>
                            </c:choose>
                            (<c:out value="${f.facilityStation}"/>)
                        </option>
                    </c:forEach>
                </select> 
                <br /> <br />
            </div>
            <div id="revokeForm">
                <div>
                    <label for="reason">
                        Inactivation Reason
                        <img alt="Required field" src="res/star-icon_grey_bg.png" /> 
                    </label> 
                    <select id="reason" name="reason" onchange="onOptoutReasonChange(this);">
                        <option value="">--Select a reason--</option>
                        <c:if test="${!empty optOutReasons}">
                            <c:forEach var="r" items="${optOutReasons}" varStatus="i">
                                <c:choose>
                                    <c:when test="${r eq 'New Authorization'}">
                                    </c:when>
                                    <c:otherwise>
                                        <option value="<c:out value="${r}"/>"><c:out value="${r}"/></option>
                                    </c:otherwise>
                                </c:choose>
                            </c:forEach>
                        </c:if>
                    </select>
                </div>
                <br />
                <div id="revokeValidationCheckBox" style="display: none;">
                    <label>
                        10-0525 Form Validation
                        <img alt="Required field" src="res/star-icon_grey_bg.png" />
                    </label> 
                    <input id="revokeValidationCheckBoxInput" type="checkbox" title="select Form Validation checkbox if Revocation Form 10-0525 was received and validated. required field" onclick="enableRevokeAfterValidation('signatureDate', 'Revoke');" name="option1" value="Revocation Form Received and Validated" />
                    Revocation Form Received and Validated
                    <br /> <br />
                </div>
                <div id="revokeDateAndUploadValidation"	style="display: none;">
                    <div>
                        <label>
                            Patient Signature Date
                            <img alt="Required field" src="res/star-icon_grey_bg.png" />
                        </label>
                        <date:date id="signatureDate" name="signatureDate" onkeyup="enableRevokeAfterValidation('signatureDate', 'Revoke');"/> <i>mm/dd/yyyy</i>
                        <br /> <br />
                    </div>
                    <c:choose>
                        <c:when test="${isFormUploadAllowed}">
                            <div>
                                <label for="file">
                                    Upload Consent Form
                                    <br /> 
                                    <i>
                                        <span style="font-weight: normal;">(Max file size: <c:out value="${maxFileUploadSize/1000000}"/> megabytes)</span> 
                                    </i> 
                                </label>
                                <input title="Browse and Upload Consent Form" name="uploaded" type="file" id="file" accept="application/pdf" />
                            </div>
                        </c:when>
                    </c:choose>
                </div>
                <div id="revokeDateAndUploadValidationPatientDeceased" style="display: none;">
                    <div>
                        <label for="deceasedDate">
                            Patient Deceased Date
                            <img alt="Required field" src="res/star-icon_grey_bg.png" /> 
                        </label>
                        <date:date id="deceasedDate" name="deceasedDate" onkeyup="enableRevokeAfterValidation('deceasedDate', 'Revoke');"/> <i>mm/dd/yyyy</i>
                        <br /> <br />
                    </div>
                </div>
                <div>
                    <label for="comments">Comments</label>
                    <textarea id="comments" name="comments" style="width: 300px; height: 60px;"></textarea>
                    <br />
                </div>
                <br />
                <div align="center" id="revokeButton" style="display:">
                    <input id="Revoke" title="Revoke" class="button" disabled="disabled" type="submit" value="Revoke" name="optOut" onClick="enableAllElements()" />
                </div>
            </div>
        </form>
    </fieldset>
</div>