<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>

<div>
    <p class="detailText">
        The Veteran's current Authorization permits VA to share his/her
        electronic health information with non-VA health care provider
        organizations participating in the <c:out value="${organizationName}" /> and partnering with VA
        for treatment purposes. Revocation of this authorization will result
        in the VA no longer having permission to share electronic health
        information in this way. If the Veteran revokes this Authorization,
        VA will stop sharing his/her electronic health information with private
        health care provider through <c:out value="${organizationName}" />.
    </p>
    <p class="detailText">
        To revoke this authorization, check the box and enter the Patient Signature Date and click <strong>Revoke</strong>.
    </p>
    <p class="detailText">
        To submit a new authorization, select New Authorization as the 'Inactivation Reason' 
        and enter the Patient Signature Date for the new authorization form received.
    </p>
    <p class="detailText">
        Note: VA patient information is always shared with the DoD,
        a patient's Authorization/Revocation status does not affect interactions with
        the Department of Defense. 
    </p>
</div>
<div class="form-container">
    <fieldset>
        <legend>Revoke</legend>
        <div>
            <input title="Choose the radio button to select Patient revokes access to all <c:out value="${organizationName}" /> Providers and Organizations" type="radio" name="consentGroup" id="consentGroup" value="revoke" aria-labelledby="forConsentGroup" checked>
            <span id="forConsentGroup">Patient revokes access to all non-VA healthcare Providers and Organizations</span>
            <br /> <br />
        </div>
        <form name="multiSelectListForm" id="multiSelectListForm" action="PatientDetails.do_sec" method="POST" onsubmit="onRevoke(); return doSubmit(this);" enctype="multipart/form-data">
            <input type="hidden" name="icn" value="<c:out value="${patientDemographics.icn}" />" /> 
            <input type="hidden" name="requestId" value="<c:out value="${requestId}" />" /> 
            <input type="hidden" name="patientId" value="<c:out value="${consentDirective.patientIen}" />" /> 
            <input type="hidden" name="consentType" value="NwHIN Revocation" />
            <input type="hidden" name="purposeOfUse" value="TREATMENT" />
            <input type="hidden" name="expirationYears" value="10" />

            <div>
                <label for="authenticatingFacility">Authenticating Facility <img alt="Required field" src="res/star-icon_grey_bg.png" /></label> 
                <select id="authenticatingFacility" name="userFacility">
                    <c:forEach var="f" items="${allowedFacilities}">
                        <option value="<c:out value="${f.facilityStation}" />"
                            <c:choose>
                                <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                    selected
                                </c:when>
                                <c:when test="${cookie.facility.value == f.facilityStation}">
                                    selected
                                </c:when>
                            </c:choose>>
                            <c:choose>
                                <c:when test="${f.facilityName != ''}">
                                    <c:out value="${f.facilityName}" />
                                </c:when>
                                <c:otherwise>
                                    <c:out value="${fn:split(f.facilityDns, '.')[0]}" />
                                </c:otherwise>
                            </c:choose>
                            (<c:out value="${f.facilityStation}" />)
                        </option>
                    </c:forEach>
                </select> 
                <br /> <br />
            </div>
            <div id="revokeForm">
                <div>
                    <label for="reason">Inactivation Reason<img alt="Required field" src="res/star-icon_grey_bg.png" /> </label> 
                    <select id="reason" name="reason" onchange="onOptoutReasonChange(this);" onkeyup="onOptoutReasonChange(this);">
                        <option title="Select a Opt out reason from the dropdown list" value="">--Select a reason--</option>
                        <c:if test="${!empty optOutReasons}">
                            <c:forEach var="r" items="${optOutReasons}" varStatus="i">
                                <c:choose>
                                    <c:when test="${r eq 'New Authorization'}">
                                        <c:if test="${isNewAuthorizationAllowed eq true}">
                                            <option value="<c:out value="${r}" />"><c:out value="${r}" /></option>
                                        </c:if>
                                    </c:when>
                                    <c:otherwise>
                                        <option value="<c:out value="${r}" />"><c:out value="${r}" /></option>
                                    </c:otherwise>
                                </c:choose>
                            </c:forEach>
                        </c:if>
                    </select>
                </div>
                <br />
                <label id="formValidationLabel">Form Validation for</label><br />
                <div id="revokeValidationCheckBox" style="display: none;">
                    <label for="revokeValidationCheckBoxInput">10-0484<img alt="Required field" src="res/star-icon_grey_bg.png" /></label> 
                    <input id="revokeValidationCheckBoxInput"  type="checkbox" title="select Form Validation checkbox if Revocation Form 10-0484 was received and validated. required field" onclick="enableRevokeAfterValidation('signatureDate', 'Revoke');" name="option1" value="Revocation Form Received and Validated" aria-labelledby="formValidationLabel">
                    Revocation Form Received and Validated
                    <br /><br />
                </div>
                <div id="newValidationCheckBox" style="display: none;">
                    <label for="newValidationCheckBoxInput">10-0485<img alt="Required field" src="res/star-icon_grey_bg.png" /></label> 
                    <input id="newValidationCheckBoxInput" type="checkbox" title="select Form Validation checkbox if New Authorization Form 10-0485 was received and validated. required field" onclick="enableRevokeAfterValidation('signatureDate', 'revokeAndAuthorize');" name="option1" value="New Authorization Form Received and Validated" aria-labelledby="formValidationLabel">
                    New Authorization Form Received and Validated
                    <br /><br />
                </div>
                <div id="revokeDateAndUploadValidation" style="display: none;">
                    <div>
                        <label for="signatureDate">Patient Signature Date<img alt="Required field" src="res/star-icon_grey_bg.png" /></label> 
                        <date:date id="signatureDate" name="signatureDate" onkeyup="enableRevokeAfterValidation('signatureDate', 'Revoke');"/> <i>mm/dd/yyyy</i>
                        <br /><br />
                    </div>
                    <c:choose>
                        <c:when test="${isFormUploadAllowed}">
                            <div>
                                <label for="file">Upload Consent Form<br /> 
                                    <i>
                                        <span style="font-weight: normal;">(Max file size: <c:out value="${maxFileUploadSize/1000000}" /> megabytes)</span> 
                                    </i> 
                                </label>
                                <input title="Browse and Upload Consent Form" name="uploaded" type="file" id="file" accept="application/pdf" />
                            </div>
                        </c:when>
                    </c:choose>
                </div>
                <div id="revokeDateAndUploadValidationPatientDeceased" style="display: none;">
                    <div>
                        <label for="deceasedDate">Patient Deceased Date<img alt="Required field" src="res/star-icon_grey_bg.png" /></label> 
                        <date:date id="deceasedDate" name="deceasedDate" onkeyup="enableRevokeAfterValidation('deceasedDate', 'Revoke');"/> <i>mm/dd/yyyy</i>
                        <br /> <br />
                    </div>
                </div>
                <div>
                    <label for="comments">Comments</label>
                    <textarea id="comments" name="comments" style="width: 300px; height: 60px;"></textarea>
                    <br />
                </div>
                <br />
                <div align="center" id="revokeButton" style="display:">
                    <input id="Revoke" title="Revoke" class="button" disabled="disabled" type="submit" value="Revoke" name="optOut" onClick="enableAllElements()">
                </div>
                <div align="center" id="revokeAndAuthorizeButton" style="display: none;">
                    <input id="revokeAndAuthorize" title="Revoke" class="button" disabled="disabled" type="submit" value="Revoke and Submit New Authorization" name="optOut" onClick="enableAllElements()">
                </div>
            </div>
        </form>
    </fieldset>
</div>