<%--
    Document   : facilitiesFilter
    Created on : May 18, 2016
    Author     : Irakli Kakushadze
--%>
<%--
    PARAMETERS (referenced as param.myParameter in this jsp)
    defaultUserFacility - Default facility of the current user, if any
    defaultUserFacilityName - The name of the default facility
    defaultUserFacilityStation - Station number of the default facility
    facilityFilterTooltip - To be used for the tooltip on the Select Facilities select box
--%>

<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="defaultUserFacility" value="${param.defaultUserFacility}" scope="page" />

<div style="overflow: auto;">
    <input type="hidden" id="aggregateAtFacilityLevel" name="aggregateAtFacilityLevel">
    <input type="hidden" id="includeUnknownVisn" name="includeUnknownVisn">
    <label for="fd-selectedFacilities">Authenticating Facilities</label>
    <div style="display: inline; padding: 0;">
        <div style="float: left; padding: 0;">
            <select id="fd-selectedFacilities" name="fd-selectedFacilities" multiple="multiple" style="height: 86px; overflow-x: auto; overflow-y: auto; width: 400px;" data-tooltip="<c:out value="${param.facilityFilterTooltip}" />">
                <option>ALL</option>
            </select>
        </div>
        <div style="float: left; margin-left: 5px; padding: 0;">
            <input id="fd-selectFacilities" alt="Select one or more facilities" style="vertical-align: top;" type="button" value="Select..."></input><br>
            <input id="fd-selectAll" alt="Select all facilities" style="margin-top: 5px; vertical-align: top;" type="button" value="Select ALL"></input><br>
        </div>
        <div style="padding: 0;">
            <input id="fd-stationNumbers" name="stationNumbers" type="hidden"
                <c:choose>
                    <c:when test="${empty param.defaultUserFacility}">value="ALL"</c:when>
                    <c:otherwise>value="<c:out value="${param.defaultUserFacilityStation}"/>"</c:otherwise>
                </c:choose>
            >
        </div>
    </div>
</div>

<div id="fd-facilitiesDialog" title="Select Facilities" style="display: none;">
    <p>Select one or more facilities for filtering your report results. Use the left two lists to <b>narrow down</b> the selection list on the right.
        You can select all available facilities or all facilities within specific VISNs by clicking "Select all" links.</p>
    <div id="fd-facilitiesContainer"></div>
    <div style="display: inline-block; margin-left: 3px; width: 347px;">
        <input id="fd-checkbox-includeUnknownVisn" type="checkbox"/>
        <label class="fd-label" for="fd-checkbox-includeUnknownVisn">Include consents with unknown VISN</label>
    </div>
    <div style="display: inline-block; width: 367px;">
        <input checked="checked" id="fd-groupByVisn" type="checkbox"/>
        <label class="fd-label" for="fd-groupByVisn">Display facilities grouped by VISN</label>
    </div>
    <div style="display: inline-block;">
        <input id="fd-checkbox-aggregateAtFacilityLevel" type="checkbox"/>
        <label class="fd-label" for="fd-checkbox-aggregateAtFacilityLevel">Aggregate data at the facility level</label>
    </div>
    <button id="fd-restoreLastSelection" alt="Restore last selection" style="margin-top: 5px; vertical-align: top;">Restore last selection</button>
</div>

<script>

    var facilitiesDialog = {};

    <c:if test="${not empty param.defaultUserFacility}">
        $('#fd-selectedFacilities').empty();
        $('#fd-selectedFacilities').append('<option><c:out escapeXml="false" value="${param.defaultUserFacilityName}"/></option>');
        $('input[name="stationNumbers"]').val('<c:out escapeXml="false" value="${param.defaultUserFacilityStation}"/>');
        
        $('#fd-checkbox-includeUnknownVisn').prop('checked', false);
        $('#includeUnknownVisn').val('false');
        
        $('#fd-checkbox-aggregateAtFacilityLevel').prop('checked', false);
        $('#aggregateAtFacilityLevel').val('false');
    </c:if>
    
    $('#fd-checkbox-aggregateAtFacilityLevel').on('click', function () {
        facilitiesDialog.handleAggregation();
    });

    $('#fd-facilitiesDialog').dialog({
        autoOpen: false,
        buttons: [
            {
                click: function() {
                    var aggregate = $('#fd-checkbox-aggregateAtFacilityLevel').is(':checked');
                    var stationNames = [];
                    var stationNumbers = [];
                    $('#fd-stationList input[type=checkbox]').each(function() {
                        if ($(this).is(':visible') && $(this).is(':checked')) {
                            var stationNumber = $(this).attr('data-stationNumber');
                            var stationName = $(this).attr('data-facilityName') + ' (' + stationNumber + ')';
                            if (aggregate) {
                                if (stationNumber.length === 3) {
                                    stationNames.push(stationName);
                                    stationNumbers.push(stationNumber);
                                }
                            } else {
                                if (stationNumber.length > 3) {
                                    stationName = '&nbsp;&nbsp;&nbsp;&nbsp;' + stationName;
                                }
                                stationNames.push(stationName);
                                stationNumbers.push(stationNumber);
                            }
                        }
                    });

                    if (aggregate) {
                        if (stationNames.length === $('#fd-facilityList input[type=checkbox]').length) {
                            <%-- All facilities are checked, so we will treat the selection as 'ALL' --%>
                            var stationNames = ['ALL'];
                            var stationNumbers = ['ALL'];
                        }
                    } else {
                        if (stationNames.length === $('#fd-stationList input[type=checkbox]').length) {
                            <%-- All facilities are checked, so we will treat the selection as 'ALL' --%>
                            var stationNames = ['ALL'];
                            var stationNumbers = ['ALL'];
                        }
                    }

                    $('#fd-selectedFacilities').empty();
                    for (var i in stationNames) {
                        $('#fd-selectedFacilities').append('<option>' + stationNames[i] + '</option>');
                    }
                    $('input[name="stationNumbers"]').val(stationNumbers.join(','));  

                    <%-- Store the current state of the dialog so that we can restore it on demand. --%>
                    facilitiesDialog.storeState();

                    $('#includeUnknownVisn').val($('#fd-checkbox-includeUnknownVisn').is(':checked'));
                    $('#aggregateAtFacilityLevel').val($('#fd-checkbox-aggregateAtFacilityLevel').is(':checked'));
                    
                    $(this).dialog('close');
                },
                text: 'OK'
            },
            {
                click: function() {
                    $(this).dialog('close');
                },
                text: 'Cancel'
            }
        ],
        modal: true,
        open: function () {
            if (window.location.pathname.indexOf('SummaryReport') < 0) {
                $('#fd-checkbox-aggregateAtFacilityLevel').parent().hide();
            }
        },
        show: {
            effect: 'blind',
            duration: 300
        },
        width: 1064
    });

    $('#fd-groupByVisn').on('click', function () {
        if ($(this).is(':checked')) {
            facilitiesDialog.sortFacilitiesGrouped();
        } else {
            facilitiesDialog.sortFacilitiesFlat();
        }
    });

    $('#fd-restoreLastSelection').on('click', function () {
        var state = sessionStorage.getItem('filterDialogState');
        if (state !== null) {
            var checkboxes = state.split(',');
            for (var i in checkboxes) {
                var values = checkboxes[i].split(':');
                var id = values[0];
                var checked = values[1] === '1';
                $('#' + id).prop('checked', checked);
            }
            facilitiesDialog.handleAggregation();
            facilitiesDialog.updateCheckboxes(false);
        }
    });

    $('#fd-selectAll').click(function (event) {
        event.preventDefault();
        $('#fd-selectedFacilities').empty();
        $('#fd-selectedFacilities').append('<option>ALL</option>');
        $('input[name="stationNumbers"]').val(['ALL']);

        $('#fd-visnList input[type=checkbox]').each(function() {
           $(this).prop('checked', true);
        });
        
        $('#fd-facilityList input[type=checkbox]').each(function() {
            $(this).prop('checked', true);
        });
        
        $('#fd-stationList input[type=checkbox]').each(function() {
            $(this).prop('checked', true);
        });
    });

    $('#fd-selectFacilities').click(function (event) {
        event.preventDefault();
        if ($('#fd-stationList').length) {
            <%-- Dialog has already been loaded, so we simply open it. --%>
            $('#fd-facilitiesDialog').dialog('open');
        } else {
            $.get('FacilitiesDialog.do_sec?getFacilitiesDialog=true',
                {},
                function(result) {
                    $('#fd-facilitiesContainer').html(result);
                }
            ).fail(function(event) {
                alert('failed');
                console.log(event.toString());
            });
        }
    });

    facilitiesDialog.getAggregateAtFacilityLevel = function () {
        return $('#aggregateAtFacilityLevel').val();
    };

    facilitiesDialog.getIncludeUnknownVisn = function () {
        return $('#includeUnknownVisn').val();
    };

    facilitiesDialog.getSelectedStationNumbers = function () {
        return $('input[name="stationNumbers"]').val();
    };

    facilitiesDialog.handleAggregation = function () {
        var aggregateAtFacilityLevel = $('#fd-checkbox-aggregateAtFacilityLevel').is(':checked');
        $('#fd-stationList .fd-listitem-station').each(function() {
            var facilityChecked = $(this).children(0).is(':checked');
            $(this).children('.fd-div-checkbox-indented').each(function() {
                var checkbox = $(this).children('input');
                var label = $(this).children('label');
                if (aggregateAtFacilityLevel) {
                    checkbox.prop('checked', facilityChecked);
                }
                checkbox.prop('disabled', aggregateAtFacilityLevel);
                label.css('color', aggregateAtFacilityLevel ? '#767676' : 'black');
                label.css('font-weight', checkbox.is(':checked') ? 'bold' : 'normal');
                label.prop('disabled', aggregateAtFacilityLevel);
            });
        });
    };
    
    facilitiesDialog.sortFacilitiesGrouped = function () {
        <%-- Sort facility list. --%>
        var items = $('#fd-facilityList').children('.fd-listitem-facility, .fd-listitem-visn').sort(function(a, b) {
            var textA = a.attributes['data-groupedOrder'].value;
            var textB = b.attributes['data-groupedOrder'].value;
            return textA.toLowerCase() > textB.toLowerCase() ? 1 : -1;
        });
        $('#fd-facilityList').append(items);

        <%-- Sort station list. --%>
        var items = $('#fd-stationList').children('.fd-listitem-station, .fd-listitem-visn').sort(function(a, b) {
            var textA = a.attributes['data-groupedOrder'].value;
            var textB = b.attributes['data-groupedOrder'].value;
            return textA.toLowerCase() > textB.toLowerCase() ? 1 : -1;
        });
        $('#fd-stationList').append(items);

        <%-- To show/hide the VISN headers, we can simply update the checkboxes. --%>
        facilitiesDialog.updateCheckboxes(false);

        <%-- Get rid of the empty space on top of the top-most VISN header. --%>
        $('#fd-facilityList').css('margin-top', '-16px');
        $('#fd-stationList').css('margin-top', '-16px');
    };

    facilitiesDialog.sortFacilitiesFlat = function () {
        <%-- Sort facility list. --%>
        var items = $('#fd-facilityList').children('.fd-listitem-facility').sort(function(a, b) {
            var textA = a.attributes['data-text'].value;
            var textB = b.attributes['data-text'].value;
            return textA.toLowerCase() > textB.toLowerCase() ? 1 : -1;
        });
        $('#fd-facilityList').append(items);

        <%-- Sort station list. --%>
        var items = $('#fd-stationList').children('.fd-listitem-station').sort(function(a, b) {
            var textA = a.attributes['data-text'].value;
            var textB = b.attributes['data-text'].value;
            return textA.toLowerCase() > textB.toLowerCase() ? 1 : -1;
        });
        $('#fd-stationList').append(items);

        <%-- We're showing a flat list, so we need to hide all VISN headers. --%>
        $('#fd-facilitiesContainer .fd-listitem-visn').each(function() {
            $(this).hide();
        });

        <%-- Since we're not showing VISN headers we need to get rid of the top margin adjustment. --%>
        $('#fd-facilityList').css('margin-top', '0px');
        $('#fd-stationList').css('margin-top', '0px');
    };

    facilitiesDialog.storeState = function () {
        var state = [];
        
        $('#fd-visnList input[type=checkbox]').each(function() {
            state.push($(this).prop('id') + ':' + ($(this).is(':checked') ? '1' : '0'));
        });
        
        $('#fd-facilityList input[type=checkbox]').each(function() {
            state.push($(this).prop('id') + ':' + ($(this).is(':checked') ? '1' : '0'));
        });
        
        $('#fd-stationList input[type=checkbox]').each(function() {
            state.push($(this).prop('id') + ':' + ($(this).is(':checked') ? '1' : '0'));
        });
        
        state.push('fd-checkbox-includeUnknownVisn' + ':' + ($('#fd-checkbox-includeUnknownVisn').is(':checked') ? '1' : '0'));
        
        state.push('fd-checkbox-aggregateAtFacilityLevel' + ':' + ($('#fd-checkbox-aggregateAtFacilityLevel').is(':checked') ? '1' : '0'));
        
        sessionStorage.setItem('filterDialogState', state.toString());
    };

</script>