<%--
    Document   : facilitiesFilterAjaxResults
    Created on : May 18, 2016
    Author     : Irakli Kakushadze
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<style>

.fd-a {
    position: relative;
    float: right;
}

.fd-checkbox-facility{}

.fd-checkbox-station{}

.fd-label {
    font-weight: normal;
}

.fd-div-checkbox {
    white-space: nowrap;
}

.fd-div-checkbox-indented {
    margin-left: 25px;
    white-space: nowrap;
}

.fd-label-visn {
    font-size: large;
    font-weight: bold;
    margin-left: 100px;
}

.fd-list {
	border: 1px solid gray;
	height: 436px;
    overflow-x: auto;
	overflow-y: auto;
    padding-left: 3px;
}

.fd-listitem-facility {}

.fd-listitem-station {}

.fd-listitem-visn {
    margin-top: 18px;
}

</style>

<table>

    <tr>
        <td>
            <b>Show VISNs:</b>
            <a class="fd-a" href="#" data-container="fd-visnList" data-select="" style="margin: 0 20px 0 10px;">Unselect all</a>
            <a class="fd-a" href="#" data-container="fd-visnList" data-select="true">Select all</a>
        </td>
        <td>
            <b>Show facilities:</b>
            <a class="fd-a" href="#" data-container="fd-facilityList" data-select="" style="margin: 0 50px 0 10px;">Unselect all</a>
            <a class="fd-a" href="#" data-container="fd-facilityList" data-select="true">Select all</a>
        </td>
        <td>
            <b>Your selection:</b>
            <a class="fd-a" href="#" data-container="fd-stationList" data-select="" style="margin: 0 0 0 10px;">Unselect all</a>
            <a class="fd-a" href="#" data-container="fd-stationList" data-select="true">Select all</a>
        </td>
    </tr>

    <tr>
        <td>
            <div id="fd-visnList" class="fd-list" style="margin-right: 20px; width: 322px;">
                <c:forEach var="visn" items="${visns}">
                    <div class="fd-div-checkbox">
                        <input type="checkbox" id="v<c:out value="${visn.id}"/>" checked="checked"/>
                        <label class="fd-label" for="v<c:out value="${visn.id}"/>"><c:out value="${visn.visnName}"/></label>
                        <br>
                    </div>
                </c:forEach>
            </div>
        </td>
        <td>
            <c:set var="visnId" value=""/>
            <c:set var="groupedOrder" value="0"/>
            <div class="fd-list" style="margin-right: 50px; width: 310px;">
                <div id="fd-facilityList" style="margin-top: -16px;">
                    <%--<c:forEach var="facility" items="${facilities}" varStatus="fStatus">
                        <c:if test="${facility.visnId ne visnId}">
                            <c:set var="visnId" value="${facility.visnId}"/>
                            <c:set var="groupedOrder" value="${groupedOrder + 1}"/>
                            <div class="fd-listitem-visn" data-groupedOrder="${10000 + groupedOrder}" data-visnId="${visnId}">
                                <label class="fd-label-visn">
                                    <c:choose>
                                        <c:when test="${empty visnId}">
                                            Unknown VISN
                                        </c:when>
                                        <c:otherwise>
                                            VISN ${visnId}
                                        </c:otherwise>
                                    </c:choose>
                                </label>
                            </div>
                        </c:if>
                        <c:set var="groupedOrder" value="${groupedOrder + 1}"/>
                        <div class="fd-div-checkbox fd-listitem-facility" data-groupedOrder="${10000 + groupedOrder}" data-text="${facility.facilityName}">
                            <input checked="checked" class="fd-checkbox-facility" data-facilityName="${facility.facilityName}" data-visnId="${facility.visnId}" id="f${facility.facilityStation}" type="checkbox"/>
                            <label class="fd-label" for="f${facility.facilityStation}">${facility.facilityName}</label>
                            <br>
                        </div>
                    </c:forEach>--%>
                </div>
            </div>
        </td>
        <td>
            <c:set var="visnId" value=""/>
            <c:set var="groupedOrder" value="0"/>
            <div class="fd-list" style="width: 310px;">
                <div id="fd-stationList" style="margin-top: -16px;">
                    <%--<c:forEach var="facility" items="${facilities}" varStatus="sStatus">
                        <c:if test="${facility.visnId ne visnId}">
                            <c:set var="visnId" value="${facility.visnId}"/>
                            <c:set var="groupedOrder" value="${groupedOrder + 1}"/>
                            <div class="fd-listitem-visn" data-groupedOrder="${10000 + groupedOrder}" data-visnId="${visnId}">
                                <label class="fd-label-visn">
                                    <c:choose>
                                        <c:when test="${empty visnId}">
                                            Unknown VISN
                                        </c:when>
                                        <c:otherwise>
                                            VISN ${visnId}
                                        </c:otherwise>
                                    </c:choose>
                                </label>
                            </div>
                        </c:if>
                        <c:set var="groupedOrder" value="${groupedOrder + 1}"/>
                        <div class="fd-div-checkbox fd-listitem-station" data-groupedOrder="${10000 + groupedOrder}" data-text="${facility.facilityName}">
                            <input checked="checked" class="fd-checkbox-facility" data-facilityName="${facility.facilityName}" data-facilityStation="${facility.facilityStation}" data-stationNumber="${facility.facilityStation}" data-visnId="${facility.visnId}" id="s${facility.facilityStation}" type="checkbox"/>
                            <label class="fd-label" for="s${facility.facilityStation}">${facility.facilityName}</label>
                            <br>
                            <c:forEach var="station" items="${stations}" varStatus="sStatus">
                                <c:if test="${fn:substring(station.facilityStation, 0, 3) eq facility.facilityStation}">
                                    <div class="fd-div-checkbox-indented">
                                        <input checked="checked" class="fd-checkbox-station" data-facilityName="${station.facilityName}" data-facilityStation="${facility.facilityStation}" data-stationNumber="${station.facilityStation}" data-visnId="${station.visnId}" id="s${station.facilityStation}" type="checkbox"/>
                                        <label class="fd-label" for="s${station.facilityStation}">${station.facilityName}</label>
                                        <br>
                                    </div>
                                </c:if>
                            </c:forEach>
                        </div>
                    </c:forEach>--%>
                </div>
            </div>
        </td>
    </tr>

</table>

<script>

    $(document).ready(function () {
        setTimeout(function() {
            var facilities = [];
            var stations = [];
            <c:set var="bad" value="'" />
            <c:set var="good" value="//'" />
            <c:forEach var="facility" items="${facilities}">facilities.push({facilityStation:'<c:out value="${facility.facilityStation}"/>', facilityName:'<c:out value="${fn:replace(facility.facilityName, bad, good)}"/>', visnId:'<c:out value="${facility.visnId}"/>'});
            </c:forEach>
            <c:forEach var="station" items="${stations}">stations.push({facilityStation:'<c:out value="${station.facilityStation}"/>', facilityName:'<c:out value="${fn:replace(station.facilityName, bad, good)}"/>', visnId:'<c:out value="${station.visnId}"/>'});
            </c:forEach>

            html = '';
            var visnId = '';
            var groupedOrder = 0;

            for (var i = 0; i < facilities.length; i++) {
                var facility = facilities[i];
                if (facility.visnId !== visnId) {
                    visnId = facility.visnId;
                    groupedOrder++;
                    html += '<div class="fd-listitem-visn" data-groupedOrder="' + (10000 + groupedOrder) + '" data-visnId="' + visnId + '">';
                    html += '<label class="fd-label-visn">';
                    html += (visnId === '' ? 'Unknown VISN' : 'VISN ' + visnId);
                    html += '</label>';
                    html += '</div>';
                }

                groupedOrder++;
                html += '<div class="fd-div-checkbox fd-listitem-facility" data-groupedOrder="' + (10000 + groupedOrder) + '" data-text="' + facility.facilityName + '">';
                html += '<input checked="checked" class="fd-checkbox-facility" data-facilityName="' + facility.facilityName + '"';
                html += ' data-visnId="' + facility.visnId + '" id="f' + facility.facilityStation + '" type="checkbox"/>';
                html += '<label class="fd-label" for="f' + facility.facilityStation + '">' + facility.facilityName + ' (' + facility.facilityStation + ')</label>';
                html += '<br>';
                html += '</div>';
            }

            $('#fd-facilityList').html(html);

            html = '';
            visnId = '';
            groupedOrder = 0;
            for (var i = 0; i < facilities.length; i++) {
                var facility = facilities[i];
                if (facility.visnId !== visnId) {
                    visnId = facility.visnId;
                    groupedOrder++;
                    html += '<div class="fd-listitem-visn" data-groupedOrder="' + (10000 + groupedOrder) + '" data-visnId="' + visnId + '">';
                    html += '<label class="fd-label-visn">';
                    html += (visnId === '' ? 'Unknown VISN' : 'VISN ' + visnId);
                    html += '</label>';
                    html += '</div>';
                }

                groupedOrder++;
                html += '<div class="fd-div-checkbox fd-listitem-station" data-groupedOrder="' + (10000 + groupedOrder) + '" data-text="' + facility.facilityName + '">';
                html += '<input checked="checked" class="fd-checkbox-facility" data-facilityName="' + facility.facilityName + '" data-facilityStation="' + facility.facilityStation + '"';
                html += ' data-stationNumber="' + facility.facilityStation + '" data-visnId="' + facility.visnId + '" id="s' + facility.facilityStation + '" type="checkbox"/>';
                html += '<label class="fd-label" for="s' + facility.facilityStation + '">' + facility.facilityName + ' (' + facility.facilityStation + ')</label>';
                html += '<br>';
                for (var j = 0; j < stations.length; j++) {
                    var station = stations[j];
                    if (station.facilityStation.toString().substr(0, 3) === facility.facilityStation) {
                        html += '<div class="fd-div-checkbox-indented">';
                        html += '<input checked="checked" class="fd-checkbox-station" data-facilityName="' + station.facilityName + '" data-facilityStation="' + facility.facilityStation + '"';
                        html += ' data-stationNumber="' + station.facilityStation + '" data-visnId="' + station.visnId + '" id="s' + station.facilityStation + '" type="checkbox"/>';
                        html += '<label class="fd-label" for="s' + station.facilityStation + '">' + station.facilityName + ' (' + station.facilityStation + ')</label>';
                        html += '<br>';
                        html += '</div>';
                    }
                }
                html += '</div>';
            }

            $('#fd-stationList').html(html);

            if ($('#fd-selectedFacilities').children(':first').val() !== 'ALL') {
                <%-- Default facility is selected --%>
                var selectedStation = $('input[name="stationNumbers"]').val().toString();
                var selectedFacility = '';
                var selectedVisn = '';
                $('#fd-stationList input[type=checkbox]').each(function() {
                    if ($(this).prop('id') === 's' + selectedStation) {
                        selectedFacility = $(this).closest('.fd-listitem-station').children(':first').attr('data-facilityStation');
                        selectedVisn = $(this).closest('.fd-listitem-station').children(':first').attr('data-visnId');
                        $(this).prop('checked', true);
                    } else {
                        $(this).prop('checked', false);
                    }
                });

                $('#fd-visnList input[type=checkbox]').each(function() {
                    $(this).prop('checked', $(this).prop('id') === 'v' + selectedVisn);
                });

                $('#fd-facilityList input[type=checkbox]').each(function() {
                    $(this).prop('checked', $(this).prop('id') === 'f' + selectedFacility);
                });
            }
            facilitiesDialog.updateCheckboxes(true);
            $('#fd-facilitiesDialog').dialog('open');
        }, 400);
    });
    
    $('.fd-a').on('click', function() {
        var containerId = $(this).attr('data-container');
        var checked = $(this).attr('data-select');
        $('#' + containerId + ' input[type=checkbox]').each(function() {
            $(this).prop('checked', checked);
        });
        facilitiesDialog.updateCheckboxes(false);
    });

    $('#fd-facilitiesContainer').on('click', 'input', function() {
        var aggregate = $('#fd-checkbox-aggregateAtFacilityLevel').is(':checked');
        if (aggregate) {
            $('#fd-stationList .fd-checkbox-facility').each(function() {
                var checked = $(this).is(':checked');
                $('.fd-checkbox-station', $(this).parent()).each(function () {
                    $(this).prop('checked', checked);
                });
            });
        }
        
        facilitiesDialog.updateCheckboxes(false);
    });

    facilitiesDialog.updateCheckboxes = function (loading) {
        <%-- Update facility checkboxes --%>
        $('#fd-facilityList input[type=checkbox]').each(function() {
            var vid = 'v' + $(this).attr('data-visnId');
            var visible = $('#' + vid).is(':checked');
            $(this).parent().toggle(visible);
        });

        <%-- Update facility VISN headers --%>
        $('#fd-facilityList .fd-listitem-visn').each(function() {
            if ($('#fd-groupByVisn').is(':checked')) {
                var vid = 'v' + $(this).attr('data-visnId');
                $('#' + vid).is(':checked') ? $(this).show() : $(this).hide();
            } else {
                $(this).hide();
            }
        });

        <%-- Update station checkboxes --%>
        visnHeadersToShow = [];
        $('#fd-stationList input[type=checkbox]').each(function() {
            var fid = 'f' + $(this).attr('data-facilityStation');
            var visible = ($('#' + fid).is(':visible') || loading) && $('#' + fid).is(':checked');
            $(this).next().css({'font-weight': $(this).is(':checked') ? 'bold' : 'normal'});
            $(this).parent().toggle(visible);
            if (visible) {
                var visnId = $(this).attr('data-visnId');
                visnHeadersToShow[visnId] = 'show';
            }
        });

        <%-- Update station VISN headers --%>
        $('#fd-stationList .fd-listitem-visn').each(function() {
            if ($('#fd-groupByVisn').is(':checked')) {
                var visnId = $(this).attr('data-visnId');
                visnHeadersToShow[visnId] === 'show' ? $(this).show() : $(this).hide();
            } else {
                $(this).hide();
            }
        });
    };

</script>