<%--
    Document   : Received eHeakth Exchange Document Summary Report
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@page import="java.util.*" %>

<f:mainTemplate headerText="Received eHealth Exchange Documents Summary Report">
    <script language="JavaScript">
        $(document).ready(function () {
            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            var reportTable;

            setProcessingForDataTable('reportTable', -14);

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                destroy: true,
                ajax: {
                    url: constructUrl("doSearch"),
                    dataSrc: function(json){
                        $('.dataTables_empty').remove();
                        return json.data;
                    },
                    error: function(o){
                        handleErrorsInDataTable('reportTable', o, 4);
                    }
                },
                info: false,
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                paging: false,
                processing: true,
                searching: false,
                serverSide: true,
                columnDefs: [
                    {className: "dt-head-center", targets: [0,1,2]},
                    {className: "dt-head-center dt-body-right", targets: [3]}
                ],
                scrollX:true,
               initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                "footerCallback": function ( row, data, start, end, display ) {
                    var api = this.api(), data;

                    // Update footer
                    $(api.column(3).footer() ).html(
                        api.column(3, {page:'current'}).data().sum()
                    );
                }
            });

            //datatable overrides
            $.fn.dataTable.ext.errMode = 'none';

            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            function constructUrl(methodName){
                var url= 'ReceivedNwHINDocumentSummaryReport.do_sec' +
                        '?' + methodName + '=true' +
                        '&startDate=' + $('#startDate').val()+
                        '&endDate=' + $('#endDate').val() +
                        '&userId=' + $('#userId').val() +
                        '&organization=' + $('#organization').val() +
                        '&organizationName=' + $('#orgName').val() +
                        '&facility=' + $('#facility').val() +
                        '&facilityName=' + $('#facilityName').val() +
                        '&patientTypes=' + $('#patientTypes').val()+
                        '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                        '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1];

                return url;
            }

            $('#searchButton').on('click', function () {
                var startDate = $('#startDate').val();
                var endDate = $('#endDate').val();

                var errorMessage = validateStartAndEndDate(startDate, endDate);

                if (errorMessage != '')
                {
                    //we have an error so show the error, and then don't send the ajax request
                    $('#errorMessage').html(errorMessage);
                    $('#errorMessage').show();

                    return false;
                } else {
                    //no error, let's make the call to populate the report
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                }
            });

            $('.exportButton').on('click', function() {
                window.location.href = constructUrl($(this).data('method'));
                return false;
            });

            $('#startDate,#endDate').on('change', function () {
                //if either date changes, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });
    </script>
    <div class="form-container">
        <form name="receivedNwHINDocumenSummaryReportForm" action="ReceivedNwHINDocumentSummaryReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="width-450 pad-top-10" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <div>
                    <label for="userId">User ID</label>
                    <input title="Enter User ID" id="userId" name="userId" type="text" maxlength="255" size="30" data-tooltip="<c:out value="${descriptors['genericUserId']}" />" />
                </div>
                <div>
                    <label
                        title="Query based on Patient Preferred Facility from the dropdown list"
                        for="facility">Patient Preferred Facility</label>
                    <select data-tooltip="<c:out value="${descriptors['patientPreferredFacilityFilter']}"/>" id="facility" name="facility" onchange = "document.getElementById('facilityName').value = this.options[this.selectedIndex].text;">
                        <option value="">ALL</option>
                        <c:forEach var="f" items="${facilities}">
                            <option value="<c:out value="${f.facilityStation}"/>"
                                    <c:choose>
                                        <c:when test="${f.facilityStation eq defaultUserFacility.facilityStation}">
                                            selected
                                        </c:when>
                                    </c:choose>>
                                <c:choose>
                                    <c:when test="${f.facilityName != ''}">
                                        <c:out value="${f.facilityName}"/>
                                    </c:when>
                                    <c:otherwise>
                                        <c:out value="${fn:split(f.facilityDns, '.')[0]}" />
                                    </c:otherwise>
                                </c:choose>
                                (<c:out value="${f.facilityStation}"/>)
                            </option>
                        </c:forEach>
                    </select>
                    <div>
                        <label
                            title="Query based on <c:out value="${organizationName}"/> Organization from the dropdown list"
                            for="organization"><c:out value="${organizationName}"/> Organization</label>
                        <select data-tooltip="<c:out value="${descriptors['disclosuresSummaryReportOrganizationField']}"/>" id="organization" name="organization" onchange = "document.getElementById('orgName').value = this.options[this.selectedIndex].text;">
                            <option value="external" selected>ALL</option>
                            <c:forEach var="r" items="${activeOrgs}">
                                <option value="%<c:out value="${r.orgOid}"/>">
                                    <c:out value="${r.orgName}"/>
                                </option>
                            </c:forEach>
                            <c:forEach var="r" items="${inactiveOrgs}">
                                <option value="%<c:out value="${r.orgOid}"/>">[INACTIVE] <c:out value="${r.orgName}"/></option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select data-tooltip="<c:out value="${descriptors['patientTypesField']}"/>" id="patientTypes" name="patientTypes">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <form>
            <input type="hidden" name="orgName" id="orgName" value="<c:out value="${orgName}"/>">
            <input type="hidden" name="facilityName" id="facilityName" value="<c:out value="${facilityName}"/>">
        </form>
        <div>
            <input name="search" title="Search" class="button" type="submit" value="Search" id="searchButton"/>
        </div>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5 pad-bottom-15">
        <a href="#"><button class="exportButton" data-method="exportToExcel" title="Export to Excel">Export to Excel</button></a>
    </div>
    <div id="divReportContent">
        <table id="reportTable" class="display" width=100% cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="organizationHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsSummaryReportOrganizationColumn']}" />"><c:out value="${organizationName}" /> Organization</span></th>
                    <th role="columnheader"><span id="facilityHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsSummaryReportVAFacilityColumn']}" />">Patient Preferred Facility</span></th>
                    <th role="columnheader"><span id="facilityNumberHeader" data-tooltip="<c:out value="${descriptors['patientPreferredFacilityStationIdColumn']}" />">Patient Preferred Facility Station ID</span></th>
                    <th role="columnheader"><span id="totalHeader" data-tooltip="<c:out value="${descriptors['receivedEHealthExchangeDocumentsSummaryReportTotalColumn']}" />" data-tooltip-position="left">Total</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <td role="gridcell" class="text-left footer-bold-pad-left-8">Total:</td>
                    <td role="gridcell"></td>
                    <td role="gridcell"></td>
                    <td role="gridcell" class="text-right footer-bold-pad-right-9"></td>
                </tr>
            </tfoot>
        </table>
        <div aria-live="polite" role="status" id="reportTable_info" class="dataTables_info hidden">Shows entries for Exchange</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
    </div>
    </div>
</f:mainTemplate>