<%--
    Document   : Patient Search
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<f:mainTemplate headerText="Patient Search Results">
    <div class="well">
        <c:choose>
            <c:when test="${!empty patients}">
                The search for patient returned multiple results. Please select a patient from the results.
            </c:when>
            <c:otherwise>
                The search for patient returned no results.
            </c:otherwise>
        </c:choose>
    </div>

    <c:choose>
        <c:when test="${!empty patients}">
            <div class="form-container">
                <c:choose>
                    <c:when test="${!empty patients}">
                        <form action="PatientSearchResults.do_sec" method="POST" onsubmit="return doSubmit(this)">
                            <fieldset>
                                <legend>Patient Search Results</legend>
                                <table class="ver-minimalist">
                                    <thead>
                                        <tr>
                                            <th scope="col">Select Patient</th>
                                            <th scope="col">Last Name</th>
                                            <th scope="col">First Name</th>
                                            <th scope="col">Middle Name</th>
                                            <th scope="col">SSN</th>
                                            <th scope="col">Date of Birth</th>
                                            <th scope="col">Gender</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <c:choose>
                                            <c:when test="${i.index % 2 == 0}">
                                                <c:set var="className" value="even" />
                                            </c:when>
                                            <c:otherwise>
                                                <c:set var="className" value="odd" />
                                            </c:otherwise>
                                        </c:choose>
                                        <c:forEach var="r" items="${patients}" varStatus="i">
                                            <tr class="<c:out value="${className}"/>">
                                                <td><input title="Choose to select patient" name="icn" value="<c:out value="${r.icn}"/>" type="radio" /></td>
                                                <td><c:out value="${r.lastName}"/></td>
                                                <td><c:out value="${r.firstName}"/></td>
                                                <td><c:out value="${r.middleInitial}"/></td>
                                                <td><c:out value="${r.ssn}"/></td>
                                                <td><fmt:formatDate pattern="MM/dd/yyyy" value="${r.dob}" /></td>
                                                <td><c:out value="${r.gender}"/></td>
                                            </tr>
                                        </c:forEach>
                                    </tbody>
                                </table>
                            </fieldset>
                            <div>
                                <input name="select" title="View Details" class="button" type="submit" value="View Details" />
                            </div>
                        </form>
                    </c:when>
                    <c:otherwise>
                        <div>No patients were found.</div>
                    </c:otherwise>
                </c:choose>
            </div>
        </c:when>
        <c:otherwise>
            <div>No patients were found.</div>
        </c:otherwise>
    </c:choose>
</f:mainTemplate>