<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<%
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
%>

<f:mainTemplate headerText="Patient Search">

    <c:if test="${not empty message}">
        <div class="vap-alert alert alert-success margin-bottom-15 pad-bottom-10 pad-top-10 pad-left-10">
            <c:out value="${message}" />
        </div>
    </c:if>
    <div class="well">
        Enter the Social Security number, last name, and first name of the patient for whom you are searching and click Search.
    </div>
    <cpp:errors />
    <div class="form-container">
        <form name="patientSearchForm" action="PatientSearch.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <legend>Search for a patient</legend>
                <div>
                    <label for="ssn">SSN <i><span style="font-weight:normal;">(#########)</span></i><img alt="Required field" src="res/star-icon_white_bg.png"/></label>
                    <input title="Enter SSN. required field. Enter numbers only no hyphens" id="ssn" name="ssn" type="text" maxlength="9" size="9"
                           data-tooltip="<c:out value="${descriptors['patientSearchSSNField']}" />"/> <i><span style="font-weight:normal;"> (Enter numbers only, no hyphens.)</span></i> &nbsp;
                </div>
                <div>
                    <label for="lastName">Last Name<img alt="Required field" src="res/star-icon_white_bg.png"/></label>
                    <input title="Enter Last Name. required field" id="lastName" name="lastName" type="text" maxlength="255" size="30"
                           data-tooltip="<c:out value="${descriptors['patientSearchLastNameField']}" />"/>
                </div>
                <div>
                    <label for="firstName">First Name<img alt="Required field" src="res/star-icon_white_bg.png"/></label>
                    <input title="Enter First Name required field" id="firstName" name="firstName" type="text" maxlength="255" size="30"
                           data-tooltip="<c:out value="${descriptors['patientSearchFirstNameField']}" />"/>
                </div>
            </fieldset>
            <div>
                <input name="search" title="Search" class="button" type="submit" value="Search" />
            </div>
        </form>
    </div>

</f:mainTemplate>