<%@page import="gov.va.nvap.web.user.UserHelper"%>
﻿<%--
    Deprecated as of VAP 2.6.0
    Document   : Patient Discovery Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib tagdir="/WEB-INF/tags/paginator" prefix="pg"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>

<%
    String userName = UserHelper.getUserName(request);
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<html lang="en">
    <head>
        <title>Veterans Authorization & Preferences Patient Discovery
            Audit Report Results</title>
            <%@include file="metaCommon.jsp"%>
        <script language="JavaScript">
            $(document).ready(function () {

            });
        </script>
    </head>
    <body>
        <jsp:include page="header.jsp">
            <jsp:param name="userName" value="<%=userName%>" />
        </jsp:include>
        <%@include file="patientLinkForm.jsp"%>
        <table border="0" cellpadding="0" cellspacing="0" width="100%"
               summary="table is used for layout purposes" id="main-content-table">
            <tbody>
                <tr>
                    <jsp:include page="leftMenu.jsp">
                        <jsp:param name="userName" value="<%=userName%>" />
                    </jsp:include>
                    <th scope="row" style="float: left; font-size: 0; height: 0;">VA Content</th>
                    <td id="content-va"><a name="content-area"></a> <!-- START: SITE NAME BAR -->
                        <p class="title-bar">
                            <!-- START: SITE NAME -->
                            Patient Discovery Audit Report
                            <!-- END: SITE NAME -->
                        </p> <cpp:errors /> <!-- END: SITE NAME BAR -->
                        <table border="0" cellpadding="0" cellspacing="0" width="100%"
                               summary="table is used for layout purposes">
                            <tbody>
                                <tr>
                                    <th scope="row" style="float: left; font-size: 0; height: 0;">Main Content</th>
                                    <td id="content-main">
                                        <table width="100%"
                                               summary="This table is used for layout purposes">
                                            <!-- START: PAGE TITLE AREA -->
                                            <!-- END: PAGE TITLE AREA -->
                                            <tr>
                                                <th scope="row" style="float: left; font-size: 0; height: 0;">Page Content</th>
                                                <td>
                                                    <!-- START: PAGE CONTENT -->
                                                    <table SUMMARY="This table is for formatting purposes only.">
                                                        <tbody>
                                                            <tr>
                                                                <th scope="row" style="float: left; font-size: 0; height: 0;">Export Buttons</th>
                                                                <td>
                                                                    <table class="ver-minimalist">
                                                                        <tbody>
                                                                            <tr>
                                                                        <div class="buttonrow">
                                                                            <th scope="row" style="border-bottom: none; float: right; font-size: 0; height: 0;">Button Row</th>
                                                                            <td style="float: left;">
                                                                                <form>
                                                                                    <input name="exportToExcel" alt="Export to Excel"
                                                                                           class="button" type="submit"
                                                                                           value="Export to Excel"
                                                                                           onclick="exportAlert();"/>
                                                                                    <input name="exportToCsv" alt="Export to CSV"
                                                                                           class="button" type="submit"
                                                                                           value="Export to CSV"
                                                                                           onclick="exportAlert();"/>
                                                                                </form>
                                                                            </td>
                                                                            <td></td>
                                                                            <td></td>
                                                                            <td></td>
                                                                            <td></td>
                                                                            <td></td>
                                                                        </div>
                                                            </tr>
                                                            <tr class="dateFilters" style="float: left; white-space: nowrap;">
                                                                <th scope="row" style="border-bottom: none; float: left; font-size: 0; height: 0;">Filters</th>
                                                                <td class="datePadding">Start Date</td>
                                                                <td><c:choose>
                                                                        <c:when
                                                                            test="${!empty patientDiscoveryQueryStartDate}">
                                                                            <fmt:formatDate pattern="MM/dd/yyyy"
                                                                                            value="${patientDiscoveryQueryStartDate}" />
                                                                        </c:when>
                                                                        <c:otherwise>
                                                                            N/A
                                                                        </c:otherwise>
                                                                    </c:choose>
                                                                </td>
                                                                <td class="datePadding">End Date</td>
                                                                <td><c:choose>
                                                                        <c:when
                                                                            test="${!empty patientDiscoveryQueryEndDate}">
                                                                            <fmt:formatDate pattern="MM/dd/yyyy"
                                                                                            value="${patientDiscoveryQueryEndDate}" />
                                                                        </c:when>
                                                                        <c:otherwise>
                                                                            N/A
                                                                        </c:otherwise>
                                                                    </c:choose>
                                                                </td>
                                                                <td class="datePadding">MPI Results</td>
                                                                <td><c:choose>
                                                                        <c:when test="${!empty patientDiscoveryMPIResults}">
                                                                            <c:out value="${patientDiscoveryMPIResults}" />
                                                                        </c:when>
                                                                        <c:otherwise>
                                                                            N/A
                                                                        </c:otherwise>
                                                                    </c:choose>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                    <hr>
                                                    <c:choose>
                                                        <c:when test="${!empty patientDiscoveryResults}">
                                                            <br />
                                                            <pg:paginator paginator="${paginator}"
                                                                          uri="PatientDiscoveryReportResults.do_sec"
                                                                          results="${patientDiscoveryResults}" />
                                                            <table width="100%">
                                                                <thead>
                                                                    <tr class="hor-minimalist-c">
                                                                        <th scope="col"><span id="dateReceivedHeader" data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}" />">Date Received (CT)</span></th>
                                                                        <th scope="col"><span id="ssnHeader" data-tooltip="<c:out value="${descriptors['ssnColumn']}" />">SSN</span></th>
                                                                        <th scope="col"><span id="lastNameHeader" data-tooltip="<c:out value="${descriptors['lastNameColumn']}" />">Patient Last Name</span></th>
                                                                        <th scope="col"><span id="firstNameHeader" data-tooltip="<c:out value="${descriptors['firstNameColumn']}" />">Patient First Name</span></th>
                                                                        <th scope="col"><span id="middleNameHeader" data-tooltip="<c:out value="${descriptors['middleNameColumn']}" />">Patient Middle Name</span></th>
                                                                        <th scope="col"><span id="senderHeader" data-tooltip="<c:out value="${descriptors['sendingOrganizationColumn']}" />">Sender</span></th>
                                                                        <th scope="col"><span id="pouHeader" data-tooltip="<c:out value="${descriptors['purposeOfUseColumn']}" />">Purpose of Use</span></th>
                                                                        <th scope="col"><span id="receiverHeader" data-tooltip="<c:out value="${descriptors['receivingOrganizationColumn']}" />">Receiver</span></th>
                                                                        <th scope="col"><span id="messageHeader" data-tooltip="<c:out value="${descriptors['messageColumn']}" />">Message</span></th>
                                                                        <th scope="col"><span id="explanationHeader" data-tooltip="<c:out value="${descriptors['explanationOfFailureColumn']}" />">Explanation of Failure</span></th>
                                                                        <th scope="col"><span id="detailsHeader" data-tooltip="<c:out value="${descriptors['detailsColumn']}" />" data-tooltip-position="left">Details</span></th>
                                                                    </tr>
                                                                    <tr class="hor-minimalist-c">
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=auditTime&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=auditTime&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientSSN&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientSSN&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientLastName&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientLastName&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientGivenName&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientGivenName&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientMiddleName&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=patientMiddleName&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=organizationName&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=organizationName&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=purposeForUse&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=purposeForUse&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=remoteOrganizationName&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=remoteOrganizationName&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=action&patientDiscoverySortDirection=ASC"><br><img alt="sort this column in ascending order" src="res/sort-ascending.jpg" border="0"/></a><a> - </a><a href="PatientDiscoveryReportResults.do_sec?patientDiscoverySortValue=action&patientDiscoverySortDirection=DESC"><img alt="sort this column in descending order" src="res/sort-descending.jpg" border="0"/></a></td>
                                                                        <td></td>
                                                                        <td></td>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <c:set var="displayedMessages" value="0" scope="page" />

                                                                    <pg:forEach var="r"
                                                                                items="${patientDiscoveryResults}" varStatus="i"
                                                                                paginator="${paginator}">
                                                                        <c:if test="${(i.count <= paginator.recordsPerPage || paginator.recordsPerPage < 0)&& r.ssnMasked != ''}">
                                                                            <tr class="hor-minimalist-b">
                                                                                <td><fmt:formatDate
                                                                                        pattern="MM/dd/yyyy hh:mm a"
                                                                                        value="${r.auditTime}" />
                                                                                </td>
                                                                                <td nowrap>
                                                                                    <cpp:patientLink ssn="${r.ssn}" firstName="${r.firstName}" lastName="${r.lastName}" ssnMasked="${r.ssnMasked}" />
                                                                                </td>
                                                                                <td><c:out value="${r.lastName}" /></td>
                                                                                <td><c:out value="${r.firstName}" /></td>
                                                                                <td><c:out value="${r.middleName}" /></td>
                                                                                <td style="word-wrap: break-word;"><c:out value="${r.facility}" /></td> <!-- sender -->
                                                                                <td style="word-wrap: break-word;"><c:out value="${r.purposeOfUse}" /></td>
                                                                                <td style="word-wrap: break-word;"><c:out value="${r.remoteFacility}" /></td> <!-- receiver -->
                                                                                <td style="word-wrap: break-word;"><c:out value="${r.message}" /></td>
                                                                                <td style="word-wrap: break-word;"><c:out value="${r.failureExplanation}" /></td>
                                                                                <td class="vap-break-word"><c:out value="${r.details}" /></td>
                                                                            </tr>
                                                                            <c:set var="displayedMessages" value="${displayedMessages + 1}" scope="page"/>
                                                                        </c:if>
                                                                    </pg:forEach>
                                                                    <c:if test="${paginator.recordsPerPage == testPatientMessages && displayedMessages == 0}">
                                                                        All records were excluded from this page.
                                                                    </c:if>
                                                                </tbody>
                                                            </table>
                                                            <pg:paginator paginator="${paginator}"
                                                                          uri="PatientDiscoveryReportResults.do_sec"
                                                                          results="${patientDiscoveryResults}" />
                                                        </c:when>
                                                        <c:otherwise>
                                                            No records were found.
                                                        </c:otherwise>
                                                    </c:choose>
                                                </td>
                                            </tr>
                            </tbody>
                        </table> <!-- THE BODY CONTENT END -->
                        <div style="width: 95%;" class="pad-left-10">
                            <table class="ver-minimalist">
                                <tbody>
                                <colgroup>
                                    <col style="width:20%">
                                    <col style="width:30%">
                                    <col style="width:20%">
                                    <col style="width:30%">
                                </colgroup>
                                <tr>
                                    <th scope="row" style="border-bottom: none; color: #669; font-size: inherit; font-weight: normal; padding: 12px 2px 0; text-align: inherit;" class="vap-inline-th-ie-only">
                                        <b>Unique<c:if test="${patientTypes eq 3}"> real</c:if> patients:</b>
                                        </th>
                                        <td>
                                        <c:choose><c:when test="${patientTypes eq 2}"><c:out value="${uniqueTestPatients}" /></c:when><c:otherwise><c:out value="${uniqueRealPatients}" /></c:otherwise></c:choose>
                                            </td>
                                    <c:if test="${patientTypes eq 3}">
                                        <td>
                                            <b>Unique test patients:</b>
                                        </td>
                                        <td>
                                            <c:out value="${uniqueTestPatients}" />
                                        </td>
                                    </c:if>
                                </tr>
                                <tr>
                                    <th scope="row" style="border-bottom: none; color: #669; font-size: inherit; font-weight: normal; padding: 12px 2px 0;">
                                        <b>Total messages<c:if test="${patientTypes eq 3}"> for real patients</c:if>:</b>
                                        </th>
                                        <td>
                                        <c:choose><c:when test="${patientTypes eq 2}"><c:out value="${testPatientMessages}" /></c:when><c:otherwise><c:out value="${realPatientMessages}" /></c:otherwise></c:choose>
                                            </td>
                                    <c:if test="${patientTypes eq 3}">
                                        <td>
                                            <b>Total messages for test patients:</b>
                                        </td>
                                        <td>
                                            <c:out value="${testPatientMessages}" />
                                        </td>
                                    </c:if>
                                </tr>
                                <tr>
                                    <th scope="row" style="border-bottom: none; color: #669; font-size: inherit; font-weight: normal; padding: 12px 2px 0;">
                                        <b>Match failures<c:if test="${patientTypes eq 3}"> for real patients</c:if>:</b>
                                        </th>
                                        <td>
                                        <c:choose><c:when test="${patientTypes eq 2}"><c:out value="${testPatientFails}" /></c:when><c:otherwise><c:out value="${realPatientFails}" /></c:otherwise></c:choose>
                                            </td>
                                    <c:if test="${patientTypes eq 3}">
                                        <td>
                                            <b>Match failures for test patients:</b>
                                        </td>
                                        <td>
                                            <c:out value="${testPatientFails}" />
                                        </td>
                                    </c:if>
                                </tr>
                                <tr>
                                    <th scope="row" style="border-bottom: none; color: #669; font-size: inherit; font-weight: normal; padding: 12px 2px 0;">
                                        <b>Matches found<c:if test="${patientTypes eq 3}"> for real patients</c:if>:</b>
                                        </th>
                                        <td>
                                        <c:choose><c:when test="${patientTypes eq 2}"><c:out value="${testPatientMatches}" /></c:when><c:otherwise><c:out value="${realPatientMatches}" /></c:otherwise></c:choose>
                                            </td>
                                    <c:if test="${patientTypes eq 3}">
                                        <td>
                                            <b>Matches found for test patients:</b>
                                        </td>
                                        <td>
                                            <c:out value="${testPatientMatches}" />
                                        </td>
                                    </c:if>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </td>
                </tr>
        </table>
    </td>
</tr>
</tbody>
</table> <!-- START: PAGE FOOTER --> <%@include file="footer.jsp"%>
<!-- END: PAGE FOOTER --> <!-- END: PAGE CONTENT -->
</td>
</tr>
</tbody>
</table>
</body>
<%-- <%@include file="slideoutWarning.jspf" %> --%>
</html>