<%--
    Document   : Patient Discovery Report
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
    Edited By: Zachary Tubb
--%>

<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>

<f:mainTemplate headerText="Patient Discovery Audit Report">
    <script type="text/javascript">
        validateSSNsBeforeExport = true; //setting the global variable to true so the ssns are validated prior to export

        function validateSsns() {
            var retVal = false;
            var sansWhiteSpace = $('#ssn').val().replace(/ /g, '');

            if (sansWhiteSpace === null) {
                $('#errorMessage').hide();
                retVal = true;
            } else {
                if (/^\d{9}(,\d{9})*$/.test(sansWhiteSpace) || sansWhiteSpace === '') {
                    $('#ssn').val(sansWhiteSpace);
                    $('#errorMessage').hide();
                    retVal = true;
                } else {
                    $('#errorMessage').html('Invalid SSN');
                    $('#errorMessage').show();
                }
            }
            return retVal;
        };

        $(document).ready(function () {
            $("#startDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#endDate").datepicker("option", "minDate", selectedDate);
                }
            });

            $("#endDate").datepicker({
                maxDate: 0,
                dateFormat: 'mm/dd/yy',
                onClose: function (selectedDate) {
                    $("#startDate").datepicker("option", "maxDate", selectedDate);
                }
            });

            $.fn.dataTable.ext.errMode = 'none';

            setProcessingForDataTable('reportTable');

            reportTable = $('#reportTable').DataTable({
                deferLoading: 0,
                ajax:{
                    url:constructUrl("doSearch"),
                    dataSrc: function(json){

                        //Set summary information at bottom of page with callback data
                        $('#realPatientMessages').html(json.realPatientMessages);
                        $('#realPatientFails').html(json.realPatientFails);
                        $('#realPatientMatches').html(json.realPatientMatches);
                        $('#testPatientMessages').html(json.testPatientMessages);
                        $('#testPatientFails').html(json.testPatientFails);
                        $('#testPatientMatches').html(json.testPatientMatches);
                        $('#uniqueRealPatients').html(json.uniqueRealPatients);
                        $('#uniqueTestPatients').html(json.uniqueTestPatients);

                        configurePatientInformationDivs();

                        $('.dataTables_empty').remove();

                        //make sure to return main data
                        return json.data;
                    },
                    error: function(o){
                        handleErrorsInDataTable('reportTable', o, 11);
                    }
                },
                destroy: true,
                serverSide: true,
                processing: true,
                searching: false,
                paging: true,
                info:true,
                dom: 'liptipr',
                lengthMenu: [ 10, 25, 50, 100, 250, 500 ],
                pageLength: 25,
                order: [[0, "desc"]],
                language: {
                    emptyTable: "No records found",
                    loadingRecords: ""
                },
                scrollX:true,
                initComplete: function(){
                    // Enable THEAD scroll bars
                    $('.dataTables_scrollHead').css('overflow', 'auto');

                    // Sync THEAD scrolling with TBODY
                    $('.dataTables_scrollHead').on('scroll', function () {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                },
                columnDefs: [
                    {orderable: false, targets: [9, 10]},
                    {
                        targets: 1,
                        data: null,
                        render: function(data,type,full,meta){
                            return '<a href="#/" onclick="linkToPatient(\''+data[11]+'\', \''+data[2]+'\', \''+data[3]+'\');">'+data[1]+'</a>';
                        }
                    },
                    {className: "vap-break-word vap-col-min-400 dt-head-center", targets: 10},
                    {className: "vap-break-word vap-col-min-80 dt-head-center", targets: [2,8]},
                    {className: "vap-col-min-80 dt-head-center", targets: 1},
                    {className: "vap-col-min-130 dt-head-center", targets: 0},
                    {className: "dt-head-center", targets: [3,4,5,6,7,9]}
                ]
            });

            function configurePatientInformationDivs(){
                if($('#patientTypes').val() === "1"){
                    $('#realPatientInfo').show();
                    $('#testPatientInfo').hide();
                } else if ($('#patientTypes').val() === "2") {
                    $('#realPatientInfo').hide();
                    $('#testPatientInfo').show();
                } else {
                    $('#realPatientInfo').show();
                    $('#testPatientInfo').show();
                }
            }


            reportTable.on('draw', function () {
                addAriaToDataTable('reportTable', reportTable);
            });

            $('#searchButton').on('click', function () {
                // Validate data before submitting to the server.
                if (validateSsns()){
                    var startDate = $('#startDate').val();
                    var endDate = $('#endDate').val();

                    var errorMessage = validateStartAndEndDate(startDate, endDate);

                    if (errorMessage != '')
                    {
                        //we have an error so show the error, and then don't send the ajax request
                        $('#errorMessage').html(errorMessage);
                        $('#errorMessage').show();

                        return false;
                    } else {
                        //no error, let's make the call to populate the report
                        $('#results').show();
                        reportTable.ajax.url(constructUrl('doSearch')).load();
                    }
                }
            });

            setFocus(patientDiscoveryReportForm.ssn);

            $('#startDate,#endDate,#ssn').on('change', function () {
                //if either date changes or ssn, hide the error message if its not already hidden
                $('#errorMessage').hide();
            });

            $('#results').hide();
        });

        constructUrl = function(methodName){
            var url = 'PatientDiscoveryReport.do_sec?' + methodName +'=true' +
                    '&ssn=' + $('#ssn').val() +
                    '&lastName=' + $('#lastName').val() +
                    '&firstName=' + $('#firstName').val() +
                    '&userId=' + $('#userId').val() +
                    '&startDate=' + $('#startDate').val() +
                    '&endDate=' + $('#endDate').val() +
                    '&organization=' + $('#organization').val() +
                    '&organizationName=' + $('#organizationName').val() +
                    '&mpiMatch=' + $('#mpiMatch').val() +
                    '&patientTypes=' + $('#patientTypes').val() +
                    '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                    '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1];

            if (methodName === 'exportToCsv' || methodName === 'exportToExcel') {
                url = url + '&totalRows=' + reportTable.page.info().recordsTotal;
            }
            return url;
        };
    </script>

    <div class="well">
        Fill in the fields below to narrow your search. All dates will be included if Start Date and End Date are left blank.
    </div>

    <div class="form-container">
        <form name="patientDiscoveryReportForm" action="PatientDiscoveryReport.do_sec" method="POST" onsubmit="return doSubmit(this)">
            <fieldset>
                <input type="hidden" id="organizationName" name="organizationName">
                <legend>Search Details</legend>
                <div id="errorMessage" class="bg-warning pad-15" style="display: none;"></div>
                <div class="pad-top-10">
                    <label for="ssn">SSN(s):</label>
                    <input title="One or multiple SSNs, with no hyphens, separated by comma" id="ssn" name="ssn" type="text" size="30" onblur="validateSsns();" onfocus="$('#ssnError').hide();"
                           data-tooltip="<c:out value="${descriptors['patientDiscoveryAuditReportSSNField']}"/>"/>
                    <i><span style="font-weight:normal;"> One or multiple SSNs, with no hyphens, separated by comma </span></i> &nbsp;
                </div>
                <div>
                    <label for="lastName">Last Name</label>
                    <input title="Enter Last Name" id="lastName" name="lastName" type="text" maxlength="255" size="30"
                           data-tooltip="<c:out value="${descriptors['lastNameField']}"/>"/>
                </div>
                <div>
                    <label for="firstName">First Name</label>
                    <input title="Enter First Name" id="firstName" name="firstName" type="text" maxlength="255" size="30"
                           data-tooltip="<c:out value="${descriptors['firstNameField']}"/>"/>
                </div>
                <div>
                    <label for="userId">User ID</label>
                    <input title="Enter User ID" id="userId" name="userId" type="text" maxlength="255" size="30"
                           data-tooltip="<c:out value="${descriptors['genericUserId']}"/>"/>
                </div>
                <div class="width-450" id="dateTip" data-tooltip="<c:out value="${descriptors['startDateEndDateField']}"/>">
                    <div>
                        <label for="startDate">Start Date</label>
                        <date:date id="startDate" name="startDate" value="${startDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                    <div>
                        <label for="endDate">End Date</label>
                        <date:date id="endDate" name="endDate" value="${endDateDefault}"/> <i>mm/dd/yyyy</i>
                    </div>
                </div>
                <div>
                    <label title="Query based on MPI results from the dropdown list" for="mpiMatch">MPI Results</label>
                    <select id="mpiMatch" name="mpiMatch" data-tooltip="<c:out value="${descriptors['mpiResultsField']}"/>">
                        <option value="ALL">ALL</option>
                        <option value="MATCH FOUND">Match Found</option>
                        <option value="MATCH FAILED">Match Failed</option>
                    </select>
                </div>
                <div>
                    <label title="Query based on <c:out value="${organizationName}"/> Organization from the dropdown list" for="organization"><c:out value="${organizationName}"/> Organization</label>
                    <select id="organization" name="organization" onchange="document.getElementById('organizationName').value = this.options[this.selectedIndex].text;"
                            data-tooltip="<c:out value="${descriptors['eHealthExchangeOrganizationField']}"/>">
                        <option value="">ALL</option>
                        <c:forEach var="r" items="${activeOrgs}">
                            <option value="%<c:out value="${r.orgOid}"/>"><c:out value="${r.orgName}"/></option>
                        </c:forEach>
                        <c:forEach var="r" items="${inactiveOrgs}">
                            <option value="%<c:out value="${r.orgOid}"/>">[INACTIVE] <c:out value="${r.orgName}"/></option>
                        </c:forEach>
                    </select>
                </div>
                <div>
                    <label for="patientTypes">Patient Types<span style="display:none;">"Choose whether you would like to filter by real patients only, test patients only, or both."</span></label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}"/>">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
        </form>
        <div>
            <input id="searchButton" name="search" title="Search" class="button" type="submit" value="Search" />
        </div>
    </div>
    <%@include file="patientLinkForm.jsp"%>
    <div id="results">
    <div align="right" class="pad-top-5">
        <input id="excelButton" name="excelButton" class="button pad-right-5" type="submit" value="Export To Excel" />
        <input id="csvButton" name="csvButton" class="button" type="submit" value="Export To CSV" />
    </div>
    <div id="divReportContent">
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="dateReceivedHeader" data-tooltip="<c:out value="${descriptors['eventOccurredColumn']}" />">Date Received (CT)</span></th>
                    <th role="columnheader"><span id="ssnHeader" data-tooltip="<c:out value="${descriptors['ssnColumn']}" />">SSN</span></th>
                    <th role="columnheader"><span id="lastNameHeader" data-tooltip="<c:out value="${descriptors['lastNameColumn']}" />">Patient Last Name</span></th>
                    <th role="columnheader"><span id="firstNameHeader" data-tooltip="<c:out value="${descriptors['firstNameColumn']}" />">Patient First Name</span></th>
                    <th role="columnheader"><span id="middleNameHeader" data-tooltip="<c:out value="${descriptors['middleNameColumn']}" />">Patient Middle Name</span></th>
                    <th role="columnheader"><span id="senderHeader" data-tooltip="<c:out value="${descriptors['sendingOrganizationColumn']}" />">Sender</span></th>
                    <th role="columnheader"><span id="pouHeader" data-tooltip="<c:out value="${descriptors['purposeOfUseColumn']}" />">Purpose of Use</span></th>
                    <th role="columnheader"><span id="receiverHeader" data-tooltip="<c:out value="${descriptors['receivingOrganizationColumn']}" />">Receiver</span></th>
                    <th role="columnheader"><span id="messageHeader" data-tooltip="<c:out value="${descriptors['messageColumn']}" />">Message</span></th>
                    <th role="columnheader"><span id="explanationHeader" data-tooltip="<c:out value="${descriptors['explanationOfFailureColumn']}" />">Explanation of Failure</span></th>
                    <th role="columnheader"><span id="detailsHeader" data-tooltip="<c:out value="${descriptors['detailsColumn']}" />" data-tooltip-position="left">Details</span></th>
                </tr>
            </thead>
        </table>
    </div>
    <div>
        <%--This are filled in via datatables data callback--%>
        <div id='realPatientInfo' style="display: none">
            <p><b>Total Real Patient Messages: </b><span id="realPatientMessages"></span></p>
            <p><b>Total Real Patient Fails: </b><span id="realPatientFails"></span></p>
            <p><b>Total Real Patient Matches: </b><span id="realPatientMatches"></span></p>
            <p><b>Total Unique Real Patients: </b><span id="uniqueRealPatients"></span></p>
        </div>
        <div id='testPatientInfo' style="display: none">
            <p><b>Total Test Patient Messages: </b><span id="testPatientMessages"></span></p>
            <p><b>Total Test Patient Fails: </b><span id="testPatientFails"></span></p>
            <p><b>Total Test Patient Matches: </b><span id="testPatientMatches"></span></p>
            <p><b>Total Unique Test Patients: </b><span id="uniqueTestPatients"></span></p>
        </div>
    </div>
    </div>
</f:mainTemplate>