<%--
    Document   : Patient Details
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
    Edited By : Zachary Tubb
--%>
<%@page import="gov.va.nvap.web.patient.PatientComment"%>
<%@page import="gov.va.nvap.web.patient.PatientDetails.ConsentWrapper"%>
<%@page import="java.util.ArrayList"%>
<%@page import="java.util.List"%>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="gov.va.nvap.service.pdq.PatientCorrelationsResponse"%>
<%@page import="gov.va.nvap.service.pdq.PatientDemographics"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>
<%
    PatientDemographics pd = (PatientDemographics) session.getAttribute("patientDemographics");
    Boolean hasBeenAnnounced = (Boolean) session.getAttribute("hasBeenAnnounced");
    String orgName = (String) session.getAttribute("organizationName");
    String requestId = (String) session.getAttribute("requestId");
    String lastAnnouncement = (String) session.getAttribute("lastAnnouncement");
    List<PatientCorrelationsResponse> correlations = new ArrayList<PatientCorrelationsResponse>();
    correlations = (List<PatientCorrelationsResponse>) session.getAttribute("correlations");
    Boolean isFormUploadAllowed = (Boolean) session.getAttribute("isFormUploadAllowed");
    Long maxFileUploadSize = (Long) session.getAttribute("maxFileUploadSize");
    List<ConsentWrapper> consents = new ArrayList<ConsentWrapper>();
    consents = (List<ConsentWrapper>) session.getAttribute("consents");
    List<PatientComment> patientComments = new ArrayList<PatientComment>();
    patientComments = (List<PatientComment>) session.getAttribute("patientComments");
%>
<%!    
    Date today = new Date( );
    SimpleDateFormat ft = new SimpleDateFormat ("MM/dd/yyyy");
    String reportEndDate = ft.format(today) ;
    String reportStartDate = "01/01/1900";
%>  

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">

<!--
    Most Recent Patient Activity
    Facility Number: <c:out value="${patientDemographics.facilityNumber}" />
Facility Name: <c:out value="${patientDemographics.facilityName}" />
    Date of Activity: <c:choose><c:when test="${!empty patientDemographics.correlationDate}"><c:out value="${patientDemographics.correlationDate}" /></c:when><c:otherwise>N/A</c:otherwise></c:choose>
<%--Date of Activity: <c:choose><c:when test="${!empty patientDemographics.correlationDate}"><fmt:formatDate pattern="MM/dd/yyyy" value="${patientDemographics.correlationDate}" /></c:when><c:otherwise>N/A</c:otherwise></c:choose>--%>
-->
<f:mainTemplate headerText="Patient Details">
    <script type="text/javascript" src="js/OptionTransfer.js"></script>
    <script type="text/javascript" src="modalbox/prototype.js"></script>
    <script type="text/javascript" src="modalbox/scriptaculous.js?load=builder,effects"></script>
    <script type="text/javascript" src="modalbox/modalbox.js"></script>
    <link rel="stylesheet" href="modalbox/modalbox.css" type="text/css" media="screen" />

    <script type="text/javascript">
        var bDocReady = false;
        var opt = new OptionTransfer("list1", "list2");
        opt.setAutoSort(false);
        opt.setDelimiter(",");
        opt.setStaticOptionRegex(new RegExp("^.*?Defense.*?$", "i"));
        opt.saveNewLeftOptions("newLeft");
        opt.saveNewRightOptions("newRight");

        function closeAndReload() {
            Modalbox.hide();
        }
        var collectedReasons = [];
        function collectDelayedReasons(reason) {
            if (reason.checked) {
                collectedReasons.push(reason.value);
            } else {
                var index = collectedReasons.indexOf(reason.value);
                collectedReasons.splice(index, 1);
            }
            collectedReasons.sort();
            document.getElementById('collectedReasons').value = collectedReasons;
        }

        function enableDelayedReasons() {
            var delayed = document.getElementById('delayedValue');
            document.getElementById('delayReasons').style.visibility = delayed.checked ? 'visible' : 'hidden';
            document.getElementById('option1').disabled = delayed.checked ? true : false;
            document.getElementById('signatureDate').disabled = delayed.checked ? true : false;
            var button = document.getElementById('Authorize');
            if (button.value === "Authorize") {
                button.value = "Delay Authorization";
                button.name = "delayAuthorization";
                button.disabled = true;
                if (document.getElementById('option1').checked) {
                    document.getElementById('option1').checked = false;
                }
                document.getElementById('signatureDate').value = '';
            } else {
                button.value = "Authorize";
                button.name = "optIn";
            }
        }
        ;

        function checkDelayed() {
            var isDelayed = document.getElementById('isDelayed');
            var delayedFields = document.getElementById('delayedFields');
            var button = document.getElementById('Authorize');
            if (isDelayed.value !== 'true') {
                delayedFields.style.display = 'block';
            } else {
                delayedFields.style.display = 'none';
                button.value = "Approve";
            }
        }

        function toggleConsents() {
            sessionStorage.setItem('consentsVisibility', toggle('trConsents', 'btnConsents'));
        }
        function toggleCorrelations() {
            sessionStorage.setItem('correlationsVisibility', toggle('trCorrelations', 'btnCorrelations'));
        }
        function togglePatientComments() {
            sessionStorage.setItem('patientCommentsVisibility', toggle('trPatientComments', 'btnPatientComments'));
        }
        function toggle(sectionId, buttonId) {
            var section = document.getElementById(sectionId);
            var button = document.getElementById(buttonId);
            var visibility = section.style.visibility === 'collapse' ? 'visible' : 'collapse';
            updateSection(section, button, visibility);
            return visibility;
        }
        function updateSection(section, button, visibility) {
            section.style.visibility = visibility;
            button.value = visibility === 'visible' ? '-' : '+';
            button.title = (visibility === 'visible' ? 'Collapse' : 'Expand') + ' this section';
        }
        function makeDocReady() {
            bDocReady = true;
            var consentsVisibility = sessionStorage.getItem('consentsVisibility');
            if (consentsVisibility !== null) {
                updateSection(document.getElementById('trConsents'), document.getElementById('btnConsents'), consentsVisibility);
            }
            var correlationsVisibility = sessionStorage.getItem('correlationsVisibility');
            if (correlationsVisibility !== null) {
                updateSection(document.getElementById('trCorrelations'), document.getElementById('btnCorrelations'), correlationsVisibility);
            }
            var patientCommentsVisibility = sessionStorage.getItem('patientCommentsVisibility');
            if (patientCommentsVisibility !== null) {
                updateSection(document.getElementById('trPatientComments'), document.getElementById('btnPatientComments'), patientCommentsVisibility);
            }
        }
        function checkReadyState() {
            if (bDocReady) {
                bDocReady = false;
                return true;
            } else {
                return false;
            }
            function makeDocReady() {
                bDocReady = true;
                var consentsVisibility = sessionStorage.getItem('consentsVisibility');
                if (consentsVisibility !== null) {
                    updateSection(document.getElementById('trConsents'), document.getElementById('btnConsents'), consentsVisibility);
                }
                var correlationsVisibility = sessionStorage.getItem('correlationsVisibility');
                if (correlationsVisibility !== null) {
                    updateSection(document.getElementById('trCorrelations'), document.getElementById('btnCorrelations'), correlationsVisibility);
                }
                var patientCommentsVisibility = sessionStorage.getItem('patientCommentsVisibility');
                if (patientCommentsVisibility !== null) {
                    updateSection(document.getElementById('trPatientComments'), document.getElementById('btnPatientComments'), patientCommentsVisibility);
                }
            }
            function checkReadyState() {
                if (bDocReady) {
                    bDocReady = false;
                    return true;
                } else {
                    return false;
                }
            }
            function sleep(milliseconds) {
                var start = new Date().getTime();
                for (var i = 0; i < 1e7; i++) {
                    if ((new Date().getTime() - start) > milliseconds) {
                        break;
                    }
                }
            }
        }
        function formShow(id) {
            var elmt = document.getElementById(id);
            if (elmt != null) {
                elmt.style.display = "block";
            }
        }
        function formHide(id) {
            var elmt = document.getElementById(id);
            if (elmt != null) {
                elmt.style.display = "none";
            }
        }
        function enableObjectByCheck(obj, arg) {
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                if (obj.checked == true) {
                    elmt.disabled = false;
                } else {
                    elmt.disabled = true;
                }
            }
        }
        function deCheckObject(obj) {
            var elmt = document.getElementById(obj);
            if (elmt != null) {
                elmt.checked = false;
            }
        }

        function enableObject(arg) {
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                elmt.disabled = false;
            }
        }
        function disableObject(arg) {
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                elmt.disabled = true;
            }
        }
        function onRevoke() {
            var elmt = document.getElementById('reason');
            if (elmt != null) {

                if (elmt.value != 'Revoked' && elmt.value != 'New Authorization') {
                    var signatureDate = document.getElementById('signatureDate');
                    var currentDate = new Date();
                    signatureDate.value = currentDate.getMonth() + 1 + "/"
                            + currentDate.getDate() + "/"
                            + currentDate.getFullYear();
                }
                if (elmt.value != 'Patient Deceased') {
                    var deceasedDate = document.getElementById('deceasedDate');
                    var currentDate = new Date();
                    deceasedDate.value = currentDate.getMonth() + 1 + "/"
                            + currentDate.getDate() + "/"
                            + currentDate.getFullYear();
                }
            }
        }
        function enableAllElements() {
            enableObject('signatureDate');
            enableObject('file');
            enableObject('deceasedDate');
        }
        function onOptoutReasonChange(selectedItem) {
            // if selectedItem.value is --Select a reason-- then disable revoke
            // if selectedItem.value is Patient-optedout or --Select a reason-- then disable revoke and enable checkbox
            // if selectedItem.value is anything other than patient-opted-out then enable revoke
            if (selectedItem.value == '') {
                disableObject('Revoke');
                disableObject('revokeValidationCheckBoxInput');
                disableObject('newValidationCheckBoxInput');
                disableObject('signatureDate');
                disableObject('file');
                disableObject('deceasedDate');
                disableObject('revokeAndAuthorize');
                deCheckObject('revokeValidationCheckBoxInput');
                deCheckObject('newValidationCheckBoxInput');
                //formHide('revokeButton');
                formHide('revokeAndAuthorizeButton');
                formHide('revokeValidationCheckBox');
                formHide('revokeDateAndUploadValidation');
                formHide('revokeDateAndUploadValidationPatientDeceased');
                formHide('newValidationCheckBox');
            } else if (selectedItem.value == 'Revoked') {
                disableObject('Revoke');
                enableObject('revokeValidationCheckBoxInput');
                disableObject('newValidationCheckBoxInput');
                enableObject('signatureDate');
                disableObject('file');
                disableObject('deceasedDate');
                disableObject('revokeAndAuthorize');
                deCheckObject('revokeValidationCheckBoxInput');
                deCheckObject('newValidationCheckBoxInput');
                formShow('revokeButton');
                formHide('revokeAndAuthorizeButton');
                formShow('revokeValidationCheckBox');
                formShow('revokeDateAndUploadValidation');
                formHide('revokeDateAndUploadValidationPatientDeceased');
                formHide('newValidationCheckBox');
                enableRevokeAfterValidation('signatureDate', 'Revoke');
            } else if (selectedItem.value == 'Patient Deceased') {
                disableObject('Revoke');
                disableObject('revokeValidationCheckBoxInput');
                disableObject('newValidationCheckBoxInput');
                disableObject('signatureDate');
                disableObject('file');
                enableObject('deceasedDate');
                disableObject('revokeAndAuthorize');
                deCheckObject('revokeValidationCheckBoxInput');
                deCheckObject('newValidationCheckBoxInput');
                formShow('revokeButton');
                formHide('revokeAndAuthorizeButton');
                formHide('revokeValidationCheckBox');
                formHide('revokeDateAndUploadValidation');
                formShow('revokeDateAndUploadValidationPatientDeceased');
                formHide('newValidationCheckBox');
                enableRevokeAfterValidation('deceasedDate', 'Revoke');
            } else if (selectedItem.value == 'New Authorization') {
                disableObject('Revoke');
                disableObject('revokeValidationCheckBoxInput');
                enableObject('newValidationCheckBoxInput');
                enableObject('signatureDate');
                disableObject('file');
                disableObject('deceasedDate');
                disableObject('revokeAndAuthorize');
                formShow('revokeAndAuthorizeButton');
                deCheckObject('revokeValidationCheckBoxInput');
                deCheckObject('newValidationCheckBoxInput');
                disableObject('revokeAndAuthorize');
                formHide('revokeButton');
                formHide('revokeValidationCheckBox');
                formShow('revokeDateAndUploadValidation');
                formHide('revokeDateAndUploadValidationPatientDeceased');
                formShow('newValidationCheckBox');
                enableRevokeAfterValidation('signatureDate', 'Revoke');
            } else {
                enableObject('Revoke');
                disableObject('revokeValidationCheckBoxInput');
                disableObject('newValidationCheckBoxInput');
                disableObject('signatureDate');
                disableObject('file');
                disableObject('deceasedDate');
                disableObject('revokeAndAuthorize');
                deCheckObject('revokeValidationCheckBox');
                deCheckObject('newValidationCheckBox');
                formShow('revokeButton');
                formHide('revokeAndAuthorizeButton');
                formHide('revokeValidationCheckBox');
                formHide('revokeDateAndUploadValidation');
                formHide('revokeDateAndUploadValidationPatientDeceased');
                formHide('newValidationCheckBox');
            }
        }
        function enableAuthorizeAfterValidation(objA, objB, arg) {
            var delayed = document.getElementById('delayedValue');
            var valelmentA = document.getElementById(objA);
            var valelmentB = document.getElementById(objB);
            var elmt = document.getElementById(arg);
            if (delayed !== null && delayed.checked) {
                if (document.getElementById('collectedReasons').value !== '') {
                    elmt.disabled = false;
                } else {
                    elmt.disabled = true;
                }
            } else if (elmt != null) {
                if (valelmentA.value != '' && isDate(valelmentA.value) == true && valelmentB.checked == true) {
                    elmt.disabled = false;
                } else {
                    elmt.disabled = true;
                }
            }
        }
        function enableRevokeAfterValidation(objA, arg) {
            var valelmentA = document.getElementById(objA);
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                var elmtOptionA = document.getElementById('revokeValidationCheckBox');
                var elmtOptionB = document.getElementById('newValidationCheckBox');
                if ((elmtOptionA != null && elmtOptionA.style.display != "none") || (elmtOptionB != null && elmtOptionB.style.display != "none")) {
                    if (elmtOptionA != null && elmtOptionA.style.display != "none") {
                        var valelmentB = document.getElementById('revokeValidationCheckBoxInput');
                    } else {
                        var valelmentB = document.getElementById('newValidationCheckBoxInput');
                        var elmt = document.getElementById('revokeAndAuthorize');
                    }
                    if (valelmentA.value != '' && isDate(valelmentA.value) == true && valelmentB.checked == true) {
                        elmt.disabled = false;
                    } else {
                        elmt.disabled = true;
                    }
                } else {
                    if (valelmentA.value != '' && isDate(valelmentA.value) == true) {
                        elmt.disabled = false;
                    } else {
                        elmt.disabled = true;
                    }
                }
            }
        }
        function enableRestrictAfterValidation(objA, objB, objC, objD, arg) {
            var valelmentA = document.getElementById(objA);
            var valelmentB = document.getElementById(objB);
            var valelmentC = document.getElementById(objC);
            var valelmentD = document.getElementById(objD);
            var elmt = document.getElementById(arg);
            if (elmt != null) {
                if (valelmentA.value != '' && isDate(valelmentA.value) == true && valelmentB.checked == true && valelmentC.length >= 1 && valelmentD.length != 0) {
                    elmt.disabled = false;
                } else {
                    elmt.disabled = true;
                }
            }
        }
        function enableLetterGenerate(field) {
            var signature = document.getElementById(field);
            var button = document.getElementById('Generate');
            if (signature !== null && signature.value !== '') {
                button.disabled = false;
            } else {
                button.disabled = true;
            }
        }
        function isDate(input) {
            if (!/^\d{2}\/\d{2}\/\d{4}$/.test(input)) {
                return false;
            } else {
                var monthfield = input.split("/")[0];
                var dayfield = input.split("/")[1];
                var yearfield = input.split("/")[2];

                var dayobj = new Date(yearfield, monthfield - 1, dayfield);
                if ((dayobj.getMonth() + 1 != monthfield) || (dayobj.getDate() != dayfield) || (dayobj.getFullYear() != yearfield)) {
                    return false;
                } else {
                    return true;
                }
            }
        }
        jQuery(document).ready(function () {
            shouldReload = true;

            jQuery('.vap-old-modal').on('click', function (event) {
                //if (checkReadyState()) {
                if (jQuery(this).data('consent-type') === 'delayed') {
                    var url = 'PatientDetails.do_sec?editMailDatesForm=true&delayedConsentId=' + jQuery(this).data('delayed-consent-id');
                } else {
                    var url = 'PatientDetails.do_sec?editMailDatesForm=true&consentDirId=' + jQuery(this).data('consent-dir-id');
                }

                Modalbox.show(url, {title: jQuery(this).data('title'), width: 600, height: 'auto', afterHide: function () {
                    if (shouldReload) {
                        location.reload();
                    }
                }});
                return false;
            });

            makeDocReady();
        });
    </script>

    <div id="slidetabsmenu">
        <ul>
            <li id="current">
                <a title="Patient Summary" href="PatientDetails.do_sec"><span>Patient Summary</span> </a>
            </li>
            <li>
                <a href="PatientDetails.do_sec?view=true" title="View Health Summary (C32)"><span>Health Summary (C32)</span> </a>
            </li>
        </ul>
        <c:if test="${!empty patients}">
            <a style="float: right; background-color: white" title="Back to Patient Search Results" href="PatientSearchResults.do_sec">Back to Patient Search Results</a>
        </c:if>
    </div>

    <div class="vap-grey-header">
        Patient Information
    </div>

    <%@include file="patientDemographics.jsp"%> <%-- TODO: change up the table (or remove it) from this included file --%>

    <div class="vap-grey-header">
        <div class="pull-left">
            <input id="btnPatientComments" type="button" class="vap-hand-hover" style="border:none; background:none;" value="-" title="Collapse this section" onclick="togglePatientComments();" />
            Comments
        </div>
        <div class="pull-right">
            <a href="PatientDetails.do_sec?addPatientCommentForm=true&patientIen=<c:out value="${patientDemographics.icn}"/>" title="Add Comments" onclick="if (checkReadyState()) {
                    Modalbox.show(this.href, {title: this.title, width: 643, height: 180, afterHide: function () {
                            window.location.href = window.location.href;
                        }});
                    return false;
                } else {
                    return false;
                }">Add Comment</a>
        </div>
        <div class="clearfix"></div>
    </div>

    <div id="trPatientComments" class="pad-bottom-20">
        <%@include file="patientComments.jsp"%>
    </div>

    <div class="vap-grey-header">
        Manage Access to Veteran Health Records
    </div>
    <c:set var="NwHINactiveDelay" value="${NwHINactiveDelay}" />
    <c:set var="SSAactiveDelay" value="${SSAactiveDelay}" />

    <c:choose>
        <c:when test="${!empty consentDirective}">
            <div>
                <span class="vap-grey-bold"><c:out value="${organizationName}"/> Access</span><br />
                <strong>The Veteran has currently authorized the release </strong>
                of protected health information from
                <strong><fmt:formatDate pattern="MM/dd/yyyy" value="${consentDirective.optinDate}" /></strong>
                through <c:out value="${organizationName}"/>.
                <ul>
                    <li>
                        <a href="PatientDetails.do_sec?revokeNwHIN=true" title="Revoke <c:out value="${organizationName}"/>"
                            onclick="if (checkReadyState()) {
                                Modalbox.show(this.href, {title: this.title, width: 900, height: 600, afterHide: function () {
                                        window.location.href = window.location.href;
                                    }});
                                return false;
                            } else {
                                return false;
                            }"><c:out value="${isNewAuthorizationAllowed ? 'Revoke access or submit new authorization' : 'Revoke access'}"/>
                            to Veteran electronic health information (<c:out value="${organizationName}"/>)</a>
                            with non-VA healthcare provider organizations via <c:out value="${organizationName}"/> for the purposes of treatment.
                    </li>
                </ul>
            </div>
        </c:when>
        <c:when test="${NwHINactiveDelay != null}">
            <div>
                <span class="vap-grey-bold"><c:out value="${organizationName}"/> Access</span><br />
                <strong>The Veteran has an authorization to release </strong>
                protected health information through <c:out value="${organizationName}"/> in
                <strong>DELAYED</strong> status, pending final approval.
                Reason<c:if test="${fn:length(NwHINactiveDelay.delayReasonCollection) > 1}">s</c:if> for delay:
                <c:forEach var="r" items="${NwHINactiveDelay.delayReasonCollection}" varStatus="loop">
                    <c:out value="${r.name}"/><c:if test="${fn:length(NwHINactiveDelay.delayReasonCollection) gt 1 and (loop.index lt fn:length(NwHINactiveDelay.delayReasonCollection) - 1)}">,</c:if>
                </c:forEach>
                <ul>
                    <li>
                        > <a href="PatientDetails.do_sec?authorizeDelayNwHIN=true&delayedConsentId=<c:out value="${NwHINactiveDelay.delayedConsentId}"/>"
                            title="Approve Pending <c:out value="${organizationName}"/> Authorization"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title,
                                            width: 900, height: 600, afterLoad: function () {
                                                checkDelayed();
                                            },
                                            afterHide: function () {
                                                window.location.href =
                                                        window.location.href;
                                            }});
                                        return false;
                                    } else {
                                        return false;
                                    }">Approve this authorization</a>
                    </li>
                    <li>
                        > <a href="PatientDetails.do_sec?cancelDelayedAuthorization=true&delayedConsentId=<c:out value="${NwHINactiveDelay.delayedConsentId}"/>"
                            title="Cancel Pending <c:out value="${organizationName}"/> Authorization"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title,
                                            width: 643, height: 180, afterHide: function () {
                                                window.location.href =
                                                        window.location.href;
                                            }});
                                        return false;
                                    } else {
                                        return false;
                                    }">Cancel this authorization</a>
                    </li>
                    <li>
                        > <a href="PatientDetails.do_sec?eheDelay=true&printLetter=true&delayedConsentId=<c:out value="${NwHINactiveDelay.delayedConsentId}"/>"
                            title="Generate Notification Letter of Authorization Delay"
                            onclick="Modalbox.show(this.href, {title: this.title,
                                        width: 900, height: 'auto'});
                                    return false;">Print notification letter</a>
                    </li>
                </ul>
            </div>
        </c:when>
        <c:otherwise>
            <div>
                <span class="vap-grey-bold"><c:out value="${organizationName}"/> Access</span><br />
                <strong>The Veteran has currently NOT authorized the release</strong>
                of protected health information through <c:out value="${organizationName}"/>.
                <ul>
                    <li>
                        > <a href="PatientDetails.do_sec?authorizeNwHIN=true"
                            title="Authorize <c:out value="${organizationName}"/>"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title,
                                            width: 900, height: 600, afterLoad: function () {
                                                checkDelayed();
                                            },
                                            afterHide: function () {
                                                window.location.href = window.location.href;
                                            }});
                                        return false;
                                    } else {
                                        return false;
                                    }">Share Veteran electronic health information (<c:out value="${organizationName}"/>)</a>
                        with non-VA healthcare provider organizations via <c:out value="${organizationName}"/> for the purposes of treatment.
                    </li>
                </ul>
            </div>
        </c:otherwise>
    </c:choose>

    <c:if test="${isOrganizationExclusionsAllowed}">
        <c:choose>
            <c:when test="${!empty nwhinOrganizationRestrictionsDirective}">
                <div>
                    <span class="vap-grey-bold">Restrictions</span><br />
                    <strong>The Veteran currently has Restrictions </strong>
                    that limit the sharing of electronic health information.
                    <ul>
                        <li>
                            > <a href="PatientDetails.do_sec?modifyNwHINOrganizationRestrictions=true"
                                title="View/Modify <c:out value="${organizationName}"/> Organization Restriction"
                                onclick="if (checkReadyState()) {
                                            Modalbox.show(this.href, {title: this.title, width: 900, height: 600, evalScripts: true, afterHide: function () {
                                                    window.location.href = window.location.href;
                                                }});
                                            return false;
                                        } else {
                                            return false;
                                        }">View/Modify Veteran's existing restrictions.</a>
                        </li>
                        <li>
                            > <a href="PatientDetails.do_sec?revokeNwHINOrganizationRestrictions=true"
                                title="Revoke or Terminate <c:out value="${organizationName}"/> Organization Restriction"
                                onclick="if (checkReadyState()) {
                                            Modalbox.show(this.href, {title: this.title, width: 900, height: 600, evalScripts: true, afterHide: function () {
                                                    window.location.href = window.location.href;
                                                }});
                                            return false;
                                        } else {
                                            return false;
                                        }">Revoke
                                or terminate Veteran's existing restrictions</a> that limit the sharing of electronic health information.
                        </li>
                    </ul>
                </div>
            </c:when>
            <c:otherwise>
                <div>
                    <span class="vap-grey-bold">Restrictions</span><br />
                    <strong>The Veteran has currently no restrictions.</strong>
                    <ul>
                        <li>
                            > <a href="PatientDetails.do_sec?authorizeNwHINOrganizationRestrictions=true"
                                title="<c:out value="${organizationName}"/> Restrictions"
                                onclick="if (checkReadyState()) {
                                            Modalbox.show(this.href, {title: this.title, width: 900, height: 600, evalScripts: true, afterHide: function () {
                                                    window.location.href = window.location.href;
                                                }});
                                            return false;
                                            void(0);
                                        } else {
                                            return false;
                                        }">Manage Veteran restrictions</a>
                            that limit the sharing of his/her electronic health information for non-VA healthcare
                            provider organizations via <c:out value="${organizationName}"/> for the purpose of treatment.
                        </li>
                    </ul>
                </div>
            </c:otherwise>
        </c:choose>
    </c:if>
    <c:choose>
        <c:when test="${!empty ssaConsentDirective}">
            <div class="margin-bottom-15">
                <span class="vap-grey-bold">Social Security Administration (SSA) Access</span><br />
                <strong>The Veteran has currently authorized the release of </strong>
                protected health information to the Social Security Administration from
                <strong><fmt:formatDate pattern="MM/dd/yyyy" value="${ssaConsentDirective.optinDate}" /> </strong>
                that expires on
                <strong><fmt:formatDate pattern="MM/dd/yyyy" value="${ssaConsentDirective.expirationDate}" />, </strong>
                through <c:out value="${organizationName}"/>.
                <%--
                <ul>
                    <li>
                        <a href="PatientDetails.do_sec?revokeSSA=true"
                            title="Revoke SSA"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title, width: 900, height: 600, afterHide: function () {
                                                window.location.href = window.location.href;
                                            }});
                                        return false;
                                    } else {
                                        return false;
                                    }"><c:out value="${isSSANewAuthorizationAllowed ? 'Revoke access or submit new authorization' : 'Revoke Access'}"/> to Veteran health information with the Social Security Administration</a>
                        via <c:out value="${organizationName}"/> for the purposes of receiving disability benefits (Coverage).
                    </li>
                </ul>
                --%>
            </div>
        </c:when>
        <%--
        <c:when test="${SSAactiveDelay != null}">
            <div>
                <span class="vap-grey-bold">Social Security Administration (SSA) Access</span><br />
                <strong>The Veteran has an authorization to release </strong>
                protected health information through Social Security Administration (SSA) in <strong>DELAYED</strong> status, pending final approval.
                Reason<c:if test="${fn:length(SSAactiveDelay.delayReasonCollection) > 1}">s</c:if>
                for delay:
                <c:forEach var="r" items="${SSAactiveDelay.delayReasonCollection}" varStatus="loop">
                    <c:out value="${r.name}"/><c:if test="${fn:length(SSAactiveDelay.delayReasonCollection) gt 1 and (loop.index lt fn:length(SSAactiveDelay.delayReasonCollection) - 1)}">,</c:if>
                </c:forEach>
                <ul>
                    <li>
                        > <a href="PatientDetails.do_sec?authorizeDelaySSA=true&delayedConsentId=<c:out value="${SSAactiveDelay.delayedConsentId}"/>"
                            title="Approve Pending Social Security Administration (SSA) Authorization"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title,
                                            width: 900, height: 600, afterLoad: function () {
                                                checkDelayed();
                                            },
                                            afterHide: function () {
                                                window.location.href =
                                                        window.location.href;
                                            }});
                                        return false;
                                    } else {
                                        return false;
                                    }">Approve this authorization</a>
                    </li>
                    <li>
                        > <a href="PatientDetails.do_sec?cancelDelayedAuthorization=true&delayedConsentId=<c:out value="${SSAactiveDelay.delayedConsentId}"/>"
                            title="Cancel Pending SSA Authorization"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title,
                                            width: 643, height: 180, afterHide: function () {
                                                window.location.href =
                                                        window.location.href;
                                            }});
                                        return false;
                                    } else {
                                        return false;
                                    }">Cancel this authorization</a>
                    </li>
                    <li>
                        > <a href="PatientDetails.do_sec?ssaDelay=true&printLetter=true&delayedConsentId=<c:out value="${SSAactiveDelay.delayedConsentId}"/>"
                            title="Generate Notification Letter of Authorization Delay"
                            onclick="Modalbox.show(this.href, {title: this.title,
                                        width: 900, height: 'auto'});
                                    return false;">Print notification letter</a>
                    </li>
                </ul>
            </div>
        </c:when>
        --%>
        <c:otherwise>
            <div class="margin-bottom-15">
                <span class="vap-grey-bold">Social Security Administration (SSA) Access</span><br />
                <strong>The Veteran has currently NOT authorized the release of </strong>
                protected health information to the Social Security Administration through <c:out value="${organizationName}"/>.
                <%--
                <ul>
                    <li>
                        > <a href="PatientDetails.do_sec?authorizeSSA=true"
                            title="Authorize SSA"
                            onclick="if (checkReadyState()) {
                                        Modalbox.show(this.href, {title: this.title,
                                            width: 900, height: 600, afterHide: function ()
                                            {
                                                window.location.href = window.location.href;
                                            }});
                                        return false;
                                    } else
                                    {
                                        return false;
                                    }">Share Veteran health information with the Social Security Administration</a>
                        via <c:out value="${organizationName}"/> for the purposes of
                        receiving disability benefits (Coverage).
                    </li>
                </ul>
                --%>
            </div>
        </c:otherwise>
    </c:choose>

    <%--Adding DIV for Patient bulk download --%>
    <cpp:userInRole role="VAPApplicationReportsUser">
        <div class="margin-bottom-15">
            <span class="vap-grey-bold">Data Quality Export</span><br />
            <strong>Download all documents for the patient that were referenced by an eHealth Exchange Adapter Audit</strong>
            <ul>
                <li>> <a
                    href="AdapterDateRangeReport.do_sec?startDate=<c:out value='<%=reportStartDate%>'/>&endDate=<c:out value='<%=reportEndDate%>'/>&patientIdentifier=<c:out value="${patientDemographics.icn}"/>"
                    title="Download Audited Patient Documents">Download Documents</a>
                </li>
            </ul>
        </div>
    </cpp:userInRole>

    <div class="vap-grey-header">
        Announce
    </div>

    <div>
        <%@include file="announce.jsp"%>
    </div>

    <c:if test="${!empty consents}">
        <div class="vap-grey-header">
            <input id="btnConsents" type="button" class="vap-hand-hover" style="border:none; background:none;" value="-" title="Collapse this section" onclick="toggleConsents();" />
            Status History
        </div>

        <div id="trConsents" class="pad-bottom-20">
            <%@include file="consentHistory.jsp"%>
        </div>
    </c:if>

    <div class="vap-grey-header">
        <input id="btnCorrelations" type="button" class="vap-hand-hover" style="border:none; background:none;" value="-" title="Collapse this section" onclick="toggleCorrelations();" />
        <c:out value="${organizationName}"/> Correlations
    </div>

    <div id="trCorrelations">
        <%@include file="correlations.jsp" %>
    </div>

</f:mainTemplate>
