<%-- 
    Document   : Patient Demographics
    Created By : David Vasquez / Robert Snelling
    Modified By: Asha Amritraj
    Modified By: Darren Henderson
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp"%>

<!-- THE BODY CONTENT START -->
<div class="form-container">
    <table id="ver-zebra" role="presentation">
        <colgroup>
            <col class="vzebra-odd" width="20%"/>
            <col class="vzebra-even" width="30%"/>
            <col class="vzebra-odd" width="20%"/>
            <col class="vzebra-even" width="30%"/>
        </colgroup>
        <tbody>
            <tr role="row">
                <td role="gridcell">Name</td>
                <td role="gridcell" class="no-border">
                    <c:out value="${patientDemographics.prefix}" />
                    <c:out value="${patientDemographics.firstName}" /> <c:out value="${patientDemographics.middleName}" />
                    <c:out value="${patientDemographics.lastName}" /> <c:out value="${patientDemographics.suffix}" />
                </td>
                <td role="gridcell" class="no-border">Date of Birth</td>
                <td role="gridcell" class="no-border"><fmt:formatDate pattern="MM/dd/yyyy" value="${patientDemographics.dob}" /></td>
            </tr>
            <tr role="row">
                <td role="gridcell">Address</td>
                <td role="gridcell">
                    <c:if test="${!empty patientDemographics.streetAddressLine1}"> <c:out value="${patientDemographics.streetAddressLine1}" /><br /></c:if> 
                    <c:if test="${!empty patientDemographics.streetAddressLine2}"> <c:out value="${patientDemographics.streetAddressLine2}" /><br /></c:if> 
                    <c:if test="${!empty patientDemographics.streetAddressLine3}"> <c:out value="${patientDemographics.streetAddressLine3}" /><br /></c:if> 
                    <c:out value="${patientDemographics.residenceCity}" />, <c:out value="${patientDemographics.residenceState}" />&nbsp;&nbsp;<c:out value="${patientDemographics.residenceZip4}" />
                </td>
                <td role="gridcell">Phone #</td>
                <td role="gridcell"><c:out value="${patientDemographics.residencePhoneNumber}" /></td>
            </tr>
            <tr role="row">
                <td role="gridcell">Gender</td>
                <td role="gridcell">
                    <c:choose>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.gender, 'M')==true}"> Male </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.gender, 'F')==true}"> Female </c:when>
                        <c:otherwise> <c:out value="${patientDemographics.gender}" /> </c:otherwise>
                    </c:choose>
                </td>
                <td role="gridcell">Marital Status</td>
                <td role="gridcell">
                    <c:choose>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'M')==true}"> Married </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'S')==true}"> Single </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'D')==true}"> Divorced </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'W')==true}"> Widowed </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'P')==true}"> Separated </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'C')==true}"> Correction </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.maritalStatus, 'DP')==true}"> Domestic Partner </c:when>
                        <c:otherwise> <c:out value="${patientDemographics.maritalStatus}" /> </c:otherwise>
                    </c:choose>
                </td>
            </tr>
            <tr role="row">
                <td role="gridcell">ICN</td>
                <td role="gridcell"><c:out value="${patientDemographics.icn}" /></td>
                <td role="gridcell">SSN</td>
                <td role="gridcell"><c:out value="${patientDemographics.ssn}" /></td>
            </tr>
            <tr role="row">
                <td role="gridcell">Multiple Birth</td>
                <td role="gridcell">
                    <c:choose>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.multipleBirthIndicator, 'N')==true}"> NO </c:when>
                        <c:when test="${fn:containsIgnoreCase(patientDemographics.multipleBirthIndicator, 'Y')==true}"> YES </c:when>
                        <c:otherwise> <c:out value="${patientDemographics.multipleBirthIndicator}" /> </c:otherwise>
                    </c:choose>
                </td>
                <td role="gridcell">&nbsp;</td>
                <td role="gridcell">&nbsp;</td>
            </tr>
        </tbody>
    </table>
</div>