<%-- 
    Document   : Patient Comments
    Created By : Johann Sonnenberg
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<div>
    <table class="vap-old-table">
        <thead>
            <tr role="row">
                <th role="columnheader" width="180">Date</th>
                <th role="columnheader" width="150">User</th>
                <th role="columnheader">Comments</th>
            </tr>
        </thead>
        <tbody>
            <c:forEach var="c" items="${patientComments}">
                <c:if test="${!empty c.comments}">
                    <tr role="row">
                        <td valign="top" role="gridcell"><fmt:formatDate pattern="MM/dd/yyyy hh:mm:ss aa" value="${c.dateAdded}"/> CT</td>
                        <td valign="top" role="gridcell"><c:out value="${c.userId}" /></td>
                        <td valign="top" style="white-space: pre-wrap;" role="gridcell"><c:out value="${c.comments}"/></td>
                    </tr>
                </c:if>
            </c:forEach>
            <c:if test="${empty patientComments}">
                <tr role="row">
                    <td role="gridcell" colspan="3">No comments found at this time.</td>
                </tr>
            </c:if>
        </tbody>
    </table>
</div>