<%--
    Document   : optInSummaryReport
    Created on : Dec 4, 2014
    Author     : Irakli Kakushadze
--%>
<%@page import="gov.va.nvap.svc.facility.data.Facility"%>
<%@page import="java.util.HashMap"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib tagdir="/WEB-INF/tags/cpp" prefix="cpp" %>
<%@taglib tagdir="/WEB-INF/tags/date" prefix="date" %>
<%@taglib tagdir="/WEB-INF/tags/formatting" prefix="f" %>
<%@page import="java.util.*" %>

<%
    HashMap tips = (HashMap) session.getAttribute("descriptors");
    String facilityFilterTooltip = (String) tips.get("authenticatingFacilityField");
    Facility defaultUserFacility = (Facility) session.getAttribute("defaultUserFacility");
    String defaultUserFacilityName = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityName();
    String defaultUserFacilityStation = defaultUserFacility == null ? "" : defaultUserFacility.getFacilityStation();
    pageContext.setAttribute("facilityFilterTooltip", facilityFilterTooltip);
    pageContext.setAttribute("defaultUserFacility", defaultUserFacility);
    pageContext.setAttribute("defaultUserFacilityName", defaultUserFacilityName);
    pageContext.setAttribute("defaultUserFacilityStation", defaultUserFacilityStation);
%>

<f:mainTemplate headerText="Opt-In Patients Summary Report">
    <head>
        <%@include file="reportCommon.jsp" %>
        <%@include file="metaCommon.jsp" %>
        <script language="JavaScript">
            $(document).ready(function () {
                setProcessingForDataTable('reportTable', -14);

                var reportTable = $('#reportTable').DataTable({
                    deferLoading: 0,
                    destroy:true,
                    ajax: constructUrl("doSearch"),
                    columnDefs: [
                        {className: "dt-head-center", targets: [0]},
                        {className: "dt-head-center dt-body-right", targets: [1,2,3]}
                    ],
                    info: false,
                    language: {
                        emptyTable: "No records found",
                        loadingRecords: ""
                    },
                    paging: false,
                    processing: true,
                    searching: false,
                    serverSide: true,
                    scrollX:true,
                    initComplete: function(){
                        // Enable THEAD scroll bars
                        $('.dataTables_scrollHead').css('overflow', 'auto');

                        // Sync THEAD scrolling with TBODY
                        $('.dataTables_scrollHead').on('scroll', function () {
                            $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                        });
                    },
                    "footerCallback": function ( row, data, start, end, display ) {
                        var api = this.api(), data;

                        // Update footers
                        $(api.column(1).footer() ).html(
                            api.column(1, {page:'current'}).data().sum()
                        );
                        $(api.column(2).footer() ).html(
                            api.column(2, {page:'current'}).data().sum()
                        );
                        $(api.column(3).footer() ).html(
                            api.column(3, {page:'current'}).data().sum()
                        );
                    }
                });

                // DataTable overrides
                $.fn.dataTable.ext.errMode = 'none';

                reportTable.on('draw', function () {
                    addAriaToDataTable('reportTable', reportTable);
                });

                $('#searchButton').on('click', function () {
                    $('#results').show();
                    reportTable.ajax.url(constructUrl('doSearch')).load();
                });

                $('.exportButton').on('click', function() {
                    window.location.href = constructUrl($(this).data('method'));
                    return false;
                });

                function constructUrl(methodName) {
                    var url = 'OptInSummaryReport.do_sec' +
                        '?' + methodName + '=true' +
                        '&aggregateAtFacilityLevel=' + facilitiesDialog.getAggregateAtFacilityLevel() +
                        '&includeUnknownVisn=' + facilitiesDialog.getIncludeUnknownVisn() +
                        '&patientTypes=' + $('#patientTypes').val() +
                        '&stationNumbers=' + facilitiesDialog.getSelectedStationNumbers() +
                        '&sortBy=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][0] +
                        '&sortOrder=' + $('#reportTable').dataTable().fnSettings().aaSorting[0][1] ;

                    return url;
                };

                $('#results').hide();
            });
        </script>
        <title>Veterans Authorization & Preferences Opt-In Patients Summary Report</title>
    </head>
    <div class="form-container">
       <form name="searchForm">
            <fieldset>
                <legend>Search</legend>
                <jsp:include page="reporting/common/facilitiesFilter.jsp">
                    <jsp:param name="defaultUserFacility" value="${defaultUserFacility}" />
                    <jsp:param name="defaultUserFacilityName" value="${defaultUserFacilityName}" />
                    <jsp:param name="defaultUserFacilityStation" value="${defaultUserFacilityStation}" />
                    <jsp:param name="facilityFilterTooltip" value="${facilityFilterTooltip}" />
                </jsp:include>
                <div>
                    <label for="patientTypes">Patient Types</label>
                    <select id="patientTypes" name="patientTypes" data-tooltip="<c:out value="${descriptors['patientTypesField']}" />">
                        <option value="3">ALL</option>
                        <option value="1" selected>Real Patients</option>
                        <option value="2">Test Patients</option>
                    </select>
                </div>
            </fieldset>
            <div>
                <input name="searchButton" id="searchButton" title="Search" class="button" type="button" value="Search" />
            </div>
        </form>
    </div>
    <div id="results">
    <div align="right" class="pad-top-5 pad-bottom-15">
        <a href="#"><button class="exportButton" data-method="exportToExcel" title="Export to Excel">Export to Excel</button></a>
    </div>
    <div id="divReportContent">
        <div aria-live="polite" role="status" id="reportTable_info" class="dataTables_info hidden">Shows summary of opt-in patients</div><%-- because we don't have the "Showing x of x" turned on for this table, we need this here to support aria --%>
        <table id="reportTable" class="display" width="100%" cellspacing="0" role="presentation">
            <thead>
                <tr role="row">
                    <th role="columnheader"><span id="authenticatingFacilityHeader" data-tooltip="<c:out value="${descriptors['authenticatingFacilityColumn']}" />">Authenticating Facility</span></th>
                    <th role="columnheader"><span id="eHealthExchangeAuthorizationHeader" data-tooltip="<c:out value="${descriptors['eHealthExchangeAuthorizationColumn']}" />">eHealth Exchange Authorizations</span></th>
                    <th role="columnheader"><span id="ssaAuthorizationHeader" data-tooltip="<c:out value="${descriptors['eHealthExchangeSSAAuthorizationColumn']}" />">SSA Authorizations</span></th>
                    <th role="columnheader"><span id="facilityTotalHeader" data-tooltip="<c:out value="${descriptors['eHealthExchangeAuthorizationProcessedTotal']}" />" data-tooltip-position="left">Facility Total</span></th>
                </tr>
            </thead>
            <tfoot>
                <tr role="row">
                    <%--Filled in via Datatables for column totals--%>
                    <td role="gridcell" class="footer-bold-pad-left-8 text-left">Total:</td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                    <td role="gridcell" class="footer-bold-pad-right-9 text-right"></td>
                </tr>
            </tfoot>
        </table>
    </div>
    </div>
</html>
</f:mainTemplate>